/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.LinkedByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class PackedDecode
implements Decoder {
    public static final int HEADER_MASK = 192;
    public static final int ELEMENT_START = 64;
    public static final int ELEMENT_END = 128;
    public static final int ATTRIBUTE = 192;
    public static final int HEADEREXTEND_MASK = 32;
    public static final int ELEMENTID_MASK = 31;
    public static final int RAWDATA_MASK = 127;
    public static final int RAWDATA_BITSPERBYTE = 7;
    public static final int RAWDATA_MARKER = 128;
    public static final int TYPECODE_SHIFT = 4;
    public static final int LENGTHCODE_MASK = 15;
    public static final int TYPECODE_BOOLEAN = 1;
    public static final int TYPECODE_SIGNEDINT_POSITIVE = 2;
    public static final int TYPECODE_SIGNEDINT_NEGATIVE = 3;
    public static final int TYPECODE_UNSIGNEDINT = 4;
    public static final int TYPECODE_ADDRESSSPACE = 5;
    public static final int TYPECODE_SPECIALSPACE = 6;
    public static final int TYPECODE_STRING = 7;
    public static final int SPECIALSPACE_STACK = 0;
    public static final int SPECIALSPACE_JOIN = 1;
    public static final int SPECIALSPACE_FSPEC = 2;
    public static final int SPECIALSPACE_IOP = 3;
    public static final int SPECIALSPACE_SPACEBASE = 4;
    private AddressFactory addrFactory;
    protected AddressSpace[] spaces;
    private LinkedByteBuffer inStream;
    private LinkedByteBuffer.Position startPos;
    private LinkedByteBuffer.Position curPos;
    private LinkedByteBuffer.Position endPos;
    private boolean attributeRead;

    public PackedDecode(AddressFactory addrFactory) {
        this.addrFactory = addrFactory;
        this.inStream = null;
        this.startPos = new LinkedByteBuffer.Position();
        this.curPos = new LinkedByteBuffer.Position();
        this.endPos = new LinkedByteBuffer.Position();
        this.buildAddrSpaceArray();
    }

    private void buildAddrSpaceArray() {
        AddressSpace[] allSpaces;
        ArrayList<AddressSpace> spaceList = new ArrayList<AddressSpace>();
        for (AddressSpace spc : allSpaces = this.addrFactory.getAllAddressSpaces()) {
            int type = spc.getType();
            if (type != 0 && type != 1 && type != 4 && type != 3 && type != 7) continue;
            int ind = spc.getUnique();
            while (spaceList.size() <= ind) {
                spaceList.add(null);
            }
            spaceList.set(ind, spc);
        }
        this.spaces = new AddressSpace[spaceList.size()];
        spaceList.toArray(this.spaces);
    }

    private long readInteger(int len) throws DecoderException {
        long res = 0L;
        while (len > 0) {
            res <<= 7;
            res |= (long)(this.curPos.getNextByte() & 0x7F);
            --len;
        }
        return res;
    }

    private void findMatchingAttribute(AttributeId attribId) throws DecoderException {
        byte header1;
        this.curPos.copy(this.startPos);
        while (((header1 = this.curPos.getByte()) & 0xC0) == 192) {
            int id = header1 & 0x1F;
            if ((header1 & 0x20) != 0) {
                id <<= 7;
                id |= this.curPos.getBytePlus1() & 0x7F;
            }
            if (attribId.id() == id) {
                return;
            }
            this.skipAttribute();
        }
        throw new DecoderException("Attribute " + attribId.name() + " is not present");
    }

    private void skipAttribute() throws DecoderException {
        byte typeByte;
        int attribType;
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        if ((attribType = (typeByte = this.curPos.getNextByte()) >> 4) == 1 || attribType == 6) {
            return;
        }
        int length = typeByte & 0xF;
        if (attribType == 7) {
            length = (int)this.readInteger(length);
        }
        this.curPos.advancePosition(length);
    }

    private void skipAttributeRemaining(byte typeByte) throws DecoderException {
        int attribType = typeByte >> 4;
        if (attribType == 1 || attribType == 6) {
            return;
        }
        int length = typeByte & 0xF;
        if (attribType == 7) {
            length = (int)this.readInteger(length);
        }
        this.curPos.advancePosition(length);
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }

    @Override
    public void clear() {
        this.inStream = null;
    }

    @Override
    public void open(int max, String source) {
        this.inStream = new LinkedByteBuffer(max, source);
    }

    @Override
    public void ingestStream(InputStream stream) throws IOException {
        this.inStream.ingestStream(stream);
    }

    @Override
    public void endIngest() {
        this.inStream.pad(128);
        this.inStream.getStartPosition(this.endPos);
    }

    @Override
    public boolean isEmpty() {
        return this.inStream == null;
    }

    @Override
    public int peekElement() throws DecoderException {
        byte header1 = this.endPos.getByte();
        if ((header1 & 0xC0) != 64) {
            return 0;
        }
        int id = header1 & 0x1F;
        if ((header1 & 0x20) != 0) {
            id <<= 7;
            id |= this.endPos.getBytePlus1() & 0x7F;
        }
        return id;
    }

    @Override
    public int openElement() throws DecoderException {
        byte header1 = this.endPos.getByte();
        if ((header1 & 0xC0) != 64) {
            return 0;
        }
        this.endPos.getNextByte();
        int id = header1 & 0x1F;
        if ((header1 & 0x20) != 0) {
            id <<= 7;
            id |= this.endPos.getNextByte() & 0x7F;
        }
        this.startPos.copy(this.endPos);
        this.curPos.copy(this.endPos);
        header1 = this.curPos.getByte();
        while ((header1 & 0xC0) == 192) {
            this.skipAttribute();
            header1 = this.curPos.getByte();
        }
        this.endPos.copy(this.curPos);
        this.curPos.copy(this.startPos);
        this.attributeRead = true;
        return id;
    }

    @Override
    public int openElement(ElementId elemId) throws DecoderException {
        int id = this.openElement();
        if (id != elemId.id()) {
            if (id == 0) {
                throw new DecoderException("Expecting <" + elemId.name() + "> but did not scan an element");
            }
            throw new DecoderException("Expecting <" + elemId.name() + "> but id did not match");
        }
        return id;
    }

    @Override
    public void closeElement(int id) throws DecoderException {
        byte header1 = this.endPos.getNextByte();
        if ((header1 & 0xC0) != 128) {
            throw new DecoderException("Expecting element close");
        }
        int closeId = header1 & 0x1F;
        if ((header1 & 0x20) != 0) {
            closeId <<= 7;
            closeId |= this.endPos.getNextByte() & 0x7F;
        }
        if (id != closeId) {
            throw new DecoderException("Did not see expected closing element");
        }
    }

    @Override
    public void closeElementSkipping(int id) throws DecoderException {
        ArrayList<Integer> idstack = new ArrayList<Integer>();
        idstack.add(id);
        do {
            int header1;
            if ((header1 = this.endPos.getByte() & 0xC0) == 128) {
                int pos = idstack.size() - 1;
                this.closeElement((Integer)idstack.get(pos));
                idstack.remove(pos);
                continue;
            }
            if (header1 == 64) {
                idstack.add(this.openElement());
                continue;
            }
            throw new DecoderException("Corrupt stream");
        } while (!idstack.isEmpty());
    }

    @Override
    public int getNextAttributeId() throws DecoderException {
        byte header1;
        if (!this.attributeRead) {
            this.skipAttribute();
        }
        if (((header1 = this.curPos.getByte()) & 0xC0) != 192) {
            return 0;
        }
        int id = header1 & 0x1F;
        if ((header1 & 0x20) != 0) {
            id <<= 7;
            id |= this.curPos.getBytePlus1() & 0x7F;
        }
        this.attributeRead = false;
        return id;
    }

    @Override
    public void rewindAttributes() {
        this.curPos.copy(this.startPos);
        this.attributeRead = true;
    }

    @Override
    public boolean readBool() throws DecoderException {
        byte typeByte;
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        if ((typeByte = this.curPos.getNextByte()) >> 4 != 1) {
            throw new DecoderException("Expecting boolean attribute");
        }
        this.attributeRead = true;
        return (typeByte & 0xF) != 0;
    }

    @Override
    public boolean readBool(AttributeId attribId) throws DecoderException {
        this.findMatchingAttribute(attribId);
        boolean res = this.readBool();
        this.curPos.copy(this.startPos);
        return res;
    }

    @Override
    public long readSignedInteger() throws DecoderException {
        long res;
        byte typeByte;
        int typeCode;
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        if ((typeCode = (typeByte = this.curPos.getNextByte()) >> 4) == 2) {
            res = this.readInteger(typeByte & 0xF);
        } else if (typeCode == 3) {
            res = this.readInteger(typeByte & 0xF);
            res = -res;
        } else {
            this.skipAttributeRemaining(typeByte);
            throw new DecoderException("Expecting signed integer attribute");
        }
        this.attributeRead = true;
        return res;
    }

    @Override
    public long readSignedInteger(AttributeId attribId) throws DecoderException {
        this.findMatchingAttribute(attribId);
        long res = this.readSignedInteger();
        this.curPos.copy(this.startPos);
        return res;
    }

    @Override
    public long readSignedIntegerExpectString(String expect, long expectval) throws DecoderException {
        long res;
        byte typeByte;
        int typeCode;
        LinkedByteBuffer.Position tmpPos = new LinkedByteBuffer.Position();
        tmpPos.copy(this.curPos);
        byte header1 = tmpPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            tmpPos.getNextByte();
        }
        if ((typeCode = (typeByte = tmpPos.getNextByte()) >> 4) == 7) {
            String val = this.readString();
            if (!val.equals(expect)) {
                throw new DecoderException("Expecting string \"" + expect + "\" but read \"" + val + "\"");
            }
            res = expectval;
        } else {
            res = this.readSignedInteger();
        }
        return res;
    }

    @Override
    public long readSignedIntegerExpectString(AttributeId attribId, String expect, long expectval) throws DecoderException {
        this.findMatchingAttribute(attribId);
        long res = this.readSignedIntegerExpectString(expect, expectval);
        this.curPos.copy(this.startPos);
        return res;
    }

    @Override
    public long readUnsignedInteger() throws DecoderException {
        byte typeByte;
        int typeCode;
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        if ((typeCode = (typeByte = this.curPos.getNextByte()) >> 4) != 4) {
            this.skipAttributeRemaining(typeByte);
            throw new DecoderException("Expecting unsigned integer attribute");
        }
        long res = this.readInteger(typeByte & 0xF);
        this.attributeRead = true;
        return res;
    }

    @Override
    public long readUnsignedInteger(AttributeId attribId) throws DecoderException {
        this.findMatchingAttribute(attribId);
        long res = this.readUnsignedInteger();
        this.curPos.copy(this.startPos);
        return res;
    }

    @Override
    public String readString() throws DecoderException {
        byte typeByte;
        int typeCode;
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        if ((typeCode = (typeByte = this.curPos.getNextByte()) >> 4) != 7) {
            this.skipAttributeRemaining(typeByte);
            throw new DecoderException("Expecting string attribute");
        }
        int length = typeByte & 0xF;
        length = (int)this.readInteger(length);
        this.attributeRead = true;
        int curLen = this.curPos.array.length - this.curPos.current;
        if (curLen >= length) {
            String res = new String(this.curPos.array, this.curPos.current, length);
            this.curPos.advancePosition(length);
            return res;
        }
        StringBuilder buf = new StringBuilder();
        String res = new String(this.curPos.array, this.curPos.current, curLen);
        buf.append(res);
        length -= curLen;
        this.curPos.advancePosition(curLen);
        while (length > 0) {
            curLen = this.curPos.array.length - this.curPos.current;
            if (curLen > length) {
                curLen = length;
            }
            res = new String(this.curPos.array, this.curPos.current, curLen);
            buf.append(res);
            length -= curLen;
            this.curPos.advancePosition(curLen);
        }
        res = buf.toString();
        return res;
    }

    @Override
    public String readString(AttributeId attribId) throws DecoderException {
        this.findMatchingAttribute(attribId);
        String res = this.readString();
        this.curPos.copy(this.startPos);
        return res;
    }

    @Override
    public AddressSpace readSpace() throws DecoderException {
        byte header1 = this.curPos.getNextByte();
        if ((header1 & 0x20) != 0) {
            this.curPos.getNextByte();
        }
        byte typeByte = this.curPos.getNextByte();
        int typeCode = typeByte >> 4;
        AddressSpace spc = null;
        if (typeCode == 5) {
            int res = (int)this.readInteger(typeByte & 0xF);
            if (res >= 0 && res < this.spaces.length) {
                spc = this.spaces[res];
            }
            if (spc == null) {
                throw new DecoderException("Unknown address space index");
            }
        } else if (typeCode == 6) {
            int specialCode = typeByte & 0xF;
            if (specialCode == 0) {
                spc = this.addrFactory.getStackSpace();
            } else if (specialCode == 1) {
                spc = AddressSpace.VARIABLE_SPACE;
            } else if (specialCode != 4) {
                throw new DecoderException("Cannot marshal special address space");
            }
        } else {
            this.skipAttributeRemaining(typeByte);
            throw new DecoderException("Expecting space attribute");
        }
        this.attributeRead = true;
        return spc;
    }

    @Override
    public AddressSpace readSpace(AttributeId attribId) throws DecoderException {
        this.findMatchingAttribute(attribId);
        AddressSpace res = this.readSpace();
        this.curPos.copy(this.startPos);
        return res;
    }
}

