/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.database.ManagerDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.List;

public interface FunctionManager
extends ManagerDB {
    public Program getProgram();

    public List<String> getCallingConventionNames();

    public PrototypeModel getDefaultCallingConvention();

    public PrototypeModel getCallingConvention(String var1);

    public PrototypeModel[] getCallingConventions();

    public Function createFunction(String var1, Address var2, AddressSetView var3, SourceType var4) throws InvalidInputException, OverlappingFunctionException;

    public Function createFunction(String var1, Namespace var2, Address var3, AddressSetView var4, SourceType var5) throws InvalidInputException, OverlappingFunctionException;

    public Function createThunkFunction(String var1, Namespace var2, Address var3, AddressSetView var4, Function var5, SourceType var6) throws OverlappingFunctionException;

    public int getFunctionCount();

    public boolean removeFunction(Address var1);

    public Function getFunctionAt(Address var1);

    public Function getReferencedFunction(Address var1);

    public Function getFunctionContaining(Address var1);

    public FunctionIterator getFunctions(boolean var1);

    public FunctionIterator getFunctions(Address var1, boolean var2);

    public FunctionIterator getFunctions(AddressSetView var1, boolean var2);

    public FunctionIterator getFunctionsNoStubs(boolean var1);

    public FunctionIterator getFunctionsNoStubs(Address var1, boolean var2);

    public FunctionIterator getFunctionsNoStubs(AddressSetView var1, boolean var2);

    public FunctionIterator getExternalFunctions();

    public boolean isInFunction(Address var1);

    public Iterator<Function> getFunctionsOverlapping(AddressSetView var1);

    public Variable getReferencedVariable(Address var1, Address var2, int var3, boolean var4);

    public Function getFunction(long var1);

    public FunctionTagManager getFunctionTagManager();

    @Override
    public void invalidateCache(boolean var1);

    @Override
    public void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException;
}

