/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Set;

public interface Function
extends Namespace {
    public static final String DEFAULT_PARAM_PREFIX = "param_";
    public static final String THIS_PARAM_NAME = AutoParameterType.THIS.getDisplayName();
    public static final String RETURN_PTR_PARAM_NAME = AutoParameterType.RETURN_STORAGE_PTR.getDisplayName();
    public static final int DEFAULT_PARAM_PREFIX_LEN = "param_".length();
    public static final String DEFAULT_LOCAL_PREFIX = "local_";
    public static final String DEFAULT_LOCAL_RESERVED_PREFIX = "local_res";
    public static final String DEFAULT_LOCAL_TEMP_PREFIX = "temp_";
    public static final int DEFAULT_LOCAL_PREFIX_LEN = "local_".length();
    public static final String UNKNOWN_CALLING_CONVENTION_STRING = "unknown";
    public static final String DEFAULT_CALLING_CONVENTION_STRING = "default";
    public static final String INLINE = "inline";
    public static final String NORETURN = "noreturn";
    public static final String THUNK = "thunk";
    public static final int UNKNOWN_STACK_DEPTH_CHANGE = Integer.MAX_VALUE;
    public static final int INVALID_STACK_DEPTH_CHANGE = 0x7FFFFFFE;

    @Override
    public String getName();

    public void setName(String var1, SourceType var2) throws DuplicateNameException, InvalidInputException;

    public void setCallFixup(String var1);

    public String getCallFixup();

    public Program getProgram();

    public String getComment();

    public String[] getCommentAsArray();

    public void setComment(String var1);

    public String getRepeatableComment();

    public String[] getRepeatableCommentAsArray();

    public void setRepeatableComment(String var1);

    public Address getEntryPoint();

    public DataType getReturnType();

    public void setReturnType(DataType var1, SourceType var2) throws InvalidInputException;

    public Parameter getReturn();

    public void setReturn(DataType var1, VariableStorage var2, SourceType var3) throws InvalidInputException;

    public FunctionSignature getSignature();

    public FunctionSignature getSignature(boolean var1);

    public String getPrototypeString(boolean var1, boolean var2);

    public SourceType getSignatureSource();

    public void setSignatureSource(SourceType var1);

    public StackFrame getStackFrame();

    public int getStackPurgeSize();

    public Set<FunctionTag> getTags();

    public boolean addTag(String var1);

    public void removeTag(String var1);

    public void setStackPurgeSize(int var1);

    public boolean isStackPurgeSizeValid();

    @Deprecated
    public Parameter addParameter(Variable var1, SourceType var2) throws DuplicateNameException, InvalidInputException;

    @Deprecated
    public Parameter insertParameter(int var1, Variable var2, SourceType var3) throws DuplicateNameException, InvalidInputException;

    public void replaceParameters(List<? extends Variable> var1, FunctionUpdateType var2, boolean var3, SourceType var4) throws DuplicateNameException, InvalidInputException;

    public void replaceParameters(FunctionUpdateType var1, boolean var2, SourceType var3, Variable ... var4) throws DuplicateNameException, InvalidInputException;

    public void updateFunction(String var1, Variable var2, FunctionUpdateType var3, boolean var4, SourceType var5, Variable ... var6) throws DuplicateNameException, InvalidInputException;

    public void updateFunction(String var1, Variable var2, List<? extends Variable> var3, FunctionUpdateType var4, boolean var5, SourceType var6) throws DuplicateNameException, InvalidInputException;

    public Parameter getParameter(int var1);

    @Deprecated
    public void removeParameter(int var1);

    @Deprecated
    public Parameter moveParameter(int var1, int var2) throws InvalidInputException;

    public int getParameterCount();

    public int getAutoParameterCount();

    public Parameter[] getParameters();

    public Parameter[] getParameters(VariableFilter var1);

    public Variable[] getLocalVariables();

    public Variable[] getLocalVariables(VariableFilter var1);

    public Variable[] getVariables(VariableFilter var1);

    public Variable[] getAllVariables();

    public Variable addLocalVariable(Variable var1, SourceType var2) throws DuplicateNameException, InvalidInputException;

    public void removeVariable(Variable var1);

    public void setBody(AddressSetView var1) throws OverlappingFunctionException;

    public boolean hasVarArgs();

    public void setVarArgs(boolean var1);

    public boolean isInline();

    public void setInline(boolean var1);

    public boolean hasNoReturn();

    public void setNoReturn(boolean var1);

    public boolean hasCustomVariableStorage();

    public void setCustomVariableStorage(boolean var1);

    public PrototypeModel getCallingConvention();

    public String getCallingConventionName();

    public String getDefaultCallingConventionName();

    public void setCallingConvention(String var1) throws InvalidInputException;

    public boolean isThunk();

    public Function getThunkedFunction(boolean var1);

    default public Address[] getFunctionThunkAddresses() {
        return this.getFunctionThunkAddresses(false);
    }

    public Address[] getFunctionThunkAddresses(boolean var1);

    public void setThunkedFunction(Function var1) throws IllegalArgumentException;

    @Override
    public boolean isExternal();

    public ExternalLocation getExternalLocation();

    public Set<Function> getCallingFunctions(TaskMonitor var1);

    public Set<Function> getCalledFunctions(TaskMonitor var1);

    public void promoteLocalUserLabelsToGlobal();

    public boolean isDeleted();

    public static enum FunctionUpdateType {
        CUSTOM_STORAGE,
        DYNAMIC_STORAGE_FORMAL_PARAMS,
        DYNAMIC_STORAGE_ALL_PARAMS;

    }
}

