/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;

public final class DataUtilities {
    private DataUtilities() {
    }

    public static boolean isValidDataTypeName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDefaultData(DataType dt) {
        if (Undefined.isUndefined(dt)) {
            return true;
        }
        if (dt instanceof TypeDef) {
            TypeDef td = (TypeDef)dt;
            if (!td.isAutoNamed()) {
                return false;
            }
            dt = td.getDataType();
        }
        if (dt instanceof Pointer) {
            Pointer p = (Pointer)dt;
            return (dt = p.getDataType()) == null || dt == DataType.DEFAULT;
        }
        return false;
    }

    private static boolean isDataClearingDenied(DataType dt, ClearDataMode clearMode) {
        if (clearMode == ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA && !Undefined.isUndefined(dt)) {
            return true;
        }
        return clearMode == ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA && !DataUtilities.isDefaultData(dt);
    }

    public static Data createData(Program program, Address addr, DataType newType, int length, boolean stackPointers, ClearDataMode clearMode) throws CodeUnitInsertionException {
        Data newData;
        Listing listing = program.getListing();
        ReferenceManager refMgr = program.getReferenceManager();
        Data data = DataUtilities.getData(addr, clearMode, listing);
        int existingLength = addr.getAddressSpace().getAddressableUnitSize();
        DataType existingType = data.getDataType();
        Reference extRef = null;
        if (!DataUtilities.isParentData(data, addr)) {
            existingLength = data.getLength();
            if (data.isDefined() && newType.isEquivalent(existingType)) {
                return data;
            }
            if (!stackPointers && DataUtilities.isDataClearingDenied(existingType, clearMode)) {
                throw new CodeUnitInsertionException("Could not create Data at address " + addr);
            }
            extRef = DataUtilities.getExternalPointerReference(addr, newType, stackPointers, refMgr, existingType);
        }
        newType = newType.clone(program.getDataTypeManager());
        DataType realType = newType = DataUtilities.reconcileAppliedDataType(existingType, newType, stackPointers);
        if (newType instanceof TypeDef) {
            realType = ((TypeDef)newType).getBaseDataType();
        }
        if (DataUtilities.isExistingNonDynamicType(realType, newType, existingType)) {
            return data;
        }
        DataTypeInstance dti = DataUtilities.getDtInstance(program, addr, newType, length, realType);
        if (stackPointers && existingType instanceof Pointer && newType instanceof Pointer) {
            listing.clearCodeUnits(addr, addr, false);
        }
        try {
            newData = listing.createData(addr, dti.getDataType(), dti.getLength());
        }
        catch (CodeUnitInsertionException e) {
            if (clearMode == ClearDataMode.CLEAR_SINGLE_DATA) {
                listing.clearCodeUnits(addr, addr, false);
            } else {
                DataUtilities.checkEnoughSpace(program, addr, existingLength, dti, clearMode);
            }
            newData = listing.createData(addr, dti.getDataType(), dti.getLength());
        }
        DataUtilities.restoreReference(newType, refMgr, extRef);
        return newData;
    }

    private static boolean isParentData(Data data, Address addr) {
        return !data.getAddress().equals(addr);
    }

    private static Data getData(Address addr, ClearDataMode clearMode, Listing listing) throws CodeUnitInsertionException {
        Data data = listing.getDataAt(addr);
        if (data != null) {
            return data;
        }
        if ((clearMode == ClearDataMode.CLEAR_ALL_CONFLICT_DATA || clearMode == ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA || clearMode == ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA) && (data = listing.getDataContaining(addr)) != null && DataUtilities.isDataClearingDenied(data.getDataType(), clearMode)) {
            data = null;
        }
        if (data == null) {
            throw new CodeUnitInsertionException("Could not create Data at address " + addr);
        }
        return data;
    }

    private static DataTypeInstance getDtInstance(Program program, Address addr, DataType newType, int length, DataType realType) throws CodeUnitInsertionException {
        DumbMemBufferImpl memBuf = new DumbMemBufferImpl(program.getMemory(), addr);
        DataTypeInstance dti = length > 0 && realType instanceof Dynamic && ((Dynamic)realType).canSpecifyLength() ? DataTypeInstance.getDataTypeInstance(newType, memBuf, length) : DataTypeInstance.getDataTypeInstance(newType, memBuf);
        if (dti == null) {
            throw new CodeUnitInsertionException("Could not create DataType " + newType.getDisplayName());
        }
        return dti;
    }

    private static boolean isExistingNonDynamicType(DataType realType, DataType newType, DataType existingType) {
        if (realType instanceof Dynamic || realType instanceof FactoryDataType) {
            return false;
        }
        return newType.equals(existingType);
    }

    private static void restoreReference(DataType newType, ReferenceManager refMgr, Reference ref) {
        if (ref == null) {
            return;
        }
        if (!(newType instanceof Pointer)) {
            return;
        }
        ExternalLocation extLoc = ((ExternalReference)ref).getExternalLocation();
        Address fromAddress = ref.getFromAddress();
        SourceType source = ref.getSource();
        RefType type = ref.getReferenceType();
        try {
            refMgr.addExternalReference(fromAddress, 0, extLoc, source, type);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private static Reference getExternalPointerReference(Address addr, DataType newType, boolean stackPointers, ReferenceManager refMgr, DataType existingType) {
        Reference extRef = null;
        if ((stackPointers || newType instanceof Pointer) && existingType instanceof Pointer) {
            Reference[] refs;
            for (Reference ref : refs = refMgr.getReferencesFrom(addr)) {
                if (ref.getOperandIndex() != 0 || !ref.isExternalReference()) continue;
                extRef = ref;
                break;
            }
        }
        return extRef;
    }

    private static void checkEnoughSpace(Program program, Address addr, int existingDataLen, DataTypeInstance dti, ClearDataMode clearMode) throws CodeUnitInsertionException {
        Listing listing = program.getListing();
        Address end = null;
        Address newEnd = null;
        try {
            end = addr.addNoWrap(existingDataLen - 1);
            newEnd = addr.addNoWrap(dti.getLength() - 1);
        }
        catch (AddressOverflowException e) {
            throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
        }
        Instruction instr = listing.getInstructionAfter(end);
        if (instr != null && instr.getMinAddress().compareTo(newEnd) <= 0) {
            throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
        }
        Data definedData = listing.getDefinedDataAfter(end);
        if (definedData == null || definedData.getMinAddress().compareTo(newEnd) > 0) {
            listing.clearCodeUnits(addr, addr, false);
            return;
        }
        if (!(clearMode != ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA && clearMode != ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA || DataUtilities.isDataClearingDenied(definedData.getDataType(), clearMode))) {
            DataUtilities.checkForDefinedData(dti, listing, newEnd, definedData.getMaxAddress(), clearMode);
        } else if (clearMode != ClearDataMode.CLEAR_ALL_CONFLICT_DATA) {
            throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
        }
        listing.clearCodeUnits(addr, newEnd, false);
    }

    private static void checkForDefinedData(DataTypeInstance dti, Listing listing, Address address, Address end, ClearDataMode clearMode) throws CodeUnitInsertionException {
        while (end.compareTo(address) <= 0) {
            Data definedData = listing.getDefinedDataAfter(end);
            if (definedData == null || definedData.getMinAddress().compareTo(address) > 0) {
                return;
            }
            if (DataUtilities.isDataClearingDenied(definedData.getDataType(), clearMode)) {
                throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
            }
            end = definedData.getMaxAddress();
        }
    }

    private static DataType stackPointers(Pointer pointer, DataType dataType) {
        DataType dt = pointer.getDataType();
        if (dt instanceof Pointer) {
            return pointer.newPointer(DataUtilities.stackPointers((Pointer)dt, dataType));
        }
        return pointer.newPointer(dataType);
    }

    public static DataType reconcileAppliedDataType(DataType originalDataType, DataType newDataType, boolean stackPointers) {
        if (newDataType == DataType.DEFAULT) {
            return newDataType;
        }
        DataType resultDt = newDataType;
        if (stackPointers && DataUtilities.isDefaultPointer(newDataType) && originalDataType instanceof Pointer) {
            resultDt = ((Pointer)newDataType).newPointer(originalDataType);
        } else if (stackPointers && originalDataType instanceof Pointer) {
            resultDt = DataUtilities.stackPointers((Pointer)originalDataType, newDataType);
        } else if (newDataType instanceof FunctionDefinition || newDataType instanceof TypeDef && ((TypeDef)newDataType).getBaseDataType() instanceof FunctionDefinition) {
            resultDt = new PointerDataType(newDataType);
        }
        return resultDt;
    }

    private static boolean isDefaultPointer(DataType dt) {
        if (!(dt instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)dt;
        DataType ptrDt = p.getDataType();
        return ptrDt == null || ptrDt == DataType.DEFAULT;
    }

    public static Data getDataAtLocation(ProgramLocation loc) {
        if (loc == null) {
            return null;
        }
        Address addr = loc.getAddress();
        Listing listing = loc.getProgram().getListing();
        Data dataContaining = listing.getDataContaining(addr);
        if (dataContaining == null) {
            return null;
        }
        Data dataAtAddr = dataContaining.getComponent(loc.getComponentPath());
        return dataAtAddr;
    }

    public static Data getDataAtAddress(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(address);
        if (cu instanceof Data) {
            return (Data)cu;
        }
        return null;
    }

    public static Address getMaxAddressOfUndefinedRange(Program program, Address addr) {
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(addr);
        if (data == null || !Undefined.isUndefined(data.getDataType())) {
            return null;
        }
        Address endOfRangeAddress = data.getMaxAddress();
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null) {
            return null;
        }
        Address limitAddress = block.getEnd();
        CodeUnit cu = data;
        while (cu != null) {
            if (cu.getAddress().compareTo(limitAddress) > 0) {
                endOfRangeAddress = limitAddress;
                break;
            }
            if (!(cu instanceof Data) || !Undefined.isUndefined(cu.getDataType())) {
                endOfRangeAddress = cu.getMinAddress().previous();
                break;
            }
            endOfRangeAddress = cu.getMaxAddress();
            cu = listing.getDefinedCodeUnitAfter(endOfRangeAddress);
        }
        if (cu == null) {
            endOfRangeAddress = limitAddress;
        }
        return endOfRangeAddress;
    }

    public static boolean isUndefinedData(Program program, Address addr) {
        Data data = program.getListing().getDataAt(addr);
        return Undefined.isUndefined(data.getDataType());
    }

    public static Data getNextNonUndefinedDataAfter(Program program, Address addr, Address maxAddr) {
        Listing listing = program.getListing();
        Address currentAddress = addr;
        Data data = listing.getDefinedDataAfter(currentAddress);
        while (data != null && Undefined.isUndefined(data.getDataType()) && currentAddress.compareTo(maxAddr) <= 0) {
            currentAddress = data.getMaxAddress();
            data = listing.getDefinedDataAfter(currentAddress);
        }
        if (data != null && data.getAddress().compareTo(maxAddr) > 0) {
            return null;
        }
        return data;
    }

    public static Address findFirstConflictingAddress(Program program, Address addr, int length, boolean ignoreUndefinedData) {
        Address instructionAddr;
        InstructionIterator instructionIter;
        Instruction instruction;
        AddressSet addrSet = new AddressSet(addr, addr.add(length - 1));
        DataIterator definedDataIter = program.getListing().getDefinedData(addrSet, true);
        Data data = null;
        while (definedDataIter.hasNext()) {
            Data d = definedDataIter.next();
            if (ignoreUndefinedData && Undefined.isUndefined(d.getDataType())) continue;
            data = d;
            break;
        }
        Instruction instruction2 = instruction = (instructionIter = program.getListing().getInstructions(addrSet, true)).hasNext() ? instructionIter.next() : null;
        if (data == null && instruction == null) {
            return null;
        }
        if (data == null) {
            return instruction.getMinAddress();
        }
        if (instruction == null) {
            return data.getMinAddress();
        }
        Address dataAddr = data.getMinAddress();
        if (dataAddr.compareTo(instructionAddr = instruction.getAddress()) < 0) {
            return dataAddr;
        }
        return instructionAddr;
    }

    public static boolean isUndefinedRange(Program program, Address startAddress, Address endAddress) {
        MemoryBlock block = program.getMemory().getBlock(startAddress);
        if (block == null || !block.contains(endAddress)) {
            return false;
        }
        if (startAddress.compareTo(endAddress) > 0) {
            return false;
        }
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(startAddress);
        if (data == null || !Undefined.isUndefined(data.getDataType())) {
            return false;
        }
        Address maxAddress = data.getMaxAddress();
        while (maxAddress.compareTo(endAddress) < 0) {
            CodeUnit codeUnit = listing.getDefinedCodeUnitAfter(maxAddress);
            if (codeUnit == null) {
                return true;
            }
            Address minAddress = codeUnit.getMinAddress();
            if (minAddress.compareTo(endAddress) > 0) {
                return true;
            }
            if (!(codeUnit instanceof Data) || !Undefined.isUndefined(((Data)codeUnit).getDataType())) {
                return false;
            }
            maxAddress = codeUnit.getMaxAddress();
        }
        return true;
    }

    public static enum ClearDataMode {
        CHECK_FOR_SPACE,
        CLEAR_SINGLE_DATA,
        CLEAR_ALL_UNDEFINED_CONFLICT_DATA,
        CLEAR_ALL_DEFAULT_CONFLICT_DATA,
        CLEAR_ALL_CONFLICT_DATA;

    }
}

