/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.AbstractDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class DataTypeImpl
extends AbstractDataType {
    private static final SettingsDefinition[] EMPTY_DEFINITIONS = new SettingsDefinition[0];
    protected Settings defaultSettings = SettingsImpl.NO_SETTINGS;
    private List<WeakReference<DataType>> parentList = new ArrayList<WeakReference<DataType>>();
    private UniversalID universalID;
    private SourceArchive sourceArchive;
    private long lastChangeTime;
    private long lastChangeTimeInSourceArchive;

    protected DataTypeImpl(CategoryPath path, String name, DataTypeManager dataMgr) {
        this(path, name, null, null, System.currentTimeMillis(), 0L, dataMgr);
    }

    DataTypeImpl(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dataMgr) {
        super(path, name, dataMgr);
        this.universalID = universalID == null ? UniversalIdGenerator.nextID() : universalID;
        this.sourceArchive = sourceArchive;
        this.lastChangeTime = lastChangeTime;
        this.lastChangeTimeInSourceArchive = lastChangeTimeInSourceArchive;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return null;
    }

    @Override
    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return EMPTY_DEFINITIONS;
    }

    void checkValidName(String checkedName) throws InvalidNameException {
        if (!DataUtilities.isValidDataTypeName(checkedName)) {
            throw new InvalidNameException("Invalid Name: " + checkedName);
        }
    }

    @Override
    public String getPathName() {
        return this.getDataTypePath().getPath();
    }

    @Override
    public int getAlignment() {
        int length = this.getLength();
        if (length < 0) {
            return 1;
        }
        return this.getDataOrganization().getAlignment(this);
    }

    @Override
    public void addParent(DataType dt) {
        this.parentList.add(new WeakReference<DataType>(dt));
    }

    @Override
    public void removeParent(DataType dt) {
        Iterator<WeakReference<DataType>> iterator = this.parentList.iterator();
        while (iterator.hasNext()) {
            WeakReference<DataType> ref = iterator.next();
            DataType dataType = (DataType)ref.get();
            if (dataType == null) {
                iterator.remove();
                continue;
            }
            if (dt != dataType) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public Collection<DataType> getParents() {
        ArrayList<DataType> parents = new ArrayList<DataType>();
        Iterator<WeakReference<DataType>> iterator = this.parentList.iterator();
        while (iterator.hasNext()) {
            WeakReference<DataType> ref = iterator.next();
            DataType dataType = (DataType)ref.get();
            if (dataType == null) {
                iterator.remove();
                continue;
            }
            parents.add(dataType);
        }
        return parents;
    }

    protected void notifySizeChanged() {
        this.notifyParents(dt -> dt.dataTypeSizeChanged(this));
    }

    protected void notifyAlignmentChanged() {
        this.notifyParents(dt -> dt.dataTypeAlignmentChanged(this));
    }

    protected void notifyNameChanged(String oldName) {
        this.notifyParents(dt -> dt.dataTypeNameChanged(this, oldName));
    }

    protected void notifyDeleted() {
        this.notifyParents(dt -> dt.dataTypeDeleted(this));
    }

    protected void notifyReplaced(DataType replacement) {
        this.notifyParents(dt -> dt.dataTypeReplaced(this, replacement));
    }

    protected final void notifyParents(Consumer<DataType> consumer) {
        Iterator<WeakReference<DataType>> iterator = this.parentList.iterator();
        while (iterator.hasNext()) {
            WeakReference<DataType> ref = iterator.next();
            DataType dataType = (DataType)ref.get();
            if (dataType == null) {
                iterator.remove();
                continue;
            }
            consumer.accept(dataType);
        }
    }

    @Override
    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.lastChangeTimeInSourceArchive;
    }

    @Override
    public SourceArchive getSourceArchive() {
        return this.sourceArchive;
    }

    @Override
    public void setSourceArchive(SourceArchive archive) {
        this.sourceArchive = archive;
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalID;
    }

    @Override
    public void replaceWith(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lastChangeTimeInSourceArchive = lastChangeTimeInSourceArchive;
    }

    @Override
    public void setDescription(String description) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't allow the description to be changed.");
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType otherDt = (DataType)obj;
        return otherDt.getDataTypeManager() == this.getDataTypeManager() && this.categoryPath.equals(otherDt.getCategoryPath()) && this.name.equals(otherDt.getName()) && this.isEquivalent(otherDt);
    }
}

