/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.FunctionDefinitionDB;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SymbolUtilities;
import java.io.IOException;

final class ParameterDefinitionDB
implements ParameterDefinition {
    private DataTypeManagerDB dataMgr;
    private DBRecord record;
    private FunctionDefinitionDB parent;
    private FunctionParameterAdapter adapter;

    ParameterDefinitionDB(DataTypeManagerDB dataMgr, FunctionParameterAdapter adapter, FunctionDefinitionDB parent, DBRecord record) {
        this.dataMgr = dataMgr;
        this.parent = parent;
        this.adapter = adapter;
        this.record = record;
    }

    DBRecord getRecord() {
        return this.record;
    }

    long getKey() {
        return this.record.getKey();
    }

    @Override
    public final DataType getDataType() {
        DataType dt = this.dataMgr.getDataType(this.record.getLongValue(1));
        if (dt == null) {
            dt = DataType.DEFAULT;
        }
        return dt;
    }

    @Override
    public void setDataType(DataType type) {
        type = ParameterDefinitionImpl.validateDataType(type, this.dataMgr, false);
        this.getDataType().removeParent(this.parent);
        type = this.dataMgr.resolve(type, null);
        type.addParent(this.parent);
        this.record.setLongValue(1, this.dataMgr.getResolvedID(type));
        this.record.setIntValue(5, type.getLength());
        try {
            this.adapter.updateRecord(this.record);
            this.dataMgr.dataTypeChanged(this.parent, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public String getName() {
        String name = this.record.getString(2);
        if (name == null) {
            name = SymbolUtilities.getDefaultParamName(this.getOrdinal());
        }
        return name;
    }

    @Override
    public int getLength() {
        DataType dt = this.getDataType();
        if (dt != null && dt.getLength() > -1) {
            return dt.getLength();
        }
        return this.record.getIntValue(5);
    }

    @Override
    public void setName(String name) {
        if (SymbolUtilities.isDefaultParameterName(name)) {
            name = null;
        }
        this.record.setString(2, name);
        try {
            this.adapter.updateRecord(this.record);
            this.dataMgr.dataTypeChanged(this.parent, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public String getComment() {
        return this.record.getString(3);
    }

    @Override
    public void setComment(String comment) {
        this.record.setString(3, comment);
        try {
            this.adapter.updateRecord(this.record);
            this.dataMgr.dataTypeChanged(this.parent, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public FunctionDefinition getParent() {
        return this.parent;
    }

    @Override
    public int getOrdinal() {
        return this.record.getIntValue(4);
    }

    @Override
    public boolean isEquivalent(Variable otherVar) {
        if (otherVar == null) {
            return false;
        }
        if (!(otherVar instanceof Parameter)) {
            return false;
        }
        if (this.getOrdinal() != ((Parameter)otherVar).getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), otherVar.getDataType());
    }

    @Override
    public boolean isEquivalent(ParameterDefinition parm) {
        if (parm == null) {
            return false;
        }
        if (this.getOrdinal() != parm.getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), parm.getDataType());
    }

    @Override
    public int compareTo(ParameterDefinition p) {
        return this.getOrdinal() - p.getOrdinal();
    }

    public String toString() {
        return this.getDataType().getName() + " " + this.getName();
    }
}

