/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.SettingDB;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.Union;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

class DataTypeComponentDB
implements InternalDataTypeComponent {
    private final DataTypeManagerDB dataMgr;
    private final ComponentDBAdapter adapter;
    private final DBRecord record;
    private final CompositeDB parent;
    private DataType cachedDataType;
    private int ordinal;
    private int offset;
    private int length;
    private Settings defaultSettings;

    DataTypeComponentDB(DataTypeManagerDB dataMgr, CompositeDB parent, int ordinal, int offset, DataType datatype, int length) {
        this(dataMgr, parent, ordinal, offset);
        this.cachedDataType = datatype;
        this.length = length;
    }

    DataTypeComponentDB(DataTypeManagerDB dataMgr, CompositeDB parent, int ordinal, int offset) {
        this.dataMgr = dataMgr;
        this.parent = parent;
        this.ordinal = ordinal;
        this.offset = offset;
        this.length = 1;
        this.record = null;
        this.adapter = null;
    }

    DataTypeComponentDB(DataTypeManagerDB dataMgr, ComponentDBAdapter adapter, CompositeDB parent, DBRecord record) {
        this.dataMgr = dataMgr;
        this.adapter = adapter;
        this.record = record;
        this.parent = parent;
        this.ordinal = record.getIntValue(6);
        this.offset = record.getIntValue(1);
        this.length = record.getIntValue(5);
        if (this.isZeroBitFieldComponent()) {
            this.length = 0;
        }
    }

    @Override
    public boolean isBitFieldComponent() {
        if (this.record == null) {
            return false;
        }
        long id = this.record.getLongValue(2);
        return DataTypeManagerDB.getTableID(id) == 9;
    }

    @Override
    public boolean isZeroBitFieldComponent() {
        if (this.isBitFieldComponent()) {
            BitFieldDataType bitField = (BitFieldDataType)this.getDataType();
            return bitField.getBitSize() == 0;
        }
        return false;
    }

    public long getKey() {
        return this.record != null ? this.record.getKey() : -1L;
    }

    @Override
    public DataType getDataType() {
        if (this.cachedDataType != null) {
            return this.cachedDataType;
        }
        if (this.record == null) {
            return DataType.DEFAULT;
        }
        long id = this.record.getLongValue(2);
        if (id == -1L) {
            return DataType.DEFAULT;
        }
        return this.dataMgr.getDataType(id);
    }

    @Override
    public Composite getParent() {
        return this.parent;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    boolean containsOffset(int off) {
        if (off == this.offset) {
            return true;
        }
        return off > this.offset && off < this.offset + this.length;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getEndOffset() {
        if (this.length == 0) {
            return this.offset;
        }
        return this.offset + this.length - 1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getComment() {
        if (this.record != null) {
            return this.record.getString(4);
        }
        return null;
    }

    private boolean hasSettings() {
        return this.record != null && this.dataMgr.allowsDefaultComponentSettings() && this.getDataType().getSettingsDefinitions().length != 0;
    }

    @Override
    public Settings getDefaultSettings() {
        if (!this.hasSettings()) {
            return SettingsImpl.NO_SETTINGS;
        }
        if (this.defaultSettings == null) {
            this.defaultSettings = new ComponentDBSettings();
        }
        return this.defaultSettings;
    }

    @Override
    public void setComment(String comment) {
        if (this.record != null) {
            if (StringUtils.isBlank((CharSequence)comment)) {
                comment = null;
            }
            this.record.setString(4, comment);
            this.updateRecord(true);
        }
    }

    @Override
    public String getFieldName() {
        if (this.isZeroBitFieldComponent()) {
            return "";
        }
        if (this.record != null) {
            return this.record.getString(3);
        }
        return null;
    }

    @Override
    public void setFieldName(String name) throws DuplicateNameException {
        if (this.record != null) {
            name = this.checkFieldName(name);
            this.record.setString(3, name);
            this.updateRecord(true);
        }
    }

    private void checkDuplicateName(String name) throws DuplicateNameException {
        DataTypeComponentImpl.checkDefaultFieldName(name);
        for (DataTypeComponentDB comp : this.parent.getDefinedComponents()) {
            if (comp == this || !name.equals(comp.getFieldName())) continue;
            throw new DuplicateNameException("Duplicate field name: " + name);
        }
    }

    private String checkFieldName(String name) throws DuplicateNameException {
        if (name != null) {
            if ((name = name.trim()).length() == 0 || name.equals(this.getDefaultFieldName())) {
                name = null;
            } else {
                this.checkDuplicateName(name);
            }
        }
        return name;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataTypeComponent)) {
            return false;
        }
        DataTypeComponent dtc = (DataTypeComponent)obj;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        if (this.offset != dtc.getOffset() || this.getLength() != dtc.getLength() || this.ordinal != dtc.getOrdinal() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (!(myDt instanceof Pointer) && !myDt.getPathName().equals(otherDt.getPathName())) {
            return false;
        }
        if (myDt instanceof Structure) {
            return otherDt instanceof Structure;
        }
        if (myDt instanceof Union) {
            return otherDt instanceof Union;
        }
        if (myDt instanceof Array) {
            return otherDt instanceof Array;
        }
        if (myDt instanceof Pointer) {
            return otherDt instanceof Pointer;
        }
        if (myDt instanceof TypeDef) {
            return otherDt instanceof TypeDef;
        }
        return myDt.getClass() == otherDt.getClass();
    }

    @Override
    public boolean isEquivalent(DataTypeComponent dtc) {
        boolean aligned;
        DataType myDt = this.getDataType();
        DataType otherDt = dtc.getDataType();
        if (myDt == null || otherDt == null) {
            return false;
        }
        Composite myParent = this.getParent();
        boolean bl = aligned = myParent instanceof Composite ? myParent.isPackingEnabled() : false;
        if (!aligned && this.offset != dtc.getOffset() || !SystemUtilities.isEqual((Object)this.getFieldName(), (Object)dtc.getFieldName()) || !SystemUtilities.isEqual((Object)this.getComment(), (Object)dtc.getComment())) {
            return false;
        }
        if (this.getLength() != dtc.getLength() && myDt instanceof Dynamic) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(myDt, otherDt);
    }

    @Override
    public void update(int newOrdinal, int newOffset, int newLength) {
        if (this.length < 0) {
            throw new IllegalArgumentException("Cannot set data type component length to " + this.length + ".");
        }
        this.ordinal = newOrdinal;
        this.offset = newOffset;
        this.length = newLength;
        if (this.record != null) {
            this.record.setIntValue(6, this.ordinal);
            this.record.setIntValue(1, this.offset);
            this.record.setIntValue(5, this.length);
            this.updateRecord(false);
        }
    }

    void setOffset(int newOffset, boolean updateRecord) {
        this.offset = newOffset;
        if (this.record != null) {
            this.record.setIntValue(1, this.offset);
        }
        if (updateRecord) {
            this.updateRecord(false);
        }
    }

    void setOrdinal(int ordinal, boolean updateRecord) {
        this.ordinal = ordinal;
        if (this.record != null) {
            this.record.setIntValue(6, ordinal);
        }
        if (updateRecord) {
            this.updateRecord(false);
        }
    }

    void setLength(int length, boolean updateRecord) {
        this.length = length;
        if (length < 0) {
            throw new IllegalArgumentException("Cannot set data type component length to " + length + ".");
        }
        if (this.record != null) {
            this.record.setIntValue(5, length);
        }
        if (updateRecord) {
            this.updateRecord(false);
        }
    }

    void updateRecord(boolean setLastChangeTime) {
        if (this.record != null) {
            try {
                this.adapter.updateRecord(this.record);
                if (setLastChangeTime) {
                    long timeNow = System.currentTimeMillis();
                    this.parent.setLastChangeTime(timeNow);
                }
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
    }

    DBRecord getRecord() {
        return this.record;
    }

    void update(String name, DataType dt, String comment) {
        if (this.record != null) {
            if (StringUtils.isBlank((CharSequence)comment)) {
                comment = null;
            }
            this.record.setString(3, name);
            this.record.setLongValue(2, this.dataMgr.getResolvedID(dt));
            this.record.setString(4, comment);
            this.updateRecord(false);
        }
    }

    @Override
    public void setDataType(DataType newDt) {
        if (this.record != null) {
            this.record.setLongValue(2, this.dataMgr.getResolvedID(newDt));
            this.updateRecord(false);
        }
    }

    public String toString() {
        return InternalDataTypeComponent.toString(this);
    }

    boolean isUndefined() {
        return this.record == null && this.cachedDataType == null;
    }

    private class ComponentDBSettings
    implements Settings {
        private ComponentDBSettings() {
        }

        private void settingsChanged() {
            DataTypeComponentDB.this.dataMgr.dataTypeChanged(DataTypeComponentDB.this.getParent(), false);
        }

        public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
            if (settingsDefinition instanceof TypeDefSettingsDefinition) {
                return false;
            }
            for (SettingsDefinition def : DataTypeComponentDB.this.getDataType().getSettingsDefinitions()) {
                if (!def.equals(settingsDefinition)) continue;
                return true;
            }
            return false;
        }

        public Long getLong(String name) {
            SettingDB settingDB = DataTypeComponentDB.this.dataMgr.getSetting(DataTypeComponentDB.this.record.getKey(), name);
            if (settingDB != null) {
                return settingDB.getLongValue();
            }
            return DataTypeComponentDB.this.getDataType().getDefaultSettings().getLong(name);
        }

        public String getString(String name) {
            SettingDB settingDB = DataTypeComponentDB.this.dataMgr.getSetting(DataTypeComponentDB.this.record.getKey(), name);
            if (settingDB != null) {
                return settingDB.getStringValue();
            }
            return DataTypeComponentDB.this.getDataType().getDefaultSettings().getString(name);
        }

        public Object getValue(String name) {
            SettingDB settingDB = DataTypeComponentDB.this.dataMgr.getSetting(DataTypeComponentDB.this.record.getKey(), name);
            if (settingDB != null) {
                return settingDB.getValue();
            }
            return DataTypeComponentDB.this.getDataType().getDefaultSettings().getValue(name);
        }

        public void setLong(String name, long value) {
            if (DataTypeComponentDB.this.dataMgr.updateSettingsRecord(DataTypeComponentDB.this.record.getKey(), name, null, value)) {
                this.settingsChanged();
            }
        }

        public void setString(String name, String value) {
            if (DataTypeComponentDB.this.dataMgr.updateSettingsRecord(DataTypeComponentDB.this.record.getKey(), name, value, -1L)) {
                this.settingsChanged();
            }
        }

        public void setValue(String name, Object value) {
            if (value instanceof Long) {
                this.setLong(name, (Long)value);
            } else if (value instanceof String) {
                this.setString(name, (String)value);
            } else {
                throw new IllegalArgumentException("Value is not a known settings type: " + name);
            }
        }

        public void clearSetting(String name) {
            if (DataTypeComponentDB.this.dataMgr.clearSetting(DataTypeComponentDB.this.record.getKey(), name)) {
                this.settingsChanged();
            }
        }

        public void clearAllSettings() {
            if (DataTypeComponentDB.this.dataMgr.clearAllSettings(DataTypeComponentDB.this.record.getKey())) {
                this.settingsChanged();
            }
        }

        public String[] getNames() {
            return DataTypeComponentDB.this.dataMgr.getSettingsNames(DataTypeComponentDB.this.record.getKey());
        }

        public boolean isEmpty() {
            return this.getNames().length == 0;
        }

        public Settings getDefaultSettings() {
            return DataTypeComponentDB.this.getDataType().getDefaultSettings();
        }
    }
}

