/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.Schema;
import db.StringField;
import db.Table;
import db.util.ErrorHandler;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.properties.IntPropertyMapDB;
import ghidra.program.database.properties.LongPropertyMapDB;
import ghidra.program.database.properties.ObjectPropertyMapDB;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.database.properties.StringPropertyMapDB;
import ghidra.program.database.properties.VoidPropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.ChangeManagerAdapter;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.LanguageTranslatorFactory;
import ghidra.program.util.OldLanguageFactory;
import ghidra.util.Msg;
import ghidra.util.Saveable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.PropertyTypeMismatchException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ProgramUserDataDB
extends DomainObjectAdapterDB
implements ProgramUserData {
    static final int DB_VERSION = 1;
    private static final int UPGRADE_REQUIRED_BEFORE_VERSION = 1;
    private static final String TABLE_NAME = "ProgramUserData";
    private static final Field[] COL_FIELDS = new Field[]{StringField.INSTANCE};
    private static final String[] COL_NAMES = new String[]{"Value"};
    private static final Schema SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Key", COL_FIELDS, COL_NAMES);
    private static final int VALUE_COL = 0;
    private static final String STORED_DB_VERSION = "DB Version";
    private static final String LANGUAGE_VERSION = "Language Version";
    private static final String LANGUAGE_ID = "Language ID";
    private static final String REGISTRY_TABLE_NAME = "PropertyRegistry";
    private static final Field[] REGISTRY_COL_FIELDS = new Field[]{StringField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE, StringField.INSTANCE};
    private static final String[] REGISTRY_COL_NAMES = new String[]{"Owner", "PropertyName", "PropertyType", "SaveableClass"};
    private static final Schema REGISTRY_SCHEMA = new Schema(0, "ID", REGISTRY_COL_FIELDS, REGISTRY_COL_NAMES);
    private static final int PROPERTY_OWNER_COL = 0;
    private static final int PROPERTY_NAME_COL = 1;
    private static final int PROPERTY_TYPE_COL = 2;
    private static final int PROPERTY_CLASS_COL = 3;
    private static final int PROPERTY_TYPE_STRING = 0;
    private static final int PROPERTY_TYPE_LONG = 1;
    private static final int PROPERTY_TYPE_INT = 2;
    private static final int PROPERTY_TYPE_BOOLEAN = 3;
    private static final int PROPERTY_TYPE_SAVEABLE = 4;
    private static final String[] PROPERTY_TYPES = new String[]{"String", "Long", "Int", "Boolean", "Object"};
    private ProgramDB program;
    private Table table;
    private Table registryTable;
    private AddressMapDB addressMap;
    private LanguageID languageID;
    private int languageVersion;
    private Language language;
    private LanguageTranslator languageUpgradeTranslator;
    private AddressFactory addressFactory;
    private HashMap<Long, PropertyMap<?>> propertyMaps = new HashMap();
    private HashSet<String> propertyMapOwners = null;
    private final ChangeManager changeMgr = new ChangeManagerAdapter(){

        @Override
        public void setPropertyChanged(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
            ProgramUserDataDB.this.changed = true;
            ProgramUserDataDB.this.program.userDataChanged(propertyName, codeUnitAddr, oldValue, newValue);
        }
    };

    private static String getName(ProgramDB program) {
        return program.getName() + "_UserData";
    }

    public ProgramUserDataDB(ProgramDB program) throws IOException {
        super(new DBHandle(), ProgramUserDataDB.getName(program), 500, (Object)program);
        this.program = program;
        this.language = program.getLanguage();
        this.languageID = this.language.getLanguageID();
        this.languageVersion = this.language.getVersion();
        this.addressFactory = this.language.getAddressFactory();
        this.setEventsEnabled(false);
        boolean success = false;
        try {
            int id = this.startTransaction("create user data");
            this.createDatabase();
            if (this.createManagers(0, program, TaskMonitor.DUMMY) != null) {
                throw new AssertException("Unexpected version exception on create");
            }
            this.endTransaction(id, true);
            this.changed = false;
            this.clearUndo(false);
            success = true;
        }
        catch (CancelledException e) {
            throw new AssertException();
        }
        finally {
            this.dbh.closeScratchPad();
            if (!success) {
                this.release(program);
                this.dbh.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramUserDataDB(DBHandle dbh, ProgramDB program, TaskMonitor monitor) throws IOException, VersionException, LanguageNotFoundException, CancelledException {
        super(dbh, ProgramUserDataDB.getName(program), 500, (Object)program);
        this.program = program;
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        this.setEventsEnabled(false);
        boolean success = false;
        try {
            int id = this.startTransaction("create user data");
            VersionException dbVersionExc = this.initializeDatabase();
            VersionException languageVersionExc = null;
            try {
                this.language = DefaultLanguageService.getLanguageService().getLanguage(this.languageID);
                languageVersionExc = this.checkLanguageVersion();
            }
            catch (LanguageNotFoundException e) {
                languageVersionExc = this.checkForLanguageChange(e);
            }
            this.addressFactory = this.language.getAddressFactory();
            VersionException versionExc = this.createManagers(3, program, monitor);
            if (dbVersionExc != null) {
                versionExc = dbVersionExc.combine(versionExc);
            }
            if (versionExc != null) {
                throw versionExc;
            }
            this.upgradeDatabase();
            if (languageVersionExc != null) {
                try {
                    this.setLanguage(this.languageUpgradeTranslator, monitor);
                    this.addressMap.memoryMapChanged(program.getMemory());
                }
                catch (IllegalStateException e) {
                    if (e.getCause() instanceof CancelledException) {
                        throw (CancelledException)e.getCause();
                    }
                    throw e;
                }
            }
            this.endTransaction(id, true);
            this.changed = false;
            this.clearUndo(false);
            success = true;
        }
        finally {
            dbh.closeScratchPad();
            if (!success) {
                this.release(program);
            }
        }
    }

    private VersionException checkLanguageVersion() throws LanguageNotFoundException {
        if (this.language.getVersion() > this.languageVersion) {
            Language newLanguage = this.language;
            Language oldLanguage = OldLanguageFactory.getOldLanguageFactory().getOldLanguage(this.languageID, this.languageVersion);
            if (oldLanguage == null) {
                Msg.error((Object)this, (Object)("Old language specification not found: " + this.languageID + " (Version " + this.languageVersion + ")"));
                return new VersionException(true);
            }
            this.languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(oldLanguage, newLanguage);
            if (this.languageUpgradeTranslator == null) {
                throw new LanguageNotFoundException(this.language.getLanguageID(), "(Ver " + this.languageVersion + ".x -> " + newLanguage.getVersion() + "." + newLanguage.getMinorVersion() + ") language version translation not supported");
            }
            this.language = oldLanguage;
            return new VersionException(true);
        }
        if (this.language.getVersion() != this.languageVersion) {
            throw new LanguageNotFoundException(this.language.getLanguageID(), this.languageVersion, 0);
        }
        return null;
    }

    private VersionException checkForLanguageChange(LanguageNotFoundException e) throws LanguageNotFoundException {
        LanguageID newLangName;
        this.languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(this.languageID, this.languageVersion);
        if (this.languageUpgradeTranslator == null) {
            throw e;
        }
        this.language = this.languageUpgradeTranslator.getOldLanguage();
        this.languageID = this.language.getLanguageID();
        VersionException ve = new VersionException(true);
        LanguageID oldLangName = this.languageUpgradeTranslator.getOldLanguage().getLanguageID();
        Object message = oldLangName.equals(newLangName = this.languageUpgradeTranslator.getNewLanguage().getLanguageID()) ? "Program User Data requires a processor language version change" : "Program User Data requires a processor language change to:\n" + newLangName;
        ve.setDetailMessage((String)message);
        return ve;
    }

    public String getDescription() {
        return "Program User Data";
    }

    public boolean isChangeable() {
        return true;
    }

    private void createDatabase() throws IOException {
        this.table = this.dbh.createTable(TABLE_NAME, SCHEMA);
        this.registryTable = this.dbh.createTable(REGISTRY_TABLE_NAME, REGISTRY_SCHEMA, new int[]{0});
        DBRecord record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_ID));
        record.setString(0, this.languageID.getIdAsString());
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_VERSION));
        record.setString(0, Integer.toString(this.languageVersion));
        this.table.putRecord(record);
        record = SCHEMA.createRecord((Field)new StringField(STORED_DB_VERSION));
        record.setString(0, Integer.toString(1));
        this.table.putRecord(record);
    }

    private VersionException initializeDatabase() throws IOException, VersionException, LanguageNotFoundException {
        boolean requiresUpgrade = false;
        this.table = this.dbh.getTable(TABLE_NAME);
        this.registryTable = this.dbh.getTable(REGISTRY_TABLE_NAME);
        if (this.table == null || this.registryTable == null) {
            throw new IOException("Unsupported User Data File Content");
        }
        DBRecord record = this.table.getRecord((Field)new StringField(LANGUAGE_ID));
        this.languageID = new LanguageID(record.getString(0));
        record = this.table.getRecord((Field)new StringField(LANGUAGE_VERSION));
        this.languageVersion = 1;
        try {
            this.languageVersion = Integer.parseInt(record.getString(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int storedVersion = 1;
        record = this.table.getRecord((Field)new StringField(STORED_DB_VERSION));
        try {
            storedVersion = Integer.parseInt(record.getString(0));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (storedVersion > 1) {
            throw new VersionException(2, false);
        }
        if (storedVersion < 1) {
            requiresUpgrade = true;
        }
        this.loadMetadata();
        return requiresUpgrade ? new VersionException(true) : null;
    }

    private void upgradeDatabase() throws IOException {
        this.table = this.dbh.getTable(TABLE_NAME);
        DBRecord record = SCHEMA.createRecord((Field)new StringField(STORED_DB_VERSION));
        record.setString(0, Integer.toString(1));
        this.table.putRecord(record);
    }

    private VersionException createManagers(int openMode, ProgramDB program1, TaskMonitor monitor) throws CancelledException, IOException {
        VersionException versionExc = null;
        monitor.checkCanceled();
        long baseImageOffset = program1.getImageBase().getOffset();
        try {
            this.addressMap = new AddressMapDB(this.dbh, openMode, this.addressFactory, baseImageOffset, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
            try {
                this.addressMap = new AddressMapDB(this.dbh, 2, this.addressFactory, baseImageOffset, monitor);
            }
            catch (VersionException e1) {
                if (e1.isUpgradable()) {
                    Msg.error((Object)this, (Object)"AddressMapDB is upgradeable but failed to support READ-ONLY mode!");
                }
                return versionExc;
            }
        }
        this.addressMap.memoryMapChanged(program1.getMemory());
        monitor.checkCanceled();
        return versionExc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLanguage(LanguageTranslator translator, TaskMonitor monitor) {
        this.lock.acquire();
        try {
            try {
                this.language = translator.getNewLanguage();
                this.languageID = this.language.getLanguageID();
                this.languageVersion = this.language.getVersion();
                this.addressFactory = this.language.getAddressFactory();
                this.addressMap.setLanguage(this.language, this.addressFactory, translator);
                this.clearCache(true);
                DBRecord record = SCHEMA.createRecord((Field)new StringField(LANGUAGE_ID));
                record.setString(0, this.languageID.getIdAsString());
                this.table.putRecord(record);
                this.setChanged(true);
                this.clearCache(true);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Set language aborted - program user data is now in an unusable state!", t);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public synchronized boolean canSave() {
        return this.dbh.canUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyMap<?> getPropertyMap(String owner, String propertyName, int propertyType, Class<?> saveableClass, boolean create) throws PropertyTypeMismatchException {
        try {
            for (Field key : this.registryTable.findRecords((Field)new StringField(owner), 0)) {
                String className;
                DBRecord rec = this.registryTable.getRecord(key);
                if (!propertyName.equals(rec.getString(1))) continue;
                int type = rec.getIntValue(2);
                if (propertyType != type) {
                    throw new PropertyTypeMismatchException("'" + propertyName + "' is type " + PROPERTY_TYPES[type]);
                }
                if (propertyType == 4 && !(className = rec.getString(3)).equals(saveableClass.getName())) {
                    throw new PropertyTypeMismatchException("'" + propertyName + "' is class " + className);
                }
                return this.getPropertyMap(rec);
            }
            if (!create) {
                return null;
            }
            long key = this.registryTable.getKey();
            DBRecord rec = REGISTRY_SCHEMA.createRecord(key);
            rec.setString(0, owner);
            rec.setString(1, propertyName);
            rec.setIntValue(2, propertyType);
            if (saveableClass != null) {
                rec.setString(3, saveableClass.getName());
            }
            PropertyMap<?> map = null;
            boolean success = false;
            try {
                map = this.getPropertyMap(rec);
                this.registryTable.putRecord(rec);
                if (this.propertyMapOwners != null) {
                    this.propertyMapOwners.add(owner);
                }
                success = true;
            }
            finally {
                if (!success && map != null) {
                    this.propertyMaps.remove(key);
                }
            }
            return map;
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    private PropertyMap<?> getPropertyMap(DBRecord rec) throws IOException {
        try {
            PropertyMapDB map;
            int type = rec.getIntValue(2);
            switch (type) {
                case 0: {
                    map = new StringPropertyMapDB(this.dbh, 3, (ErrorHandler)this, this.changeMgr, this.addressMap, rec.getString(1), TaskMonitor.DUMMY);
                    break;
                }
                case 1: {
                    map = new LongPropertyMapDB(this.dbh, 3, (ErrorHandler)this, this.changeMgr, this.addressMap, rec.getString(1), TaskMonitor.DUMMY);
                    break;
                }
                case 2: {
                    map = new IntPropertyMapDB(this.dbh, 3, (ErrorHandler)this, this.changeMgr, this.addressMap, rec.getString(1), TaskMonitor.DUMMY);
                    break;
                }
                case 3: {
                    map = new VoidPropertyMapDB(this.dbh, 3, (ErrorHandler)this, this.changeMgr, this.addressMap, rec.getString(1), TaskMonitor.DUMMY);
                    break;
                }
                case 4: {
                    String className = rec.getString(3);
                    Class<Saveable> c = ObjectPropertyMapDB.getSaveableClassForName(className);
                    return new ObjectPropertyMapDB<Saveable>(this.dbh, 3, (ErrorHandler)this, this.changeMgr, this.addressMap, rec.getString(1), c, TaskMonitor.DUMMY, true);
                }
                default: {
                    throw new IllegalArgumentException("Unsupported property type: " + type);
                }
            }
            this.propertyMaps.put(rec.getKey(), map);
            return map;
        }
        catch (CancelledException e) {
            throw new AssertException("Unexpected Error", (Throwable)e);
        }
        catch (VersionException e) {
            throw new IOException("Incompatable property data for '" + rec.getString(1) + "': " + e.getMessage());
        }
    }

    @Override
    public synchronized List<PropertyMap<?>> getProperties(String owner) {
        ArrayList list = new ArrayList();
        try {
            for (Field key : this.registryTable.findRecords((Field)new StringField(owner), 0)) {
                DBRecord rec = this.registryTable.getRecord(key);
                list.add(this.getPropertyMap(rec));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return list;
    }

    @Override
    public synchronized List<String> getPropertyOwners() {
        if (this.propertyMapOwners == null) {
            try {
                this.propertyMapOwners = new HashSet();
                for (DBRecord rec : this.registryTable) {
                    this.propertyMapOwners.add(rec.getString(0));
                }
            }
            catch (IOException e) {
                this.propertyMapOwners = null;
                this.dbError(e);
            }
        }
        return new ArrayList<String>(this.propertyMapOwners);
    }

    @Override
    public synchronized StringPropertyMap getStringProperty(String owner, String propertyName, boolean create) throws PropertyTypeMismatchException {
        return (StringPropertyMap)this.getPropertyMap(owner, propertyName, 0, null, create);
    }

    @Override
    public synchronized LongPropertyMap getLongProperty(String owner, String propertyName, boolean create) throws PropertyTypeMismatchException {
        return (LongPropertyMap)this.getPropertyMap(owner, propertyName, 1, null, create);
    }

    @Override
    public synchronized IntPropertyMap getIntProperty(String owner, String propertyName, boolean create) throws PropertyTypeMismatchException {
        return (IntPropertyMap)this.getPropertyMap(owner, propertyName, 2, null, create);
    }

    @Override
    public synchronized VoidPropertyMap getBooleanProperty(String owner, String propertyName, boolean create) throws PropertyTypeMismatchException {
        return (VoidPropertyMap)this.getPropertyMap(owner, propertyName, 3, null, create);
    }

    @Override
    public synchronized <T extends Saveable> ObjectPropertyMap<T> getObjectProperty(String owner, String propertyName, Class<T> saveableObjectClass, boolean create) throws PropertyTypeMismatchException {
        return (ObjectPropertyMap)this.getPropertyMap(owner, propertyName, 4, saveableObjectClass, create);
    }

    protected boolean propertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.changed = true;
        this.program.userDataChanged(propertyName, oldValue, newValue);
        return true;
    }

    @Override
    public int startTransaction() {
        return this.startTransaction("Property Change");
    }

    @Override
    public void endTransaction(int transactionID) {
        super.endTransaction(transactionID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        ProgramUserDataDB programUserDataDB = this;
        synchronized (programUserDataDB) {
            if (this.dbh.canUpdate()) {
                if (this.changed) {
                    this.dbh.save(comment, null, monitor);
                    this.setChanged(false);
                }
            } else {
                FileSystem userfs = this.program.getAssociatedUserFilesystem();
                if (userfs != null) {
                    ContentHandler contentHandler = ProgramUserDataDB.getContentHandler((DomainObject)this.program);
                    if (contentHandler != null) {
                        contentHandler.saveUserDataFile((DomainObject)this.program, this.dbh, userfs, monitor);
                    }
                    this.setChanged(false);
                }
            }
        }
    }

    @Override
    public void setStringProperty(String propertyName, String value) {
        this.metadata.put(propertyName, value);
        this.changed = true;
    }

    @Override
    public String getStringProperty(String propertyName, String defaultValue) {
        String value = (String)this.metadata.get(propertyName);
        return value == null ? defaultValue : value;
    }

    @Override
    public Set<String> getStringPropertyNames() {
        return this.metadata.keySet();
    }

    @Override
    public String removeStringProperty(String propertyName) {
        this.changed = true;
        return (String)this.metadata.remove(propertyName);
    }
}

