/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import SWIG.SBFrame;
import SWIG.SBThread;
import agent.lldb.manager.LldbEventsListenerAdapter;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.iface1.LldbModelSelectableObject;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetStackFrame
extends TargetStackFrame,
LldbEventsListenerAdapter,
LldbModelSelectableObject {
    public static final String FUNC_ATTRIBUTE_NAME = "function";
    public static final String FUNC_TABLE_ENTRY_ATTRIBUTE_NAME = "Table Entry";
    public static final String FRAME_OFFSET_ATTRIBUTE_NAME = "Frame Offset";
    public static final String INST_OFFSET_ATTRIBUTE_NAME = "Inst. Offset";
    public static final String RETURN_OFFSET_ATTRIBUTE_NAME = "Return Offset";
    public static final String CALL_FRAME_OFFSET_ATTRIBUTE_NAME = "Call Frame Offset";
    public static final String STACK_OFFSET_ATTRIBUTE_NAME = "Stack Offset";
    public static final String VIRTUAL_ATTRIBUTE_NAME = "Virtual";
    public static final String PARAM0_ATTRIBUTE_NAME = "Param[0]";
    public static final String PARAM1_ATTRIBUTE_NAME = "Param[1]";
    public static final String PARAM2_ATTRIBUTE_NAME = "Param[2]";
    public static final String PARAM3_ATTRIBUTE_NAME = "Param[3]";

    @Override
    default public CompletableFuture<Void> setActive() {
        LldbManagerImpl manager = this.getManager();
        SBThread thread = manager.getCurrentThread();
        String name = this.getName();
        String stripped = name.substring(1, name.length() - 1);
        int index = Integer.decode(stripped);
        return manager.setActiveFrame(thread, index);
    }

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenCompose(attrs -> {
            if (attrs == null) {
                return CompletableFuture.completedFuture(null);
            }
            map.putAll((Map<String, Object>)attrs);
            LldbModelTargetObject attributes = (LldbModelTargetObject)attrs.get("Attributes");
            if (attributes == null) {
                return CompletableFuture.completedFuture(null);
            }
            return attributes.requestAugmentedAttributes().thenCompose(ax -> {
                Map subattrs = attributes.getCachedAttributes();
                if (subattrs == null) {
                    return CompletableFuture.completedFuture(null);
                }
                LldbModelTargetObject frameNumber = (LldbModelTargetObject)subattrs.get("FrameNumber");
                return frameNumber.requestAugmentedAttributes().thenCompose(bx -> {
                    Object noval = frameNumber.getCachedAttribute("_value");
                    String nostr = noval.toString();
                    LldbModelTargetObject instructionOffset = (LldbModelTargetObject)subattrs.get("InstructionOffset");
                    return instructionOffset.requestAugmentedAttributes().thenAccept(cx -> {
                        String oldval = (String)this.getCachedAttribute("_display");
                        Object pcval = instructionOffset.getCachedAttribute("_value");
                        String pcstr = pcval.toString();
                        long pc = Long.parseUnsignedLong(pcstr, 16);
                        map.put("_pc", space.getAddress(pc));
                        String display = String.format("#%s 0x%s", nostr, pcstr);
                        map.put("_display", display);
                        this.setModified(map, !display.equals(oldval));
                    });
                });
            });
        });
    }

    public void setFrame(SBFrame var1);

    public TargetObject getThread();

    public Address getPC();

    public LldbModelTargetProcess getProcess();
}

