/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import SWIG.SBValue;
import SWIG.StateType;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.iface2.LldbModelTargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetRegisterBank
extends LldbModelTargetObject,
TargetRegisterBank {
    public LldbModelTargetRegister getTargetRegister(SBValue var1);

    default public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        this.readRegistersNamed(this.getCachedElements().keySet());
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> var1);

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> var1);

    default public Map<String, byte[]> getCachedRegisters() {
        return this.getValues();
    }

    default public Map<String, byte[]> getValues() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry entry : this.getCachedAttributes().entrySet()) {
            if (!(entry.getValue() instanceof LldbModelTargetRegister)) continue;
            LldbModelTargetRegister reg = (LldbModelTargetRegister)entry.getValue();
            byte[] bytes = reg.getBytes();
            result.put((String)entry.getKey(), bytes);
        }
        return result;
    }
}

