/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzss;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.lzss.LzssCompressionHeader;
import ghidra.file.formats.lzss.LzssUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class LzssAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        LzssCompressionHeader header = new LzssCompressionHeader((ByteProvider)provider);
        if (header.getSignature() != 1668246896) {
            return false;
        }
        if (header.getCompressionType() != 1819964275) {
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, address, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        this.changeDataSettings(program, monitor);
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return this.getName();
    }

    public boolean canAnalyze(Program program) {
        return LzssUtil.isLZSS(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return LzssUtil.isLZSS(program);
    }

    public String getDescription() {
        return "Annotates an LZSS compression file.";
    }

    public String getName() {
        return "LZSS Compression Annotation";
    }

    public boolean isPrototype() {
        return true;
    }
}

