/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class iOS_FixupArmSymbolsAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Apple iOS ARM Symbol Fixup";
    private static final String DESCRIPTION = "Moves the pre-defined ARM symbols to image base of the iOS binary.";

    public iOS_FixupArmSymbolsAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    public boolean getDefaultEnablement(Program program) {
        return this.isBoot(program);
    }

    public boolean canAnalyze(Program program) {
        return this.isBoot(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator symbolIterator = symbolTable.getSymbolIterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol = symbolIterator.next();
            if (!symbol.isPinned()) continue;
            symbol.setPinned(false);
        }
        return false;
    }

    private boolean isBoot(Program program) {
        if (program == null) {
            return false;
        }
        Language language = program.getLanguage();
        if (language == null) {
            return false;
        }
        Processor processor = language.getProcessor();
        if (processor == null) {
            return false;
        }
        if (!processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"))) {
            return false;
        }
        Address minAddress = program.getMinAddress();
        if (minAddress == null) {
            return false;
        }
        Address address = null;
        try {
            address = minAddress.add(512L);
        }
        catch (Exception e) {
            return false;
        }
        if (address == null) {
            return false;
        }
        Memory memory = program.getMemory();
        byte[] bytes = new byte[64];
        try {
            memory.getBytes(address, bytes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        String string = new String(bytes).trim();
        if (string.indexOf("Apple") != -1) {
            if (string.startsWith("SecureROM")) {
                return true;
            }
            if (string.startsWith("LLB")) {
                return true;
            }
            if (string.startsWith("iBoot")) {
                return true;
            }
            if (string.startsWith("iBEC")) {
                return true;
            }
            if (string.startsWith("iBSS")) {
                return true;
            }
        }
        return false;
    }
}

