/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatHeaderFactory;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeaderFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.task.TaskMonitor;

public class OatExecAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Android OATEXEC Format";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Analyzes the Android OAT executable (oatexec) section of this program.";
    }

    public boolean canAnalyze(Program program) {
        return false;
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        OatHeader header = null;
        try {
            BinaryReader reader = OatUtilities.getBinaryReader(program);
            header = OatHeaderFactory.newOatHeader(reader);
            OatHeaderFactory.parseOatHeader(header, program, reader, monitor, log);
        }
        catch (UnsupportedOatVersionException e) {
            log.appendMsg(e.getMessage());
            return false;
        }
        monitor.setMessage("OAT Version: " + header.getVersion());
        Symbol oatExecSymbol = OatUtilities.getOatExecSymbol(program);
        if (oatExecSymbol == null) {
            log.appendMsg("Unable to locate oatexec symbol, skipping...");
            return true;
        }
        Address address = oatExecSymbol.getAddress();
        Symbol oatLastWordSymbol = OatUtilities.getOatLastWordSymbol(program);
        program.getListing().clearCodeUnits(oatLastWordSymbol.getAddress(), oatLastWordSymbol.getAddress(), true);
        monitor.setProgress(0L);
        monitor.setMaximum(oatLastWordSymbol.getAddress().subtract(address));
        try {
            while (true) {
                monitor.checkCanceled();
                monitor.setProgress(address.subtract(oatExecSymbol.getAddress()));
                if (oatLastWordSymbol.getAddress().compareTo((Object)address) > 0) {
                    MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
                    BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
                    OatQuickMethodHeader quickMethodHeader = OatQuickMethodHeaderFactory.getOatQuickMethodHeader(reader, header.getVersion());
                    DataType dataType = quickMethodHeader.toDataType();
                    this.createData(program, address, dataType);
                    address = address.add((long)dataType.getLength());
                    address = address.add((long)quickMethodHeader.getCodeSize());
                    address = this.align(address);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
            return false;
        }
        return true;
    }

    private Address align(Address address) {
        int alignmentValue = 8;
        long offset = address.getOffset();
        if (offset % (long)alignmentValue == 0L) {
            return address;
        }
        long value = (long)alignmentValue - offset % (long)alignmentValue;
        return address.getNewAddress(offset + value);
    }
}

