/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.ModifiedUTF8;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class StringDataItem
implements StructConverter {
    private static final int MAX_STRING_LEN = 0x200000;
    private int stringLength;
    private int lebLength;
    private int actualLength;
    private String string;

    public StringDataItem(StringIDItem stringItem, BinaryReader reader, DexHeader dexHeader) throws IOException {
        reader = reader.clone((long)DexUtil.adjustOffset(stringItem.getStringDataOffset(), dexHeader));
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.stringLength = leb128.asUInt32();
        this.lebLength = leb128.getLength();
        long nullTermIndex = StringDataItem.getIndexOfByteValue(reader, reader.getPointerIndex(), 0x200000, (byte)0);
        this.actualLength = (int)(nullTermIndex - reader.getPointerIndex() + 1L);
        byte[] stringBytes = reader.readNextByteArray(this.actualLength);
        ByteArrayInputStream in = new ByteArrayInputStream(stringBytes);
        char[] out = new char[this.stringLength];
        this.string = ModifiedUTF8.decode(in, out);
    }

    StringDataItem(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("string_data_item_" + this.actualLength, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.lebLength, BYTE.getLength()), "utf16_size", null);
        structure.add(UTF8, this.actualLength, "data", null);
        structure.setCategoryPath(new CategoryPath("/dex/string_data_item"));
        return structure;
    }

    private static long getIndexOfByteValue(BinaryReader reader, long startIndex, int maxLen, byte byteValueToFind) throws IOException {
        long currentIndex;
        long maxIndex = startIndex + (long)maxLen;
        for (currentIndex = startIndex; currentIndex < maxIndex; ++currentIndex) {
            byte b = reader.readByte(currentIndex);
            if (b != byteValueToFind) continue;
            return currentIndex;
        }
        return currentIndex;
    }
}

