/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootImageHeaderV0
extends BootImageHeader {
    private String magic;
    private int kernel_size;
    private int kernel_addr;
    private int ramdisk_size;
    private int ramdisk_addr;
    private int second_size;
    private int second_addr;
    private int tags_addr;
    private int page_size;
    private int header_version;
    private int os_version;
    private String name;
    private String cmdline;
    private int[] id;
    private String extra_cmdline;

    public BootImageHeaderV0(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString(8);
        this.kernel_size = reader.readNextInt();
        this.kernel_addr = reader.readNextInt();
        this.ramdisk_size = reader.readNextInt();
        this.ramdisk_addr = reader.readNextInt();
        this.second_size = reader.readNextInt();
        this.second_addr = reader.readNextInt();
        this.tags_addr = reader.readNextInt();
        this.page_size = reader.readNextInt();
        this.header_version = reader.readNextInt();
        this.os_version = reader.readNextInt();
        this.name = reader.readNextAsciiString(16);
        this.cmdline = reader.readNextAsciiString(512);
        this.id = reader.readNextIntArray(8);
        this.extra_cmdline = reader.readNextAsciiString(1024);
    }

    @Override
    public String getMagic() {
        return this.magic;
    }

    @Override
    public int getKernelSize() {
        return this.kernel_size;
    }

    @Override
    public long getKernelOffset() {
        return this.page_size;
    }

    public int getKernelAddress() {
        return this.kernel_addr;
    }

    @Override
    public int getKernelPageCount() {
        return (int)(this.pageAlign(this.kernel_size) / (long)this.page_size);
    }

    @Override
    public int getRamdiskSize() {
        return this.ramdisk_size;
    }

    @Override
    public int getRamdiskOffset() {
        return this.page_size + this.getKernelPageCount() * this.page_size;
    }

    public int getRamdiskAddress() {
        return this.ramdisk_addr;
    }

    @Override
    public int getRamdiskPageCount() {
        return (int)(this.pageAlign(this.ramdisk_size) / (long)this.page_size);
    }

    @Override
    public int getSecondSize() {
        return this.second_size;
    }

    @Override
    public long getSecondOffset() {
        return this.page_size + (this.getKernelPageCount() + this.getRamdiskPageCount()) * this.page_size;
    }

    public int getSecondAddress() {
        return this.second_addr;
    }

    @Override
    public int getSecondPageCount() {
        return (int)(this.pageAlign(this.second_size) / (long)this.page_size);
    }

    public int getTagsAddress() {
        return this.tags_addr;
    }

    @Override
    public int getPageSize() {
        return this.page_size;
    }

    public int getHeaderVersion() {
        return this.header_version;
    }

    public int getOSVersion() {
        return this.os_version;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getCommandLine() {
        return this.cmdline;
    }

    public int[] getId() {
        return this.id;
    }

    public String getExtraCommandLine() {
        return this.extra_cmdline;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("boot_img_hdr_v0", 0);
        structure.add(UTF8, 8, "magic", null);
        structure.add(DWORD, "kernel_size", null);
        structure.add(DWORD, "kernel_addr", null);
        structure.add(DWORD, "ramdisk_size", null);
        structure.add(DWORD, "ramdisk_addr", null);
        structure.add(DWORD, "second_size", null);
        structure.add(DWORD, "second_addr", null);
        structure.add(DWORD, "tags_addr", null);
        structure.add(DWORD, "page_size", null);
        structure.add(DWORD, "header_version", null);
        structure.add(DWORD, "os_version", BootImageUtil.getOSVersionString(this.os_version));
        structure.add(UTF8, 16, "name", null);
        structure.add(UTF8, 512, "cmdline", null);
        ArrayDataType array = new ArrayDataType(DWORD, 8, DWORD.getLength());
        structure.add((DataType)array, "id", null);
        structure.add(UTF8, 1024, "extra_cmdline", null);
        return structure;
    }
}

