/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtCompression;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSections;
import ghidra.file.formats.android.art.ArtImageSectionsFactory;
import ghidra.file.formats.android.art.ArtStorageMode;
import ghidra.file.formats.android.art.UnknownArtStorageModeException;
import ghidra.file.formats.android.art.image_method.ImageMethod_Nougat;
import ghidra.file.formats.android.util.DecompressionManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ArtHeader_029
extends ArtHeader
implements ArtCompression {
    protected int image_begin_;
    protected int image_size_;
    protected int oat_checksum_;
    protected int oat_file_begin_;
    protected int oat_data_begin_;
    protected int oat_data_end_;
    protected int oat_file_end_;
    protected int boot_image_begin_;
    protected int boot_image_size_;
    protected int boot_oat_begin_;
    protected int boot_oat_size_;
    protected int patch_delta_;
    protected int image_roots_;
    protected int pointer_size_;
    protected int compile_pic_;
    protected int is_pic_;
    protected int storage_mode_;
    protected int data_size_;
    protected ArtImageSections sections;
    private long _compressedOffset;

    public ArtHeader_029(BinaryReader reader) throws IOException {
        super(reader);
        this.parse(reader);
    }

    @Override
    protected void parse(BinaryReader reader) throws IOException {
        this.image_begin_ = reader.readNextInt();
        this.image_size_ = reader.readNextInt();
        this.oat_checksum_ = reader.readNextInt();
        this.oat_file_begin_ = reader.readNextInt();
        this.oat_data_begin_ = reader.readNextInt();
        this.oat_data_end_ = reader.readNextInt();
        this.oat_file_end_ = reader.readNextInt();
        this.boot_image_begin_ = reader.readNextInt();
        this.boot_image_size_ = reader.readNextInt();
        this.boot_oat_begin_ = reader.readNextInt();
        this.boot_oat_size_ = reader.readNextInt();
        this.patch_delta_ = reader.readNextInt();
        this.image_roots_ = reader.readNextInt();
        this.pointer_size_ = reader.readNextInt();
        this.compile_pic_ = reader.readNextInt();
        this.is_pic_ = reader.readNextInt();
        this.sections = ArtImageSectionsFactory.getArtImageSections(reader, this);
        this.sections.parseSections(reader);
        this.parseImageMethods(reader);
        this.storage_mode_ = reader.readNextInt();
        this.data_size_ = reader.readNextInt();
        this._compressedOffset = reader.getPointerIndex();
        reader = DecompressionManager.decompress(reader, this, TaskMonitor.DUMMY);
        this.sections.parse(reader);
    }

    @Override
    public int getArtMethodCountForVersion() {
        return ImageMethod_Nougat.kImageMethodsCount.ordinal();
    }

    @Override
    public int getImageBegin() {
        return this.image_begin_;
    }

    @Override
    public int getImageSize() {
        return this.image_size_;
    }

    public int getBootOatBegin() {
        return this.boot_oat_begin_;
    }

    public int getBootOatSize() {
        return this.boot_oat_size_;
    }

    @Override
    public int getOatFileBegin() {
        return this.oat_file_begin_;
    }

    @Override
    public int getOatFileEnd() {
        return this.oat_file_end_;
    }

    @Override
    public int getOatDataBegin() {
        return this.oat_data_begin_;
    }

    @Override
    public int getOatDataEnd() {
        return this.oat_data_end_;
    }

    public int getIsPic() {
        return this.is_pic_;
    }

    @Override
    public ArtStorageMode getStorageMode() throws UnknownArtStorageModeException {
        return ArtStorageMode.get(this.storage_mode_);
    }

    @Override
    public long getCompressedOffset() {
        return this._compressedOffset;
    }

    @Override
    public int getCompressedSize() {
        return this.data_size_;
    }

    @Override
    public long getDecompressedOffset() {
        return this.getCompressedOffset();
    }

    @Override
    public int getDecompressedSize() {
        return this.image_size_;
    }

    @Override
    public int getOatChecksum() {
        return this.oat_checksum_;
    }

    @Override
    public int getPointerSize() {
        return this.pointer_size_;
    }

    @Override
    public void markup(Program program, TaskMonitor monitor) throws Exception {
        DecompressionManager.decompressOverMemory(program, this, monitor);
        this.sections.markup(program, monitor);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "image_begin_", null);
        structure.add(DWORD, "image_size_", null);
        structure.add(DWORD, "oat_checksum_", null);
        structure.add(DWORD, "oat_file_begin_", null);
        structure.add(DWORD, "oat_data_begin_", null);
        structure.add(DWORD, "oat_data_end_", null);
        structure.add(DWORD, "oat_file_end_", null);
        structure.add(DWORD, "boot_image_begin_", null);
        structure.add(DWORD, "boot_image_size_", null);
        structure.add(DWORD, "boot_oat_begin_", null);
        structure.add(DWORD, "boot_oat_size_", null);
        structure.add(DWORD, "patch_delta_", null);
        structure.add(DWORD, "image_roots_", null);
        structure.add(DWORD, "pointer_size_", null);
        structure.add(DWORD, "compile_pic_", null);
        structure.add(DWORD, "is_pic_", null);
        for (i = 0; i < this.sections.getSectionList().size(); ++i) {
            structure.add(this.sections.getSectionList().get(i).toDataType(), "section_" + i, null);
        }
        for (i = 0; i < this.imageMethodsList.size(); ++i) {
            structure.add(QWORD, "image_method_" + i, null);
        }
        structure.add(DWORD, "storage_mode_", null);
        structure.add(DWORD, "data_size_", null);
        return structure;
    }
}

