/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.HeavyweightRenderer;
import org.jungrapht.visualization.renderers.LightweightRenderer;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.transform.BidirectionalTransformer;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.MagnifyTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.transform.shape.MagnifyIconGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiModalRenderer<V, E>
implements ModalRenderer<V, E>,
ChangeListener {
    public static final ModalRenderer.Mode LIGHTWEIGHT;
    public static final ModalRenderer.Mode HEAVYWEIGHT;
    private static final Logger log;
    private static final String LIGHTWEIGHT_COUNT_THRESHOLD = "jungrapht.lightweightCountThreshold";
    private static final String LIGHTWEIGHT_SCALE_THRESHOLD = "jungrapht.lightweightScaleThreshold";
    protected int lightweightRenderingCountThreshold = Integer.parseInt(System.getProperty("jungrapht.lightweightCountThreshold", "20"));
    protected double lightweightRenderingScaleThreshold = Double.parseDouble(System.getProperty("jungrapht.lightweightScaleThreshold", "0.5"));
    protected Supplier<Double> scaleSupplier = () -> 0.5;
    protected Predicate<Supplier<Double>> scalePredicate = t -> (Double)t.get() < this.lightweightRenderingScaleThreshold;
    protected Supplier<Integer> countSupplier = () -> 0;
    protected Predicate<Supplier<Integer>> countPredicate = t -> (Integer)t.get() > this.lightweightRenderingCountThreshold;
    protected ModalRenderer.Mode mode;
    protected Map<ModalRenderer.Mode, Renderer<V, E>> rendererMap;
    Timer timer;
    JComponent component;
    static final int TIMER_MAX;
    static final int TIMER_INCREMENT;
    static final int TIMER_SLEEP;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected BiModalRenderer(Builder<V, E, ?, ?> builder) {
        this(builder.component, builder.rendererMap);
    }

    protected BiModalRenderer(JComponent component, Map<ModalRenderer.Mode, Renderer<V, E>> rendererMap) {
        this.component = component;
        this.rendererMap = rendererMap;
        if (rendererMap.get(LIGHTWEIGHT) == null) {
            rendererMap.put(LIGHTWEIGHT, new LightweightRenderer());
        }
        if (rendererMap.get(HEAVYWEIGHT) == null) {
            rendererMap.put(HEAVYWEIGHT, new HeavyweightRenderer());
        }
    }

    @Override
    public void setRenderer(ModalRenderer.Mode mode, Renderer<V, E> renderer) {
        this.rendererMap.put(mode, renderer);
    }

    @Override
    public Renderer<V, E> getRenderer(ModalRenderer.Mode mode) {
        return this.rendererMap.get(mode);
    }

    public Supplier<Double> getScaleSupplier() {
        return this.scaleSupplier;
    }

    public void setScaleSupplier(Supplier<Double> scaleSupplier) {
        this.scaleSupplier = scaleSupplier;
    }

    public Supplier<Integer> getCountSupplier() {
        return this.countSupplier;
    }

    public void setCountSupplier(Supplier<Integer> countSupplier) {
        this.countSupplier = countSupplier;
        this.stateChanged(null);
    }

    @Override
    public void setMode(ModalRenderer.Mode mode) {
        log.trace("setMode({})", (Object)mode);
        this.mode = mode;
    }

    public ModalRenderer.Mode getMode() {
        if (this.mode == null) {
            return HEAVYWEIGHT;
        }
        return this.mode;
    }

    private Renderer<V, E> getInitialRenderer() {
        log.trace("initialMode...");
        if (!this.countPredicate.test(this.countSupplier)) {
            return this.rendererMap.get(HEAVYWEIGHT);
        }
        if (this.scalePredicate.test(this.scaleSupplier)) {
            return this.rendererMap.get(LIGHTWEIGHT);
        }
        return this.rendererMap.get(HEAVYWEIGHT);
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, Spatial<V, V> vertexSpatial, Spatial<E, V> edgeSpatial) {
        if (this.mode == null) {
            this.setAntialias(renderContext, HEAVYWEIGHT);
            this.getInitialRenderer().render(renderContext, layoutModel, vertexSpatial, edgeSpatial);
        } else {
            this.setAntialias(renderContext, this.mode);
            this.doRender(renderContext, layoutModel, vertexSpatial, edgeSpatial);
        }
    }

    private void setAntialias(RenderContext<V, E> renderContext, ModalRenderer.Mode mode) {
        if (mode == HEAVYWEIGHT) {
            renderContext.getGraphicsContext().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            renderContext.getGraphicsContext().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel) {
        this.setAntialias(renderContext, this.mode);
        this.doRender(renderContext, layoutModel);
    }

    private void doRender(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, Spatial<V, V> vertexSpatial, Spatial<E, V> edgeSpatial) {
        Graph graph;
        if (vertexSpatial == null) {
            this.render(renderContext, layoutModel);
            return;
        }
        Set<V> visibleVertices = null;
        Set<E> visibleEdges = null;
        try {
            visibleVertices = vertexSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout());
            if (edgeSpatial != null) {
                visibleEdges = edgeSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout());
            } else {
                graph = layoutModel.getGraph();
                visibleEdges = graph.edgeSet();
            }
        }
        catch (ConcurrentModificationException ex) {
            log.trace("got {} so returning", (Object)ex.toString());
            log.trace("layoutMode active: {}, edgeSpatial active {}, vertexSpatial active: {}", new Object[]{layoutModel.isRelaxing(), edgeSpatial != null && edgeSpatial.isActive(), vertexSpatial.isActive()});
            return;
        }
        try {
            graph = layoutModel.getGraph();
            log.trace("the visibleEdges are {}", visibleEdges);
            for (Object e : visibleEdges) {
                if (!graph.containsEdge(e)) continue;
                this.renderEdge(renderContext, layoutModel, e);
                this.renderEdgeLabel(renderContext, layoutModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            log.trace("the visibleVertices are {}", visibleVertices);
            for (Object v : visibleVertices) {
                this.renderVertex(renderContext, layoutModel, v);
                this.renderVertexLabel(renderContext, layoutModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    private void doRender(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        try {
            for (Object e : graph.edgeSet()) {
                this.renderEdge(renderContext, layoutModel, e);
                this.renderEdgeLabel(renderContext, layoutModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            for (Object v : graph.vertexSet()) {
                this.renderVertex(renderContext, layoutModel, v);
                this.renderVertexLabel(renderContext, layoutModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void renderVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        GraphicsDecorator graphicsDecorator = renderContext.getGraphicsContext();
        if (graphicsDecorator instanceof MagnifyIconGraphics) {
            MagnifyIconGraphics magnifyIconGraphics = (MagnifyIconGraphics)graphicsDecorator;
            BidirectionalTransformer bidirectionalTransformer = magnifyIconGraphics.getTransformer();
            if (bidirectionalTransformer instanceof MagnifyTransformer) {
                MagnifyTransformer magnifyTransformer = (MagnifyTransformer)bidirectionalTransformer;
                Lens lens = magnifyTransformer.getLens();
                Point p = (Point)layoutModel.apply(v);
                Point2D.Double layoutPoint = new Point2D.Double(p.x, p.y);
                Point2D viewPoint = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, layoutPoint);
                RectangularShape lensShape = lens.getLensShape();
                if (lensShape.contains(viewPoint)) {
                    double magnification = magnifyTransformer.getLens().getMagnification();
                    double product = magnification * magnifyTransformer.getScale();
                    ModalRenderer.Mode mode = this.getModeFor(() -> product);
                    this.rendererMap.get(mode).renderVertex(renderContext, layoutModel, v);
                } else {
                    this.rendererMap.get(this.mode).renderVertex(renderContext, layoutModel, v);
                }
            }
        } else {
            this.rendererMap.get(this.getMode()).renderVertex(renderContext, layoutModel, v);
        }
    }

    @Override
    public void renderVertexLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        this.rendererMap.get(this.getMode()).renderVertexLabel(renderContext, layoutModel, v);
    }

    @Override
    public void renderEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.rendererMap.get(this.getMode()).renderEdge(renderContext, layoutModel, e);
    }

    @Override
    public void renderEdgeLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.rendererMap.get(this.getMode()).renderEdgeLabel(renderContext, layoutModel, e);
    }

    @Override
    public void setVertexRenderer(Renderer.Vertex<V, E> r) {
        this.rendererMap.get(this.getMode()).setVertexRenderer(r);
    }

    @Override
    public void setEdgeRenderer(Renderer.Edge<V, E> r) {
        this.rendererMap.get(this.getMode()).setEdgeRenderer(r);
    }

    @Override
    public void setVertexLabelRenderer(Renderer.VertexLabel<V, E> r) {
        this.rendererMap.get(this.getMode()).setVertexLabelRenderer(r);
    }

    @Override
    public void setEdgeLabelRenderer(Renderer.EdgeLabel<V, E> r) {
        this.rendererMap.get(this.getMode()).setEdgeLabelRenderer(r);
    }

    @Override
    public Renderer.VertexLabel<V, E> getVertexLabelRenderer() {
        return this.rendererMap.get(this.getMode()).getVertexLabelRenderer();
    }

    @Override
    public Renderer.Vertex<V, E> getVertexRenderer() {
        return this.rendererMap.get(this.getMode()).getVertexRenderer();
    }

    @Override
    public Renderer.Edge<V, E> getEdgeRenderer() {
        return this.rendererMap.get(this.getMode()).getEdgeRenderer();
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return this.rendererMap.get(this.getMode()).getEdgeLabelRenderer();
    }

    @Override
    public void setVertexRenderer(ModalRenderer.Mode mode, Renderer.Vertex<V, E> r) {
        this.rendererMap.get(mode).setVertexRenderer(r);
    }

    @Override
    public void setEdgeRenderer(ModalRenderer.Mode mode, Renderer.Edge<V, E> r) {
        this.rendererMap.get(mode).setEdgeRenderer(r);
    }

    @Override
    public void setVertexLabelRenderer(ModalRenderer.Mode mode, Renderer.VertexLabel<V, E> r) {
        this.rendererMap.get(mode).setVertexLabelRenderer(r);
    }

    @Override
    public void setEdgeLabelRenderer(ModalRenderer.Mode mode, Renderer.EdgeLabel<V, E> r) {
        this.rendererMap.get(mode).setEdgeLabelRenderer(r);
    }

    @Override
    public Renderer.VertexLabel<V, E> getVertexLabelRenderer(ModalRenderer.Mode mode) {
        return this.rendererMap.get(mode).getVertexLabelRenderer();
    }

    @Override
    public Renderer.Vertex<V, E> getVertexRenderer(ModalRenderer.Mode mode) {
        return this.rendererMap.get(mode).getVertexRenderer();
    }

    @Override
    public Renderer.Edge<V, E> getEdgeRenderer(ModalRenderer.Mode mode) {
        return this.rendererMap.get(mode).getEdgeRenderer();
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer(ModalRenderer.Mode mode) {
        return this.rendererMap.get(mode).getEdgeLabelRenderer();
    }

    protected ModalRenderer.Mode getModeFor(Supplier<Double> scaleSupplier) {
        if (!this.countPredicate.test(this.countSupplier)) {
            return HEAVYWEIGHT;
        }
        double scale = scaleSupplier.get();
        if (this.scalePredicate.test(scaleSupplier)) {
            return LIGHTWEIGHT;
        }
        return HEAVYWEIGHT;
    }

    protected void manageMode() {
        if (!this.countPredicate.test(this.countSupplier)) {
            this.setMode(HEAVYWEIGHT);
            this.component.repaint();
            return;
        }
        if (this.scalePredicate.test(this.scaleSupplier)) {
            this.setMode(LIGHTWEIGHT);
            this.component.repaint();
            return;
        }
        if (this.timer == null || this.timer.done) {
            this.timer = new Timer();
            this.timer.start();
        } else {
            this.timer.incrementValue();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (log.isTraceEnabled()) {
            log.trace("count supplier got {}", (Object)this.countSupplier.get());
            log.trace("count threshold is {}", (Object)this.lightweightRenderingCountThreshold);
            log.trace("count predicate {}", this.countPredicate);
            log.trace("scale supplier got {}", (Object)this.scaleSupplier.get());
            log.trace("scale threshold is {}", (Object)this.lightweightRenderingScaleThreshold);
        }
        this.manageMode();
    }

    static {
        PropertyLoader.load();
        LIGHTWEIGHT = new ModalRenderer.Mode();
        HEAVYWEIGHT = new ModalRenderer.Mode();
        log = LoggerFactory.getLogger(BiModalRenderer.class);
        TIMER_MAX = Integer.getInteger("jungrapht.modalRendererTimerMax", 10);
        TIMER_INCREMENT = Integer.getInteger("jungrapht.modalRendererTimerIncrement", 10);
        TIMER_SLEEP = Integer.getInteger("jungrapht.modalRendererTimerSleep", 30);
    }

    class Timer
    extends Thread {
        long value = TIMER_MAX;
        boolean done;

        Timer() {
            log.trace("timer start mode");
            BiModalRenderer.this.setMode(LIGHTWEIGHT);
            BiModalRenderer.this.component.repaint();
        }

        void incrementValue() {
            this.value = TIMER_INCREMENT;
        }

        @Override
        public void run() {
            this.done = false;
            while (this.value > 0L) {
                --this.value;
                try {
                    Thread.sleep(TIMER_SLEEP);
                }
                catch (InterruptedException interruptedException) {}
            }
            log.trace("timer end mode");
            if (BiModalRenderer.this.scalePredicate.test(BiModalRenderer.this.scaleSupplier)) {
                BiModalRenderer.this.setMode(LIGHTWEIGHT);
            } else {
                BiModalRenderer.this.setMode(HEAVYWEIGHT);
            }
            this.done = true;
            BiModalRenderer.this.component.repaint();
        }
    }

    public static class Builder<V, E, T extends BiModalRenderer<V, E>, B extends Builder<V, E, T, B>> {
        protected Map<ModalRenderer.Mode, Renderer<V, E>> rendererMap = new HashMap<ModalRenderer.Mode, Renderer<V, E>>();
        protected JComponent component;

        protected B self() {
            return (B)this;
        }

        public B component(JComponent component) {
            this.component = component;
            return this.self();
        }

        public B lightweightRenderer(Renderer<V, E> lightweightRenderer) {
            this.rendererMap.put(LIGHTWEIGHT, lightweightRenderer);
            return this.self();
        }

        public B heavyweightRenderer(Renderer<V, E> heavyweightRenderer) {
            this.rendererMap.put(HEAVYWEIGHT, heavyweightRenderer);
            return this.self();
        }

        public T build() {
            return (T)new BiModalRenderer(this);
        }
    }
}

