/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.examiner;

import ghidra.GhidraException;
import ghidra.GhidraTestApplicationLayout;
import ghidra.app.plugin.core.analysis.EmbeddedMediaAnalyzer;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BitmapResourceDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GifDataType;
import ghidra.program.model.data.IconResourceDataType;
import ghidra.program.model.data.JPEGDataType;
import ghidra.program.model.data.PngDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import utility.application.ApplicationLayout;

public class ProgramExaminer {
    private MessageLog messageLog;
    private Program program;
    private static Language defaultLanguage;

    public ProgramExaminer(byte[] bytes) throws GhidraException {
        this(ProgramExaminer.createByteProvider(bytes));
    }

    public ProgramExaminer(File file) throws GhidraException {
        this(ProgramExaminer.createByteProvider(file));
    }

    public String getType() {
        return this.program.getExecutableFormat();
    }

    private ProgramExaminer(ByteProvider provider) throws GhidraException {
        ProgramExaminer.initializeGhidra();
        this.messageLog = new MessageLog();
        try {
            this.program = AutoImporter.importByUsingBestGuess(provider, null, (Object)this, this.messageLog, TaskMonitor.DUMMY);
            if (this.program == null) {
                this.program = AutoImporter.importAsBinary(provider, null, defaultLanguage, null, (Object)this, this.messageLog, TaskMonitor.DUMMY);
            }
            if (this.program == null) {
                throw new GhidraException("Can't create program from input: " + this.messageLog.toString());
            }
        }
        catch (Exception e) {
            this.messageLog.appendException((Throwable)e);
            throw new GhidraException(e);
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized void initializeGhidra() throws GhidraException {
        if (!Application.isInitialized()) {
            GhidraTestApplicationLayout layout;
            try {
                layout = new GhidraTestApplicationLayout(new File(System.getProperty("java.io.tmpdir")));
            }
            catch (IOException e) {
                throw new GhidraException(e);
            }
            HeadlessGhidraApplicationConfiguration config = new HeadlessGhidraApplicationConfiguration();
            config.setInitializeLogging(false);
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)config);
        }
        if (defaultLanguage == null) {
            LanguageService languageService = DefaultLanguageService.getLanguageService();
            try {
                defaultLanguage = languageService.getDefaultLanguage(Processor.findOrPossiblyCreateProcessor((String)"DATA"));
            }
            catch (LanguageNotFoundException e) {
                throw new GhidraException("Can't load default language: DATA");
            }
        }
    }

    public void dispose() {
        this.program.release((Object)this);
    }

    public List<byte[]> getImages() {
        this.runImageAnalyzer();
        ArrayList<byte[]> imageList = new ArrayList<byte[]>();
        DataIterator it = this.program.getListing().getDefinedData(true);
        while (it.hasNext()) {
            this.accumulateImageData(imageList, it.next());
        }
        return imageList;
    }

    private void accumulateImageData(List<byte[]> imageList, Data data) {
        if (!this.isImage(data)) {
            return;
        }
        try {
            imageList.add(data.getBytes());
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
    }

    private void runImageAnalyzer() {
        int txID = this.program.startTransaction("find images");
        try {
            EmbeddedMediaAnalyzer imageAnalyzer = new EmbeddedMediaAnalyzer();
            imageAnalyzer.added(this.program, (AddressSetView)this.program.getMemory(), TaskMonitor.DUMMY, this.messageLog);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.program.endTransaction(txID, true);
        }
    }

    private boolean isImage(Data data) {
        DataType dataType = data.getDataType();
        if (dataType instanceof PngDataType) {
            return true;
        }
        if (dataType instanceof GifDataType) {
            return true;
        }
        if (dataType instanceof BitmapResourceDataType) {
            return true;
        }
        if (dataType instanceof IconResourceDataType) {
            return true;
        }
        return dataType instanceof JPEGDataType;
    }

    private static ByteProvider createByteProvider(byte[] bytes) throws GhidraException {
        if (bytes == null) {
            throw new GhidraException("Attempted to process a null byte[].");
        }
        if (bytes.length == 0) {
            throw new GhidraException("Attempted to process an empty byte[].");
        }
        return new ByteArrayProvider("Bytes", bytes);
    }

    private static ByteProvider createByteProvider(File file) throws GhidraException {
        if (file == null) {
            throw new GhidraException("Attempted to process a null file");
        }
        try {
            return new RandomAccessByteProvider(file);
        }
        catch (IOException e) {
            throw new GhidraException(e);
        }
    }
}

