/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.options;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import docking.widgets.label.GDLabel;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;

public class OptionsGui
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color DARK_GREEN = new Color(0, 128, 0);
    private static final Color BLUE_GREEN = new Color(0, 128, 64);
    private static final Color DARK_BLUE = new Color(0, 0, 128);
    private static final Color PALE_BLUE = new Color(128, 128, 255);
    private static final Color YELLOW_ORANGE = new Color(155, 150, 50);
    private static final Color PURPLE = new Color(155, 50, 155);
    private static final Color DEEP_PURPLE = new Color(75, 0, 130);
    private static final Color DARK_PURPLE = new Color(102, 0, 102);
    private static final Color DARK_CYAN = new Color(0, 102, 102);
    private static final Color DARK_ORANGE = new Color(255, 128, 0);
    private static final Color DARK_RED = new Color(130, 0, 75);
    private static final Highlight[] NO_HIGHLIGHTS = new Highlight[0];
    private static final HighlightFactory hlFactory = (field, text, cursorTextOffset) -> NO_HIGHLIGHTS;
    public static final ScreenElement COMMENT_AUTO = new ScreenElement("Comment, Automatic", Color.LIGHT_GRAY);
    public static final ScreenElement ADDRESS = new ScreenElement("Address", Color.BLACK);
    public static final ScreenElement BACKGROUND = new ScreenElement("Background", Color.WHITE);
    public static final ScreenElement BAD_REF_ADDR = new ScreenElement("Bad Reference Address", Color.RED);
    public static final ScreenElement BYTES = new ScreenElement("Bytes", Color.BLUE);
    public static final ScreenElement CONSTANT = new ScreenElement("Constant", BLUE_GREEN);
    public static final ScreenElement LABELS_UNREFD = new ScreenElement("Labels, Unreferenced", Color.BLACK);
    public static final ScreenElement ENTRY_POINT = new ScreenElement("Entry Point", Color.MAGENTA);
    public static final ScreenElement COMMENT_EOL = new ScreenElement("Comment, EOL", "EOL Comment", Color.BLUE);
    public static final ScreenElement EXT_REF_RESOLVED = new ScreenElement("External Reference, Resolved", Color.CYAN.darker().darker());
    public static final ScreenElement FIELD_NAME = new ScreenElement("Field Name", Color.BLACK);
    public static final ScreenElement FUN_CALL_FIXUP = new ScreenElement("Function Call-Fixup", new Color(255, 0, 204));
    public static final ScreenElement FUN_NAME = new ScreenElement("Function Name", Color.BLUE);
    public static final ScreenElement FUN_PARAMS = new ScreenElement("Function Parameters", Color.BLACK);
    public static final ScreenElement FUN_TAG = new ScreenElement("Function Tag", DARK_RED);
    public static final ScreenElement FUN_AUTO_PARAMS = new ScreenElement("Function Auto-Parameters", Color.GRAY);
    public static final ScreenElement FUN_RET_TYPE = new ScreenElement("Function Return Type", Color.BLACK);
    public static final ScreenElement COMMENT_REPEATABLE = new ScreenElement("Comment, Repeatable", DARK_ORANGE);
    public static final ScreenElement COMMENT_REF_REPEAT = new ScreenElement("Comment, Referenced Repeatable", new Color(190, 190, 255));
    public static final ScreenElement LABELS_LOCAL = new ScreenElement("Labels, Local", BLUE_GREEN);
    public static final ScreenElement MNEMONIC_OVERRIDE = new ScreenElement("Mnemonic, Override", new Color(255, 0, 204));
    public static final ScreenElement MNEMONIC = new ScreenElement("Mnemonic", DARK_BLUE);
    public static final ScreenElement UNIMPL = new ScreenElement("Unimplemented Mnemonic", Color.RED);
    public static final ScreenElement FLOW_ARROW_NON_ACTIVE = new ScreenElement("Flow Arrow, Not Active", new Color(160, 160, 160));
    public static final ScreenElement FLOW_ARROW_ACTIVE = new ScreenElement("Flow Arrow, Active", Color.BLACK);
    public static final ScreenElement FLOW_ARROW_SELECTED = new ScreenElement("Flow Arrow, Selected", new Color(0, 200, 0));
    public static final ScreenElement LABELS_NON_PRIMARY = new ScreenElement("Labels, Non-primary", YELLOW_ORANGE);
    public static final ScreenElement COMMENT_PLATE = new ScreenElement("Comment, Plate", "Plate Comment", Color.GRAY);
    public static final ScreenElement COMMENT_POST = new ScreenElement("Comment, Post", "Post-Comment", Color.BLUE);
    public static final ScreenElement COMMENT_PRE = new ScreenElement("Comment, Pre", "Pre-Comment", DEEP_PURPLE);
    public static final ScreenElement LABELS_PRIMARY = new ScreenElement("Labels, Primary", DARK_BLUE);
    public static final ScreenElement SEPARATOR = new ScreenElement("Separator", Color.BLACK);
    public static final ScreenElement VARIABLE = new ScreenElement("Variable", PURPLE);
    public static final ScreenElement PARAMETER_CUSTOM = new ScreenElement("Parameter, Custom Storage", DARK_PURPLE);
    public static final ScreenElement PARAMETER_DYNAMIC = new ScreenElement("Parameter, Dynamic Storage", DARK_CYAN);
    public static final ScreenElement VERSION_TRAK = new ScreenElement("Version Track", PURPLE);
    public static final ScreenElement XREF = new ScreenElement("XRef", DARK_GREEN);
    public static final ScreenElement XREF_OFFCUT = new ScreenElement("XRef, Offcut", Color.GRAY);
    public static final ScreenElement XREF_READ = new ScreenElement("XRef Read", Color.BLUE);
    public static final ScreenElement XREF_WRITE = new ScreenElement("XRef Write", DARK_ORANGE);
    public static final ScreenElement XREF_OTHER = new ScreenElement("XRef Other", Color.BLACK);
    public static final ScreenElement REGISTERS = new ScreenElement("Registers", YELLOW_ORANGE);
    public static final ScreenElement UNDERLINE = new ScreenElement("Underline", PALE_BLUE);
    public static final ScreenElement PCODE_LINE_LABEL = new ScreenElement("P-code Line Label", Color.BLUE);
    public static final ScreenElement PCODE_ADDR_SPACE = new ScreenElement("P-code Address Space", Color.BLUE);
    public static final ScreenElement PCODE_RAW_VARNODE = new ScreenElement("P-code Raw Varnode", Color.BLUE);
    public static final ScreenElement PCODE_USEROP = new ScreenElement("P-code Userop", Color.BLUE);
    static ScreenElement[] elements = new ScreenElement[]{ADDRESS, BACKGROUND, BAD_REF_ADDR, BYTES, COMMENT_AUTO, COMMENT_EOL, COMMENT_PLATE, COMMENT_POST, COMMENT_PRE, COMMENT_REPEATABLE, COMMENT_REF_REPEAT, CONSTANT, ENTRY_POINT, EXT_REF_RESOLVED, FIELD_NAME, FLOW_ARROW_ACTIVE, FLOW_ARROW_NON_ACTIVE, FUN_CALL_FIXUP, FUN_NAME, FUN_PARAMS, FUN_AUTO_PARAMS, FUN_RET_TYPE, FUN_TAG, LABELS_LOCAL, LABELS_NON_PRIMARY, LABELS_PRIMARY, LABELS_UNREFD, MNEMONIC, MNEMONIC_OVERRIDE, PARAMETER_CUSTOM, PARAMETER_DYNAMIC, PCODE_LINE_LABEL, PCODE_ADDR_SPACE, PCODE_RAW_VARNODE, PCODE_USEROP, REGISTERS, SEPARATOR, UNDERLINE, UNIMPL, VARIABLE, VERSION_TRAK, XREF, XREF_OFFCUT, XREF_READ, XREF_WRITE, XREF_OTHER};
    private Map<Integer, FontMetrics> metricsMap = new HashMap<Integer, FontMetrics>();
    private JList<ScreenElement> namesList;
    private JColorChooser colorChooser;
    private JCheckBox globalBoldCheckbox;
    private JCheckBox globalItalicsCheckbox;
    private JCheckBox boldCheckbox;
    private JCheckBox italicsCheckbox;
    private JCheckBox customCheckbox;
    private JComboBox<Integer> fontSizeField;
    private JComboBox<String> fontNameField;
    private JPanel colorPanel;
    private int selectedIndex;
    private Font baseFont;
    private FontMetrics baseMetrics;
    private Layout[] layouts;
    private LayoutModelListener modelListener;
    private int maxWidth;
    private FieldPanel fieldPanel;
    private PropertyChangeListener propertyChangeListener;

    public OptionsGui(Font font, PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
        this.setBaseFont(SystemUtilities.adjustForFontSizeOverride((Font)font));
        this.genLayouts();
        this.buildPanel();
        this.fieldPanel.setBackgroundColor(BACKGROUND.getColor());
        this.fieldPanel.addFieldMouseListener((location, field, ev) -> {
            ScreenElementTextField elementField = (ScreenElementTextField)field;
            ScreenElement selectedElement = elementField.getScreenElement();
            this.namesList.setSelectedValue(selectedElement, true);
        });
        this.setSelectedFontName(this.baseFont.getName());
        this.fontSizeField.setSelectedItem(this.baseFont.getSize());
        this.namesList.setSelectedIndex(0);
        this.namesList.setSelectionMode(0);
        this.namesList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.namesList.getSelectedIndex();
            if (index == -1) {
                this.namesList.setSelectedIndex(this.selectedIndex);
            } else {
                this.setSelectedIndex(index);
            }
        });
        this.setSelectedIndex(0);
        this.colorChooser.getSelectionModel().addChangeListener(e -> {
            Color c = this.colorChooser.getColor();
            elements[this.selectedIndex].setColor(c);
            this.colorPanel.setBackground(c);
            this.genLayouts();
            this.fieldPanel.setBackgroundColor(BACKGROUND.getColor());
            this.enableApply();
        });
        ActionListener styleListener = e -> {
            this.updateStyle();
            this.genLayouts();
            this.fieldPanel.setBackgroundColor(BACKGROUND.getColor());
            this.enableApply();
        };
        ActionListener familyListener = e -> {
            this.updateFonts();
            this.genLayouts();
            this.fieldPanel.setBackgroundColor(BACKGROUND.getColor());
            this.enableApply();
        };
        this.boldCheckbox.addActionListener(styleListener);
        this.italicsCheckbox.addActionListener(styleListener);
        this.customCheckbox.addActionListener(styleListener);
        this.globalBoldCheckbox.addActionListener(familyListener);
        this.globalItalicsCheckbox.addActionListener(familyListener);
        this.fontSizeField.addActionListener(familyListener);
        this.fontNameField.addActionListener(familyListener);
        this.globalBoldCheckbox.setSelected(this.baseFont.isBold());
        this.globalItalicsCheckbox.setSelected(this.baseFont.isItalic());
    }

    private void setSelectedFontName(String name) {
        int n = this.fontNameField.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!name.equalsIgnoreCase(this.fontNameField.getItemAt(i))) continue;
            this.fontNameField.setSelectedIndex(i);
            return;
        }
    }

    private void setSelectedIndex(int index) {
        this.selectedIndex = index;
        Color c = elements[this.selectedIndex].getColor();
        int style = elements[this.selectedIndex].getStyle();
        this.colorPanel.setBackground(c);
        this.colorChooser.setColor(c);
        if (style == -1) {
            this.customCheckbox.setSelected(false);
            this.boldCheckbox.setSelected(this.baseFont.isBold());
            this.italicsCheckbox.setSelected(this.baseFont.isItalic());
            this.boldCheckbox.setEnabled(false);
            this.italicsCheckbox.setEnabled(false);
        } else {
            this.customCheckbox.setSelected(true);
            this.boldCheckbox.setSelected((style & 1) != 0);
            this.italicsCheckbox.setSelected((style & 2) != 0);
            this.boldCheckbox.setEnabled(true);
            this.italicsCheckbox.setEnabled(true);
        }
    }

    public void setBaseFont(Font font) {
        this.baseFont = font;
        this.baseMetrics = this.getFontMetrics(font);
        this.metricsMap.clear();
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public void updateDisplay() {
        this.setSelectedIndex(this.selectedIndex);
        this.fieldPanel.setBackgroundColor(BACKGROUND.getColor());
        this.genLayouts();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildColorChooserPanel(), "Center");
        this.add((Component)this.buildSelectionPanel(), "West");
    }

    private JComponent buildColorChooserPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(new JPanel());
        panel.add((Component)this.colorChooser, "North");
        panel.add((Component)this.buildPreviewPanel(), "Center");
        return panel;
    }

    private JComponent buildSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.namesList = new JList<ScreenElement>(elements);
        this.namesList.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this.namesList);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        scrollPane.setBorder(BorderFactory.createTitledBorder(border, "Screen Element"));
        panel.add((Component)this.buildGlobalOptionsPanel(), "North");
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.buildElementOptionsPanel(), "South");
        return panel;
    }

    private JPanel buildGlobalOptionsPanel() {
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(border, "Font"));
        JPanel panel1 = new JPanel(new FlowLayout());
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] envfonts = gEnv.getAvailableFontFamilyNames();
        this.fontNameField = new GComboBox(envfonts);
        this.fontNameField.setBackground(Color.white);
        this.fontNameField.setRenderer(new FontRenderer());
        panel1.add(this.fontNameField);
        this.fontSizeField = new GComboBox((Object[])((Integer[])IntStream.rangeClosed(6, 32).boxed().toArray(Integer[]::new)));
        this.fontSizeField.setBackground(Color.white);
        panel1.add(this.fontSizeField);
        panel.add((Component)panel1, "North");
        JPanel panel2 = new JPanel(new FlowLayout());
        JPanel subPanel = new JPanel(new GridLayout(1, 2, 2, 4));
        this.globalBoldCheckbox = new GCheckBox("Bold");
        this.globalItalicsCheckbox = new GCheckBox("Italics");
        subPanel.add(this.globalBoldCheckbox);
        subPanel.add(this.globalItalicsCheckbox);
        panel2.add(subPanel);
        panel.add((Component)panel2, "South");
        return panel;
    }

    private JPanel buildElementOptionsPanel() {
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subPanel = new JPanel(new GridLayout(1, 3, 2, 4));
        subPanel.setBorder(BorderFactory.createTitledBorder(border, "Style Settings"));
        this.boldCheckbox = new GCheckBox("Bold");
        this.italicsCheckbox = new GCheckBox("Italics");
        this.customCheckbox = new GCheckBox("Custom");
        subPanel.add(this.customCheckbox);
        subPanel.add(this.boldCheckbox);
        subPanel.add(this.italicsCheckbox);
        panel.add((Component)subPanel, "South");
        subPanel = new JPanel(new BorderLayout());
        subPanel.setBorder(BorderFactory.createTitledBorder(border, "Color"));
        this.colorPanel = new JPanel();
        this.colorPanel.setBackground(Color.white);
        subPanel.add((Component)this.colorPanel, "Center");
        panel.add((Component)subPanel, "North");
        return panel;
    }

    private JComponent buildPreviewPanel() {
        this.fieldPanel = new FieldPanel((LayoutModel)new SimpleLayoutModel());
        IndexedScrollPane scroll = new IndexedScrollPane((JComponent)this.fieldPanel);
        return scroll;
    }

    private void genLayouts() {
        this.maxWidth = 0;
        ArrayList<Layout> list = new ArrayList<Layout>();
        LayoutBuilder lb = new LayoutBuilder(1);
        lb.add("     /***********************************/", COMMENT_PLATE);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("     /*             PLATE               */", COMMENT_PLATE);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("     /***********************************/", COMMENT_PLATE);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("     Tags: tag1, tag2", FUN_TAG);
        lb.add("         ", null);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("       ", null);
        lb.add("entry", ENTRY_POINT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(5);
        lb.add("1000", ADDRESS);
        lb.add("         ", null);
        lb.add("c2 17 3d       ", BYTES);
        lb.add("call   ", MNEMONIC);
        lb.add("printf", LABELS_NON_PRIMARY);
        lb.add("         ", null);
        lb.add("; End of line comment ", COMMENT_EOL);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(5);
        lb.add("1003", ADDRESS);
        lb.add("         ", null);
        lb.add("23 15 3d       ", BYTES);
        lb.add("call   ", MNEMONIC_OVERRIDE);
        lb.add("0x10000", BAD_REF_ADDR);
        lb.add("        ", null);
        lb.add("; 0x10000 is not in memory ", COMMENT_EOL);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(7);
        lb.add("1006", ADDRESS);
        lb.add("         ", null);
        lb.add("b2 3f 2d       ", BYTES);
        lb.add("mov    ", MNEMONIC);
        lb.add("ax", REGISTERS, true);
        lb.add(",[", SEPARATOR, true);
        lb.add("LAB2000", LABELS_PRIMARY, true);
        lb.add("]", SEPARATOR, true);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("       ", null);
        lb.add("LAB1009", LABELS_PRIMARY);
        lb.add("                                   ", null);
        lb.add("XREF[1,1]: 100c,", XREF);
        lb.add(" 1012", XREF_OFFCUT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(5);
        lb.add("1009", ADDRESS);
        lb.add("         ", null);
        lb.add("c5 b2 32       ", BYTES);
        lb.add("call   ", MNEMONIC);
        lb.add("sprintf", LABELS_NON_PRIMARY);
        lb.add("        ", null);
        lb.add("; alias label ", COMMENT_EOL);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(4);
        lb.add("100c", ADDRESS);
        lb.add("         ", null);
        lb.add("24 4e ff       ", BYTES);
        lb.add("jnz    ", MNEMONIC);
        lb.add("LAB1009", LABELS_PRIMARY);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(8);
        lb.add("100f", ADDRESS);
        lb.add("         ", null);
        lb.add("23 35 d2       ", BYTES);
        lb.add("mov", MNEMONIC, true);
        lb.add("    ", MNEMONIC);
        lb.add("ax", REGISTERS);
        lb.add(",[", SEPARATOR);
        lb.add("dataAlias", LABELS_NON_PRIMARY);
        lb.add("]", SEPARATOR);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(4);
        lb.add("1012", ADDRESS);
        lb.add("         ", null);
        lb.add("22 f3 b2       ", BYTES);
        lb.add("jnz    ", MNEMONIC);
        lb.add("LAB1009+1", LABELS_NON_PRIMARY, true);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(4);
        lb.add("1016", ADDRESS);
        lb.add("         ", null);
        lb.add("c5 48 9d       ", BYTES);
        lb.add("call   ", MNEMONIC);
        lb.add("MyFunc", FUN_NAME);
        lb.add("        ", null);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add(".........", SEPARATOR);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("       ", null);
        lb.add("sprintf", LABELS_NON_PRIMARY);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("       ", null);
        lb.add("printf", ENTRY_POINT);
        lb.add("                                    ", null);
        lb.add("XREF[2,0]: 1000, 1009", XREF);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(7);
        lb.add("1500", ADDRESS);
        lb.add("         ", null);
        lb.add("23 35 d2       ", BYTES);
        lb.add("mov    ", MNEMONIC);
        lb.add("[", SEPARATOR);
        lb.add("DATA", LABELS_PRIMARY);
        lb.add("],", SEPARATOR);
        lb.add("0x73", CONSTANT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("//  This is a pre-comment", COMMENT_PRE);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("1503", ADDRESS);
        lb.add("         ", null);
        lb.add("bc       ", BYTES);
        lb.add("ret    ", MNEMONIC);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("//  This is a post-comment", COMMENT_POST);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add(".........", SEPARATOR);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("       ", null);
        lb.add("LAB2000", LABELS_PRIMARY);
        lb.add("                                   ", null);
        lb.add("XREF[1,0]: 1006", XREF);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(4);
        lb.add("2000", ADDRESS);
        lb.add("         ", null);
        lb.add("24 4e          ", BYTES);
        lb.add("dw    ", MNEMONIC);
        lb.add("0x07", CONSTANT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("       ", null);
        lb.add("dataAlias", LABELS_NON_PRIMARY);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("       ", null);
        lb.add("DATA", LABELS_PRIMARY);
        lb.add("                                      ", null);
        lb.add("XREF[2,0]: 100f, 1500", XREF);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(8);
        lb.add("2002", ADDRESS);
        lb.add("         ", null);
        lb.add("00 18 00 21    ", BYTES);
        lb.add("Struct Point    ", MNEMONIC);
        lb.add("(", SEPARATOR);
        lb.add("24", CONSTANT);
        lb.add(",", SEPARATOR);
        lb.add("33", CONSTANT);
        lb.add(")", SEPARATOR);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("                            ", null);
        lb.add("X", FIELD_NAME);
        lb.add("    ", null);
        lb.add("24", CONSTANT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("                            ", null);
        lb.add("Y", FIELD_NAME);
        lb.add("    ", null);
        lb.add("33", CONSTANT);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("       ", null);
        lb.add("//  This is a function comment", COMMENT_EOL);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(13);
        lb.add("       ", null);
        lb.add("Word ", FUN_RET_TYPE);
        lb.add("MyFunc ", FUN_NAME);
        lb.add("(", SEPARATOR);
        lb.add("DWord auto-x", FUN_AUTO_PARAMS);
        lb.add(", ", SEPARATOR);
        lb.add("DWord y", FUN_PARAMS);
        lb.add(", ", SEPARATOR);
        lb.add("DWord z", FUN_PARAMS);
        lb.add(", ", SEPARATOR);
        lb.add("Word n", FUN_PARAMS);
        lb.add(",", SEPARATOR);
        lb.add("Float delta", FUN_PARAMS);
        lb.add(")", SEPARATOR);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(1);
        lb.add("          ", null);
        lb.add("Call-Fixup: _MyFuncFixup ", FUN_CALL_FIXUP);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("       ", null);
        lb.add("12    ", PARAMETER_DYNAMIC);
        lb.add("DWord  ", PARAMETER_DYNAMIC);
        lb.add("param_12  ", PARAMETER_DYNAMIC);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("       ", null);
        lb.add("8    ", PARAMETER_CUSTOM);
        lb.add("DWord  ", PARAMETER_CUSTOM);
        lb.add("param_8  ", PARAMETER_CUSTOM);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("       ", null);
        lb.add("4    ", PARAMETER_CUSTOM);
        lb.add("Word   ", PARAMETER_CUSTOM);
        lb.add("param_4  ", PARAMETER_CUSTOM);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(3);
        lb.add("       ", null);
        lb.add("-4   ", VARIABLE);
        lb.add("Float  ", VARIABLE);
        lb.add("local_4  ", VARIABLE);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(2);
        lb.add("       ", null);
        lb.add("MyFunc", LABELS_PRIMARY);
        lb.add("                                      ", null);
        lb.add("XREF[2,0]: 4e5a, d56e", XREF);
        list.add(lb.getLayout());
        lb = new LayoutBuilder(4);
        lb.add("2006", ADDRESS);
        lb.add("         ", null);
        lb.add("3a ef 43       ", BYTES);
        lb.add("mov    ", MNEMONIC);
        lb.add("DAT0000", BAD_REF_ADDR);
        lb.add("        ", null);
        list.add(lb.getLayout());
        this.layouts = new Layout[list.size()];
        list.toArray(this.layouts);
        if (this.modelListener != null) {
            this.modelListener.dataChanged(BigInteger.ZERO, BigInteger.valueOf(this.layouts.length));
        }
    }

    private void updateStyle() {
        if (this.customCheckbox.isSelected()) {
            int style = 0;
            if (this.boldCheckbox.isSelected()) {
                style |= 1;
            }
            if (this.italicsCheckbox.isSelected()) {
                style |= 2;
            }
            elements[this.selectedIndex].setStyle(style);
        } else {
            elements[this.selectedIndex].setStyle(-1);
        }
        this.setSelectedIndex(this.selectedIndex);
    }

    private FontMetrics getMetrics(int style) {
        Integer i = style;
        FontMetrics fm = this.metricsMap.get(i);
        if (fm == null) {
            if (style == -1) {
                fm = this.getFontMetrics(this.baseFont);
                this.metricsMap.put(i, fm);
            } else {
                Font font = new Font(this.baseFont.getName(), style, this.baseFont.getSize());
                fm = this.getFontMetrics(font);
                this.metricsMap.put(i, fm);
            }
        }
        return fm;
    }

    private void enableApply() {
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", null, Boolean.TRUE));
    }

    void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    private void updateFonts() {
        String name = (String)this.fontNameField.getSelectedItem();
        int size = this.baseFont.getSize();
        try {
            size = (Integer)this.fontSizeField.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (size < 6) {
            size = 6;
        } else if (size > 50) {
            size = 50;
        }
        int style = 0;
        if (this.globalBoldCheckbox.isSelected()) {
            style |= 1;
        }
        if (this.globalItalicsCheckbox.isSelected()) {
            style |= 2;
        }
        this.setBaseFont(new Font(name, style, size));
        this.setSelectedIndex(this.selectedIndex);
    }

    class FontRenderer
    extends GDLabel
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = 1L;
        private final Color SELECTED_COLOR = new Color(10, 36, 106);

        public FontRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value);
            Font origFont = OptionsGui.this.fontNameField.getFont();
            this.setFont(new Font(value.toString(), origFont.getStyle(), origFont.getSize()));
            this.setBackground(isSelected ? this.SELECTED_COLOR : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    class SimpleLayoutModel
    implements LayoutModel {
        SimpleLayoutModel() {
        }

        public boolean isUniform() {
            return false;
        }

        public Layout getLayout(int index) {
            return OptionsGui.this.layouts[index];
        }

        public Layout getLayout(BigInteger index) {
            return OptionsGui.this.layouts[index.intValue()];
        }

        public void addLayoutModelListener(LayoutModelListener listener) {
            OptionsGui.this.modelListener = listener;
        }

        public void flushChanges() {
        }

        public BigInteger getIndexAfter(BigInteger index) {
            int i = index.intValue() + 1;
            if (i >= OptionsGui.this.layouts.length) {
                return null;
            }
            return BigInteger.valueOf(i);
        }

        public BigInteger getIndexBefore(BigInteger index) {
            if (index.compareTo(BigInteger.ZERO) <= 0) {
                return null;
            }
            return index.subtract(BigInteger.ONE);
        }

        public Dimension getPreferredViewSize() {
            return new Dimension(OptionsGui.this.maxWidth, 500);
        }

        public void removeLayoutModelListener(LayoutModelListener listener) {
            OptionsGui.this.modelListener = null;
        }

        public BigInteger getNumIndexes() {
            return BigInteger.valueOf(OptionsGui.this.layouts.length);
        }
    }

    class LayoutBuilder {
        private ClippingTextField[] fields;
        int startPos;
        int fieldNum;

        LayoutBuilder(int size) {
            this.fields = new ClippingTextField[size];
        }

        void add(String text, ScreenElement element) {
            this.add(text, element, false);
        }

        void add(String text, ScreenElement element, boolean underline) {
            if (this.fieldNum == 0) {
                text = "    " + (String)text;
            }
            if (element == null) {
                this.startPos += OptionsGui.this.baseMetrics.stringWidth((String)text);
            } else {
                FontMetrics metrics = OptionsGui.this.getMetrics(element.getStyle());
                int length = metrics.stringWidth((String)text);
                AttributedString as = new AttributedString((String)text, element.getColor(), metrics, underline, UNDERLINE.getColor());
                TextFieldElement field = new TextFieldElement(as, 0, 0);
                this.fields[this.fieldNum] = new ScreenElementTextField(element, this.startPos, length, (FieldElement)field, hlFactory);
                ++this.fieldNum;
                this.startPos += length;
                OptionsGui.this.maxWidth = Math.max(OptionsGui.this.maxWidth, this.startPos);
            }
        }

        Layout getLayout() {
            return new SingleRowLayout((Field[])this.fields);
        }
    }

    private class ScreenElementTextField
    extends ClippingTextField {
        private ScreenElement screenElement;

        ScreenElementTextField(ScreenElement screenElement, int startX, int length, FieldElement field, HighlightFactory factory) {
            super(startX, length, field, factory);
            this.screenElement = screenElement;
        }

        ScreenElement getScreenElement() {
            return this.screenElement;
        }
    }
}

