/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.extend.ElfExtensionFactory;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Register;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import java.util.List;

public class ElfLoaderOptionsFactory {
    public static final String PERFORM_RELOCATIONS_NAME = "Perform Symbol Relocations";
    static final boolean PERFORM_RELOCATIONS_DEFAULT = true;
    public static final String IMAGE_BASE_OPTION_NAME = "Image Base";
    public static final long IMAGE_BASE_DEFAULT = 65536L;
    public static final long IMAGE64_BASE_DEFAULT = 0x100000L;
    public static final String IMAGE_DATA_IMAGE_BASE_OPTION_NAME = "Data Image Base";
    public static final String INCLUDE_OTHER_BLOCKS = "Import Non-Loaded Data";
    static final boolean INCLUDE_OTHER_BLOCKS_DEFAULT = true;

    private ElfLoaderOptionsFactory() {
    }

    static void addOptions(List<Option> options, ByteProvider provider, LoadSpec loadSpec) throws ElfException, LanguageNotFoundException {
        options.add(new Option(PERFORM_RELOCATIONS_NAME, true, Boolean.class, "-loader-applyRelocations"));
        ElfHeader elf = new ElfHeader(provider, null);
        long imageBase = elf.findImageBase();
        if (imageBase == 0L && (elf.isRelocatable() || elf.isSharedObject())) {
            imageBase = elf.is64Bit() ? 0x100000L : 65536L;
        }
        Language language = loadSpec.getLanguageCompilerSpec().getLanguage();
        AddressSpace defaultSpace = language.getDefaultSpace();
        String hexValueStr = ElfLoaderOptionsFactory.getBaseAddressOffsetString(imageBase, defaultSpace);
        options.add(new Option(IMAGE_BASE_OPTION_NAME, hexValueStr, String.class, "-loader-imagebase"));
        if (ElfLoaderOptionsFactory.includeDataImageBaseOption(elf, language)) {
            long minDataImageBase = ElfLoaderOptionsFactory.getRecommendedMinimumDataImageBase(elf, language);
            hexValueStr = ElfLoaderOptionsFactory.getBaseAddressOffsetString(minDataImageBase, language.getDefaultDataSpace());
            options.add(new Option(IMAGE_DATA_IMAGE_BASE_OPTION_NAME, hexValueStr, String.class, "-loader-dataImageBase"));
        }
        options.add(new Option(INCLUDE_OTHER_BLOCKS, true, Boolean.class, "-loader-includeOtherBlocks"));
        ElfLoadAdapter extensionAdapter = ElfExtensionFactory.getLoadAdapter(elf);
        if (extensionAdapter != null) {
            extensionAdapter.addLoadOptions(elf, options);
        }
    }

    private static boolean includeDataImageBaseOption(ElfHeader elf, Language language) {
        AddressSpace defaultSpace = language.getDefaultSpace();
        AddressSpace defaultDataSpace = language.getDefaultDataSpace();
        if (defaultDataSpace.equals(defaultSpace)) {
            return false;
        }
        return elf.isRelocatable() && elf.getImageBase() == 0L;
    }

    private static long getRecommendedMinimumDataImageBase(ElfHeader elf, Language language) {
        String minDataOffset = language.getProperty("minimumDataImageBase");
        if (minDataOffset != null) {
            return NumericUtilities.parseHexLong((String)minDataOffset);
        }
        AddressSpace defaultDataSpace = language.getDefaultDataSpace();
        int unitSize = defaultDataSpace.getAddressableUnitSize();
        long minOffset = 0L;
        for (Register reg : language.getRegisters()) {
            long offset;
            Address addr = reg.getAddress();
            if (!defaultDataSpace.equals(addr.getAddressSpace()) || (offset = addr.getOffset()) < 0L || (offset += (long)reg.getMinimumByteSize()) <= minOffset) continue;
            minOffset = offset;
        }
        int align = 16 * unitSize;
        minOffset += (long)align - minOffset % (long)align;
        return minOffset / (long)unitSize;
    }

    private static String getBaseAddressOffsetString(long imageBase, AddressSpace space) {
        long maxOffset = space.getMaxAddress().getAddressableWordOffset();
        while (Long.compareUnsigned(imageBase, maxOffset) > 0) {
            imageBase >>>= 4;
        }
        String baseOffsetStr = Long.toHexString(imageBase);
        int minNibbles = Math.min(8, space.getSize() / 4);
        int baseOffsetStrLen = baseOffsetStr.length();
        if (baseOffsetStrLen < minNibbles) {
            baseOffsetStr = StringUtilities.pad((String)baseOffsetStr, (char)'0', (int)(minNibbles - baseOffsetStrLen));
        }
        return baseOffsetStr;
    }

    static String validateOptions(LoadSpec loadSpec, List<Option> options) {
        Language language;
        try {
            language = loadSpec.getLanguageCompilerSpec().getLanguage();
        }
        catch (LanguageNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Option option : options) {
            String name = option.getName();
            if (name.equals(PERFORM_RELOCATIONS_NAME)) {
                if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
            if (name.equals(INCLUDE_OTHER_BLOCKS)) {
                if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
            if (name.equals(IMAGE_BASE_OPTION_NAME)) {
                return ElfLoaderOptionsFactory.validateAddressSpaceOffsetOption(option, language.getDefaultSpace());
            }
            if (!name.equals(IMAGE_DATA_IMAGE_BASE_OPTION_NAME)) continue;
            return ElfLoaderOptionsFactory.validateAddressSpaceOffsetOption(option, language.getDefaultDataSpace());
        }
        return null;
    }

    private static String validateAddressSpaceOffsetOption(Option option, AddressSpace space) {
        String name = option.getName();
        if (!String.class.isAssignableFrom(option.getValueClass())) {
            return "Invalid type for option: " + name + " - " + option.getValueClass();
        }
        String value = (String)option.getValue();
        try {
            space.getAddress(Long.parseUnsignedLong(value, 16), true);
        }
        catch (NumberFormatException e) {
            return "Invalid " + name + " - expecting hexidecimal address offset";
        }
        catch (AddressOutOfBoundsException e) {
            return "Invalid " + name + " - " + e.getMessage();
        }
        return null;
    }

    static boolean performRelocations(List<Option> options) {
        return OptionUtils.getOption(PERFORM_RELOCATIONS_NAME, options, true);
    }

    static boolean includeOtherBlocks(List<Option> options) {
        return OptionUtils.getOption(INCLUDE_OTHER_BLOCKS, options, true);
    }

    static boolean hasImageBaseOption(List<Option> options) {
        return OptionUtils.containsOption(IMAGE_BASE_OPTION_NAME, options);
    }

    public static String getImageBaseOption(List<Option> options) {
        return OptionUtils.getOption(IMAGE_BASE_OPTION_NAME, options, null);
    }

    public static String getDataImageBaseOption(List<Option> options) {
        return OptionUtils.getOption(IMAGE_DATA_IMAGE_BASE_OPTION_NAME, options, null);
    }
}

