/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SymbolTableCommand
extends LoadCommand {
    private int symoff;
    private int nsyms;
    private int stroff;
    private int strsize;
    private List<NList> symbols = new ArrayList<NList>();

    public SymbolTableCommand(BinaryReader loadCommandReader, BinaryReader dataReader, MachHeader header) throws IOException {
        super(loadCommandReader);
        this.symoff = loadCommandReader.readNextInt();
        this.nsyms = loadCommandReader.readNextInt();
        this.stroff = loadCommandReader.readNextInt();
        this.strsize = loadCommandReader.readNextInt();
        ArrayList<NList> nlistList = new ArrayList<NList>(this.nsyms);
        dataReader.setPointerIndex(header.getStartIndex() + (long)this.symoff);
        for (int i = 0; i < this.nsyms; ++i) {
            nlistList.add(new NList(dataReader, header.is32bit()));
        }
        List sortedList = nlistList.stream().sorted((o1, o2) -> Integer.compare(o1.getStringTableIndex(), o2.getStringTableIndex())).collect(Collectors.toList());
        for (NList nList : sortedList) {
            nList.initString(dataReader, this.stroff);
        }
        this.symbols = nlistList;
    }

    public int getSymbolOffset() {
        return this.symoff;
    }

    public int getNumberOfSymbols() {
        return this.nsyms;
    }

    public int getStringTableOffset() {
        return this.stroff;
    }

    public int getStringTableSize() {
        return this.strsize;
    }

    public List<NList> getSymbols() {
        return this.symbols;
    }

    public NList getSymbolAt(int index) {
        if ((index & Integer.MIN_VALUE) != 0 || (index & 0x40000000) != 0) {
            return null;
        }
        if (index > this.symbols.size()) {
            Msg.error((Object)this, (Object)("Attempt to get symbols at " + Integer.toHexString(index)));
            return null;
        }
        return this.symbols.get(index);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "symoff", null);
        struct.add(DWORD, "nsyms", null);
        struct.add(DWORD, "stroff", null);
        struct.add(DWORD, "strsize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "symtab_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        if (isBinary) {
            try {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
                if (this.getStringTableSize() > 0) {
                    Address stringTableStart = baseAddress.getNewAddress((long)this.getStringTableOffset());
                    api.createFragment(parentModule, "string_table", stringTableStart, this.getStringTableSize());
                }
                int symbolIndex = 0;
                Address symbolStartAddr = baseAddress.getNewAddress((long)this.getSymbolOffset());
                long offset = 0L;
                for (NList symbol : this.symbols) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    DataType symbolDT = symbol.toDataType();
                    Address symbolAddr = symbolStartAddr.add(offset);
                    Data symbolData = api.createData(symbolAddr, symbolDT);
                    Address stringAddress = baseAddress.getNewAddress((long)(this.getStringTableOffset() + symbol.getStringTableIndex()));
                    Data stringData = api.createAsciiString(stringAddress);
                    String string = (String)stringData.getValue();
                    Reference ref = api.createMemoryReference(symbolData, stringAddress, RefType.DATA);
                    api.setReferencePrimary(ref, false);
                    api.setPlateComment(symbolAddr, string + "\nIndex:           0x" + Integer.toHexString(symbolIndex) + "\nValue:           0x" + Long.toHexString(symbol.getValue()) + "\nDescription:     0x" + Long.toHexString(symbol.getDescription() & 0xFFFF) + "\nLibrary Ordinal: 0x" + Long.toHexString(symbol.getLibraryOrdinal() & 0xFF));
                    offset += (long)symbolDT.getLength();
                    ++symbolIndex;
                }
                if (this.getNumberOfSymbols() > 0) {
                    api.createFragment(parentModule, "symbols", symbolStartAddr, offset);
                }
            }
            catch (Exception e) {
                log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
            }
        }
    }
}

