/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFAttributeSpecification;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFPreconditionException;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeFactory;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFEncoding;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf4.next.DWARFRegisterMappingsManager;
import ghidra.app.util.bin.format.dwarf4.next.StringTable;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.CompressedSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DSymSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionNames;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProviderFactory;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class DWARFProgram
implements Closeable {
    public static final String DWARF_ROOT_NAME = "DWARF";
    public static final int DEFAULT_NAME_LENGTH_CUTOFF = 2000;
    public static final int MAX_NAME_LENGTH_CUTOFF = 2000;
    public static final int MIN_NAME_LENGTH_CUTOFF = 20;
    private static final int NAME_HASH_REPLACEMENT_SIZE = 12;
    private static final String ELLIPSES_STR = "...";
    private final Program program;
    private DWARFImportOptions importOptions;
    private DWARFNameInfo rootDNI = DWARFNameInfo.createRoot(new CategoryPath(CategoryPath.ROOT, new String[]{"DWARF"}));
    private DWARFNameInfo unCatDataTypeRoot = DWARFNameInfo.createRoot(new CategoryPath(this.rootDNI.getOrganizationalCategoryPath(), new String[]{"_UNCATEGORIZED_"}));
    private DWARFSectionProvider sectionProvider;
    private StringTable debugStrings;
    private List<DWARFCompilationUnit> compUnits = new ArrayList<DWARFCompilationUnit>();
    private DWARFCompilationUnit currentCompUnit;
    private DWARFAttributeFactory attributeFactory;
    private int totalDIECount = -1;
    private int totalAggregateCount;
    private boolean foundCrossCURefs = false;
    private long programBaseAddressFixup;
    private int maxDNICacheSize = 50;
    private FixedSizeHashMap<Long, DWARFNameInfo> dniCache = new FixedSizeHashMap(100, this.maxDNICacheSize);
    private int nameLengthCutoffSize = 2000;
    private Map<DWARFAttributeSpecification, DWARFAttributeSpecification> attributeSpecIntern = new HashMap<DWARFAttributeSpecification, DWARFAttributeSpecification>();
    private BinaryReader debugLocation;
    private BinaryReader debugRanges;
    private BinaryReader debugInfoBR;
    private BinaryReader debugLineBR;
    private BinaryReader debugAbbrBR;
    private DWARFRegisterMappings dwarfRegisterMappings;
    private List<DebugInfoEntry> currentDIEs = new ArrayList<DebugInfoEntry>();
    private Map<Long, DebugInfoEntry> offsetMap = new HashMap<Long, DebugInfoEntry>();
    private Map<Long, DIEAggregate> aggregatesByOffset = new HashMap<Long, DIEAggregate>();
    private List<DIEAggregate> aggregates = new ArrayList<DIEAggregate>();
    private ListValuedMap<Long, DIEAggregate> typeReferers = new ArrayListValuedHashMap();

    public static boolean isDWARF(Program program) {
        String format;
        switch (format = Objects.requireNonNullElse(program.getExecutableFormat(), "")) {
            case "Executable and Linking Format (ELF)": 
            case "Portable Executable (PE)": {
                return DWARFProgram.hasExpectedDWARFSections(program) || ExternalDebugInfo.fromProgram(program) != null;
            }
            case "Mac OS X Mach-O": {
                return DWARFProgram.hasExpectedDWARFSections(program) || DSymSectionProvider.getDSYMForProgram(program) != null;
            }
        }
        return false;
    }

    private static boolean hasExpectedDWARFSections(Program program) {
        try (CompressedSectionProvider tmp = new CompressedSectionProvider(new BaseSectionProvider(program));){
            boolean bl = tmp.hasSection(DWARFSectionNames.MINIMAL_DWARF_SECTIONS);
            return bl;
        }
    }

    public static boolean hasDWARFData(Program program, TaskMonitor monitor) {
        if (!DWARFProgram.isDWARF(program)) {
            return false;
        }
        try (DWARFSectionProvider dsp = DWARFSectionProviderFactory.createSectionProviderFor(program, monitor);){
            boolean bl = dsp != null;
            return bl;
        }
    }

    public DWARFProgram(Program program, DWARFImportOptions importOptions, TaskMonitor monitor) throws CancelledException, IOException, DWARFException {
        this(program, importOptions, monitor, DWARFSectionProviderFactory.createSectionProviderFor(program, monitor));
    }

    public DWARFProgram(Program program, DWARFImportOptions importOptions, TaskMonitor monitor, DWARFSectionProvider sectionProvider) throws CancelledException, IOException, DWARFException {
        Long oib;
        boolean hasRelocations;
        if (sectionProvider == null) {
            throw new IllegalArgumentException("Null DWARFSectionProvider");
        }
        this.program = program;
        this.sectionProvider = sectionProvider;
        this.importOptions = importOptions;
        this.nameLengthCutoffSize = Math.max(20, Math.min(importOptions.getNameLengthCutoff(), 2000));
        monitor.setMessage("Reading DWARF debug string table");
        this.debugStrings = StringTable.readStringTable(sectionProvider.getSectionAsByteProvider("debug_str", monitor));
        this.attributeFactory = new DWARFAttributeFactory(this);
        this.debugLocation = this.getBinaryReaderFor("debug_loc", monitor);
        this.debugInfoBR = this.getBinaryReaderFor("debug_info", monitor);
        this.debugLineBR = this.getBinaryReaderFor("debug_line", monitor);
        this.debugAbbrBR = this.getBinaryReaderFor("debug_abbrev", monitor);
        this.debugRanges = this.getBinaryReaderFor("debug_ranges", monitor);
        boolean bl = hasRelocations = this.hasRelocations(this.debugInfoBR) || this.hasRelocations(this.debugRanges);
        if (!hasRelocations && (oib = ElfLoader.getElfOriginalImageBase(program)) != null && oib.longValue() != program.getImageBase().getOffset()) {
            this.programBaseAddressFixup = program.getImageBase().getOffset() - oib;
        }
        this.dwarfRegisterMappings = DWARFRegisterMappingsManager.hasDWARFRegisterMapping(program.getLanguage()) ? DWARFRegisterMappingsManager.getMappingForLang(program.getLanguage()) : null;
        this.bootstrapCompilationUnits(monitor);
        this.checkPreconditions(monitor);
    }

    @Override
    public void close() throws IOException {
        this.sectionProvider = null;
        this.compUnits.clear();
        this.debugAbbrBR = null;
        this.debugInfoBR = null;
        this.debugLineBR = null;
        this.debugLocation = null;
        this.debugRanges = null;
        this.debugStrings.clear();
        this.dniCache.clear();
        this.clearDIEIndexes();
    }

    public DWARFImportOptions getImportOptions() {
        return this.importOptions;
    }

    public Program getGhidraProgram() {
        return this.program;
    }

    public boolean isBigEndian() {
        return this.program.getLanguage().isBigEndian();
    }

    public boolean isLittleEndian() {
        return !this.program.getLanguage().isBigEndian();
    }

    private BinaryReader getBinaryReaderFor(String sectionName, TaskMonitor monitor) throws IOException {
        ByteProvider bp = this.sectionProvider.getSectionAsByteProvider(sectionName, monitor);
        return bp != null ? new BinaryReader(bp, !this.isBigEndian()) : null;
    }

    private boolean hasRelocations(BinaryReader br) throws IOException {
        MemoryByteProvider mbp;
        if (br == null) {
            return false;
        }
        ByteProvider bp = br.getByteProvider();
        return bp instanceof MemoryByteProvider && !(mbp = (MemoryByteProvider)bp).isEmpty() && this.program.getRelocationTable().getRelocations(mbp.getAddressSet()).hasNext();
    }

    private static boolean isAnonDWARFName(String name) {
        return name == null || name.startsWith("._") || name.startsWith("<anonymous");
    }

    public String getEntryName(DIEAggregate diea) {
        String name = diea.getString(3, null);
        if (name == null) {
            String linkageName = diea.getString(110, null);
            if (linkageName == null) {
                linkageName = diea.getString(8199, null);
            }
            name = linkageName;
        }
        return name;
    }

    private DWARFNameInfo getDWARFNameInfo(DIEAggregate diea, DWARFNameInfo localRootDNI) {
        DIEAggregate referringTypedef;
        List<String> nestings;
        Object name;
        DWARFNameInfo parentDNI = localRootDNI;
        DIEAggregate declParent = diea.getDeclParent();
        if (declParent != null && declParent.getTag() != 17 && (parentDNI = this.lookupDNIByOffset(declParent.getOffset())) == null && (parentDNI = this.getDWARFNameInfo(declParent, localRootDNI)) != null) {
            this.cacheDNIByOffset(declParent.getOffset(), parentDNI);
        }
        if ((name = this.getEntryName(diea)) != null && ((String)name).contains("_Z") && !((String)name).startsWith("_GLOBAL_") && !(nestings = this.ensureSafeNameLengths(DWARFUtil.parseMangledNestings((String)name))).isEmpty()) {
            name = nestings.remove(nestings.size() - 1);
            if (parentDNI == localRootDNI && !nestings.isEmpty()) {
                parentDNI = DWARFNameInfo.fromList(localRootDNI, nestings);
            }
        }
        if (localRootDNI.equals(parentDNI) && !(nestings = DWARFUtil.findLinkageNameInChildren(diea.getHeadFragment())).isEmpty()) {
            nestings.remove(nestings.size() - 1);
            parentDNI = DWARFNameInfo.fromList(localRootDNI, nestings);
        }
        if (name == null && (referringTypedef = DWARFUtil.getReferringTypedef(diea)) != null) {
            return this.getDWARFNameInfo(referringTypedef, localRootDNI);
        }
        if (name == null && diea.isStructureType()) {
            String fingerprint = DWARFUtil.getStructLayoutFingerprint(diea);
            List<DIEAggregate> referringMembers = diea != null ? diea.getProgram().getTypeReferers(diea, 13) : null;
            Object referringMemberNames = this.getReferringMemberFieldNames(referringMembers);
            if (!((String)referringMemberNames).isEmpty()) {
                parentDNI = this.getName(referringMembers.get(0).getParent());
                referringMemberNames = "_for_" + (String)referringMemberNames;
            }
            name = "anon_" + DWARFUtil.getContainerTypeName(diea) + "_" + fingerprint + (String)referringMemberNames;
            return parentDNI.createChild(null, (String)name, DWARFUtil.getSymbolTypeFromDIE(diea));
        }
        boolean isAnon = false;
        if (name == null) {
            switch (diea.getTag()) {
                case 36: {
                    name = this.getAnonBaseTypeName(diea);
                    isAnon = true;
                    break;
                }
                case 4: {
                    name = this.getAnonEnumName(diea);
                    isAnon = true;
                    break;
                }
                case 21: {
                    name = "anon_subr";
                    isAnon = true;
                    break;
                }
                case 11: {
                    name = DWARFUtil.getLexicalBlockName(diea);
                    break;
                }
                case 5: {
                    name = "param_" + DWARFUtil.getMyPositionInParent(diea.getHeadFragment());
                    isAnon = true;
                    break;
                }
                case 29: 
                case 46: {
                    if (declParent != null && declParent.isStructureType() && diea.getBool(52, false)) {
                        name = parentDNI.getName();
                        break;
                    }
                    name = "anon_func";
                    isAnon = true;
                    break;
                }
                default: {
                    if (declParent == null || !declParent.isNameSpaceContainer()) break;
                    name = DWARFUtil.getAnonNameForMeFromParentContext2(diea);
                }
            }
        }
        if (DWARFProgram.isAnonDWARFName((String)name)) {
            name = DWARFProgram.createAnonName("anon_" + DWARFUtil.getContainerTypeName(diea), diea);
            isAnon = true;
        }
        String origName = isAnon ? null : name;
        String workingName = this.ensureSafeNameLength((String)name);
        DWARFNameInfo result = parentDNI.createChild(origName, workingName, DWARFUtil.getSymbolTypeFromDIE(diea));
        return result;
    }

    private String getAnonBaseTypeName(DIEAggregate diea) {
        try {
            int dwarfSize = diea.parseInt(11, 0);
            int dwarfEncoding = (int)diea.getUnsignedLong(62, -1L);
            String name = DWARFProgram.createAnonName("anon_basetype_" + DWARFEncoding.getTypeName(dwarfEncoding) + "_" + dwarfSize, diea);
            return name;
        }
        catch (DWARFExpressionException | IOException e) {
            return DWARFProgram.createAnonName("anon_basetype_unknown", diea);
        }
    }

    private String getAnonEnumName(DIEAggregate diea) {
        int enumSize = Math.max(1, (int)diea.getUnsignedLong(11, 1L));
        String name = DWARFProgram.createAnonName("anon_enum_" + enumSize * 8, diea);
        return name;
    }

    private static String createAnonName(String baseName, DIEAggregate diea) {
        return baseName + ".conflict" + diea.getHexOffset();
    }

    private String getReferringMemberFieldNames(List<DIEAggregate> referringMembers) {
        if (referringMembers == null || referringMembers.isEmpty()) {
            return "";
        }
        DIEAggregate commonParent = referringMembers.get(0).getParent();
        StringBuilder result = new StringBuilder();
        for (DIEAggregate referringMember : referringMembers) {
            if (commonParent != referringMember.getParent()) {
                return "";
            }
            Object memberName = referringMember.getName();
            if (memberName == null) {
                int positionInParent = DWARFUtil.getMyPositionInParent(referringMember.getHeadFragment());
                if (positionInParent == -1) continue;
                DWARFNameInfo parentDNI = this.getName(commonParent);
                memberName = parentDNI.getName() + "_" + Integer.toString(positionInParent);
            }
            if (result.length() > 0) {
                result.append("_");
            }
            result.append((String)memberName);
        }
        return result.toString();
    }

    private static String abbrevTemplateName(String s) {
        int endBracket;
        int startBracket = s.indexOf(60);
        if (startBracket + 12 < (endBracket = s.lastIndexOf(62))) {
            String templateParams = s.substring(startBracket, endBracket);
            return s.substring(0, startBracket + 1) + "$" + Integer.toHexString(templateParams.hashCode()) + "$" + s.substring(endBracket);
        }
        return s;
    }

    private String ensureSafeNameLength(String s) {
        if (s.length() <= this.nameLengthCutoffSize) {
            return s;
        }
        if ((s = DWARFProgram.abbrevTemplateName(s)).length() <= this.nameLengthCutoffSize) {
            return s;
        }
        int prefixKeepLength = this.nameLengthCutoffSize - ELLIPSES_STR.length() - 12;
        return s.substring(0, prefixKeepLength) + "...$" + Integer.toHexString(s.hashCode()) + "$";
    }

    private List<String> ensureSafeNameLengths(List<String> strs) {
        for (int i = 0; i < strs.size(); ++i) {
            strs.set(i, this.ensureSafeNameLength(strs.get(i)));
        }
        return strs;
    }

    public DWARFNameInfo getName(DIEAggregate diea) {
        DWARFNameInfo dni = this.lookupDNIByOffset(diea.getOffset());
        if (dni == null) {
            dni = this.getDWARFNameInfo(diea, this.unCatDataTypeRoot);
            this.cacheDNIByOffset(diea.getOffset(), dni);
        }
        return dni;
    }

    public DWARFNameInfo lookupDNIByOffset(long offset) {
        DWARFNameInfo tmp = (DWARFNameInfo)this.dniCache.get((Object)offset);
        return tmp;
    }

    public void cacheDNIByOffset(long offset, DWARFNameInfo dni) {
        this.dniCache.put((Object)offset, (Object)dni);
    }

    private void bootstrapCompilationUnits(TaskMonitor monitor) throws CancelledException, IOException, DWARFException {
        BinaryReader br = this.debugInfoBR;
        br.setPointerIndex(0);
        while (br.hasNext()) {
            monitor.checkCanceled();
            monitor.setMessage("Bootstrapping DWARF Compilation Unit #" + this.compUnits.size());
            DWARFCompilationUnit cu = DWARFCompilationUnit.readCompilationUnit(this, br, this.debugAbbrBR, this.compUnits.size(), monitor);
            if (cu == null) continue;
            this.compUnits.add(cu);
            br.setPointerIndex(cu.getEndOffset());
        }
    }

    public DIEAggregate getAggregate(DebugInfoEntry die) {
        if (die != null && !this.importOptions.isPreloadAllDIEs() && die.getCompilationUnit() != this.currentCompUnit) {
            throw new RuntimeException("Bad request for getAggregate() when compUnit is not updated");
        }
        return die != null ? this.aggregatesByOffset.get(die.getOffset()) : null;
    }

    public DIEAggregate getAggregate(long offset) {
        return this.aggregatesByOffset.get(offset);
    }

    public List<DIEAggregate> getAggregates() {
        return this.aggregates;
    }

    public int getTotalDIECount() {
        return this.totalDIECount;
    }

    public int getTotalAggregateCount() {
        return this.totalAggregateCount;
    }

    public void setCurrentCompilationUnit(DWARFCompilationUnit cu, TaskMonitor monitor) throws CancelledException, IOException, DWARFException {
        if (cu != this.currentCompUnit) {
            this.currentCompUnit = cu;
            if (cu != null && !this.importOptions.isPreloadAllDIEs()) {
                this.clearDIEIndexes();
                cu.readDIEs(this.currentDIEs, monitor);
                this.rebuildDIEIndexes();
            }
        }
    }

    public List<DWARFCompilationUnit> getCompilationUnits() {
        return this.compUnits;
    }

    public DWARFCompilationUnit getCompilationUnitFor(long offset) {
        for (DWARFCompilationUnit cu : this.getCompilationUnits()) {
            if (!cu.containsOffset(offset)) continue;
            return cu;
        }
        return null;
    }

    public BinaryReader getDebugLocation() {
        return this.debugLocation;
    }

    public BinaryReader getDebugRanges() {
        return this.debugRanges;
    }

    public BinaryReader getDebugInfo() {
        return this.debugInfoBR;
    }

    public BinaryReader getDebugLine() {
        return this.debugLineBR;
    }

    public DWARFRegisterMappings getRegisterMappings() {
        return this.dwarfRegisterMappings;
    }

    public DWARFNameInfo getRootDNI() {
        return this.rootDNI;
    }

    public DWARFNameInfo getUncategorizedRootDNI() {
        return this.unCatDataTypeRoot;
    }

    public StringTable getDebugStrings() {
        return this.debugStrings;
    }

    public DWARFAttributeFactory getAttributeFactory() {
        return this.attributeFactory;
    }

    public void setAttributeFactory(DWARFAttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    public boolean getFoundCrossCURefs() {
        return this.foundCrossCURefs;
    }

    public void setFoundCrossCURefs(boolean b) {
        this.foundCrossCURefs = b;
    }

    public DWARFAttributeSpecification internAttributeSpec(DWARFAttributeSpecification das) {
        DWARFAttributeSpecification inDAS = this.attributeSpecIntern.get(das);
        if (inDAS == null) {
            inDAS = das;
            this.attributeSpecIntern.put(inDAS, inDAS);
        }
        return inDAS;
    }

    public List<DebugInfoEntry> getEntries() {
        return this.currentDIEs;
    }

    public int getDIECount() throws IOException, CancelledException {
        return this.currentDIEs.size();
    }

    public void clearDIEIndexes() {
        this.offsetMap.clear();
        this.currentDIEs.clear();
        this.aggregatesByOffset.clear();
        this.aggregates.clear();
        this.typeReferers.clear();
    }

    public DebugInfoEntry getEntryAtByteOffsetUnchecked(long byteOffset) {
        return this.offsetMap.get(byteOffset);
    }

    private List<DIEAggregate> getTypeReferers(DIEAggregate targetDIEA) {
        List<DIEAggregate> result = this.typeReferers.get((Object)targetDIEA.getOffset());
        return result != null ? result : Collections.emptyList();
    }

    public List<DIEAggregate> getTypeReferers(DIEAggregate targetDIEA, int tag) {
        ArrayList<DIEAggregate> result = new ArrayList<DIEAggregate>();
        for (DIEAggregate referer : this.getTypeReferers(targetDIEA)) {
            if (referer.getTag() != tag) continue;
            result.add(referer);
        }
        return result;
    }

    private void rebuildDIEIndexes() {
        this.buildDIEIndex();
        this.buildAggregateIndex();
        this.buildTypeRefIndex();
    }

    private void buildDIEIndex() {
        for (DebugInfoEntry die : this.currentDIEs) {
            this.offsetMap.put(die.getOffset(), die);
        }
    }

    private boolean checkForCrossCURefs(List<DebugInfoEntry> dies) {
        int[] refAttrs = new int[]{73, 49, 71};
        for (DebugInfoEntry die : dies) {
            DIEAggregate diea = DIEAggregate.createSingle(die);
            for (int attr : refAttrs) {
                long refdOffset = diea.getUnsignedLong(attr, -1L);
                if (refdOffset == -1L || die.getCompilationUnit().containsOffset(refdOffset)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAggregateIndex() {
        Map<Long, DebugInfoEntry> offsetMap2Head = this.buildHeadIndex();
        for (DebugInfoEntry die : this.currentDIEs) {
            if (this.aggregatesByOffset.containsKey(die.getOffset())) continue;
            DebugInfoEntry head = this.getHead(die, offsetMap2Head);
            DIEAggregate diea = DIEAggregate.createFromHead(head);
            this.aggregates.add(diea);
            for (long fragOffset : diea.getOffsets()) {
                this.aggregatesByOffset.put(fragOffset, diea);
            }
        }
    }

    private int countAggregates() {
        Map<Long, DebugInfoEntry> offsetMap2Head = this.buildHeadIndex();
        HashSet<Long> uniqueHeads = new HashSet<Long>();
        for (DebugInfoEntry die : this.currentDIEs) {
            DebugInfoEntry head = this.getHead(die, offsetMap2Head);
            uniqueHeads.add(head.getOffset());
        }
        return uniqueHeads.size();
    }

    private void buildTypeRefIndex() {
        for (DIEAggregate diea : this.aggregates) {
            DIEAggregate typeRef = diea.getTypeRef();
            if (typeRef == null) continue;
            this.typeReferers.put((Object)typeRef.getOffset(), (Object)diea);
        }
    }

    private Map<Long, DebugInfoEntry> buildHeadIndex() {
        HashMap<Long, DebugInfoEntry> offsetMap2Head = new HashMap<Long, DebugInfoEntry>();
        for (DebugInfoEntry die : this.currentDIEs) {
            int[] refAttrs;
            offsetMap2Head.put(die.getOffset(), die);
            DIEAggregate diea = DIEAggregate.createSingle(die);
            for (int attr : refAttrs = new int[]{49, 71}) {
                long refdOffset = diea.getUnsignedLong(attr, -1L);
                if (refdOffset == -1L) continue;
                offsetMap2Head.put(refdOffset, die);
            }
        }
        return offsetMap2Head;
    }

    private DebugInfoEntry getHead(DebugInfoEntry die, Map<Long, DebugInfoEntry> offsetMap2Head) {
        DebugInfoEntry tmp;
        while ((tmp = offsetMap2Head.get(die.getOffset())) != die) {
            die = tmp;
        }
        return die;
    }

    public void checkPreconditions(TaskMonitor monitor) throws DWARFPreconditionException, DWARFException, CancelledException, IOException {
        monitor.setIndeterminate(false);
        monitor.setShowProgressValue(true);
        monitor.setMaximum((long)this.getCompilationUnits().size());
        if (this.getCompilationUnits().size() > 0 && this.getCompilationUnits().get(0).getCompileUnit().hasDWO()) {
            Msg.warn((Object)this, (Object)"Unsupported DWARF DWO (external debug file) detected -- unlikely any debug information will be found");
        }
        boolean preLoad = this.importOptions.isPreloadAllDIEs();
        this.totalDIECount = 0;
        this.totalAggregateCount = 0;
        this.clearDIEIndexes();
        for (DWARFCompilationUnit cu : this.getCompilationUnits()) {
            monitor.setMessage("DWARF Checking Preconditions - Compilation Unit #" + cu.getCompUnitNumber() + "/" + this.getCompilationUnits().size());
            monitor.setProgress((long)cu.getCompUnitNumber());
            cu.readDIEs(this.currentDIEs, monitor);
            if (this.totalDIECount > this.importOptions.getImportLimitDIECount() && !preLoad) {
                throw new DWARFPreconditionException(String.format(this.program.getName() + " has more DIE records (%d) than limit of %d", this.totalDIECount, this.importOptions.getImportLimitDIECount()));
            }
            if (preLoad) continue;
            this.foundCrossCURefs |= this.checkForCrossCURefs(this.currentDIEs);
            this.totalDIECount += this.currentDIEs.size();
            this.totalAggregateCount += this.countAggregates();
            this.currentDIEs.clear();
            if (!this.foundCrossCURefs) continue;
            throw new DWARFPreconditionException("Found cross-compilation unit references between DIE records, but 'preload' is not turned on");
        }
        if (preLoad) {
            this.rebuildDIEIndexes();
            this.totalAggregateCount = this.aggregates.size();
            this.totalDIECount = this.currentDIEs.size();
        }
    }

    public void setNameLengthCutoff(int nameLenCutoff) {
        this.nameLengthCutoffSize = nameLenCutoff;
    }

    public long getProgramBaseAddressFixup() {
        return this.programBaseAddressFixup;
    }
}

