/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFAttributeSpecification;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFChildren;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFTag;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DWARFAbbreviation {
    private final int abbreviationCode;
    private final int tag;
    private final boolean hasChildren;
    private final DWARFAttributeSpecification[] attributes;

    public static DWARFAbbreviation read(BinaryReader reader, DWARFProgram prog, TaskMonitor monitor) throws IOException, CancelledException {
        DWARFAttributeSpecification attr;
        int ac = LEB128.readAsUInt32(reader);
        if (ac == 0) {
            return null;
        }
        int tag = LEB128.readAsUInt32(reader);
        DWARFChildren hasChildren = DWARFChildren.find(reader.readNextByte());
        ArrayList<DWARFAttributeSpecification> tmpAttrSpecs = new ArrayList<DWARFAttributeSpecification>();
        while ((attr = DWARFAttributeSpecification.read(reader)) != null) {
            monitor.checkCanceled();
            tmpAttrSpecs.add(prog.internAttributeSpec(attr));
        }
        DWARFAttributeSpecification[] attrSpecArray = tmpAttrSpecs.toArray(new DWARFAttributeSpecification[tmpAttrSpecs.size()]);
        DWARFAbbreviation result = new DWARFAbbreviation(ac, tag, hasChildren == DWARFChildren.DW_CHILDREN_yes, attrSpecArray);
        return result;
    }

    public static Map<Integer, DWARFAbbreviation> readAbbreviations(BinaryReader reader, DWARFProgram prog, TaskMonitor monitor) throws IOException, CancelledException {
        HashMap<Integer, DWARFAbbreviation> result = new HashMap<Integer, DWARFAbbreviation>();
        DWARFAbbreviation abbrev = null;
        while ((abbrev = DWARFAbbreviation.read(reader, prog, monitor)) != null) {
            monitor.checkCanceled();
            result.put(abbrev.getAbbreviationCode(), abbrev);
        }
        return result;
    }

    public DWARFAbbreviation(int abbreviationCode, int tag, boolean hasChildren, DWARFAttributeSpecification[] attributes) {
        this.abbreviationCode = abbreviationCode;
        this.tag = tag;
        this.hasChildren = hasChildren;
        this.attributes = attributes;
    }

    public String toString() {
        return Integer.toHexString(this.getAbbreviationCode()) + ":" + DWARFUtil.toString(DWARFTag.class, this.getTag());
    }

    public int getAbbreviationCode() {
        return this.abbreviationCode;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public DWARFAttributeSpecification[] getAttributes() {
        return this.attributes;
    }

    public int getAttributeCount() {
        return this.attributes.length;
    }

    public DWARFAttributeSpecification getAttributeAt(int index) {
        return this.attributes[index];
    }

    public DWARFAttributeSpecification findAttribute(int attribute) {
        for (DWARFAttributeSpecification spec : this.attributes) {
            if (spec.getAttribute() != attribute) continue;
            return spec;
        }
        return null;
    }
}

