/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.action.builder.ToggleActionBuilder;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.FunctionXrefsTableModel;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.ReferenceEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import resources.ResourceManager;

public class XReferenceUtils {
    private static final String X_REFS_TO = "XRefs to ";
    private static final int ALL_REFS = -1;

    public static final List<Reference> getXReferences(CodeUnit cu, int max) {
        Address[] thunkAddrs;
        Program program = cu.getProgram();
        if (program == null) {
            Collections.emptyList();
        }
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        Address minAddress = cu.getMinAddress();
        ReferenceIterator it = program.getReferenceManager().getReferencesTo(minAddress);
        while (it.hasNext() && xrefs.size() - max != 0) {
            Reference ref = it.next();
            xrefs.add(ref);
        }
        Function func = program.getFunctionManager().getFunctionAt(minAddress);
        if (func != null && (thunkAddrs = func.getFunctionThunkAddresses()) != null) {
            for (Address thunkAddr : thunkAddrs) {
                xrefs.add((Reference)new ThunkReference(thunkAddr, func.getEntryPoint()));
            }
        }
        return xrefs;
    }

    public static List<Reference> getOffcutXReferences(CodeUnit cu, int max) {
        Program program = cu.getProgram();
        if (program == null) {
            return Collections.emptyList();
        }
        if (cu.getLength() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        ReferenceManager refMgr = program.getReferenceManager();
        AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
        AddressIterator it = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
        while (it.hasNext()) {
            Address addr = it.next();
            ReferenceIterator refIter = refMgr.getReferencesTo(addr);
            while (refIter.hasNext() && offcuts.size() - max != 0) {
                Reference ref = refIter.next();
                offcuts.add(ref);
            }
        }
        return offcuts;
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts) {
        XReferenceUtils.getVariableRefs(var, xrefs, offcuts, -1);
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts, int max) {
        Address addr = var.getMinAddress();
        if (addr == null) {
            return;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference[] refs = refMgr.getReferencesTo(var);
        int total = 0;
        for (Reference vref : refs) {
            if (total++ - max == 0) break;
            if (addr.equals((Object)vref.getToAddress())) {
                xrefs.add(vref);
                continue;
            }
            offcuts.add(vref);
        }
    }

    public static Set<Reference> getAllXrefs(ProgramLocation location) {
        Data cu = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (cu == null) {
            Address toAddress = location.getAddress();
            Listing listing = location.getProgram().getListing();
            cu = listing.getCodeUnitContaining(toAddress);
        }
        if (cu == null) {
            return Collections.emptySet();
        }
        List<Reference> xrefs = XReferenceUtils.getXReferences((CodeUnit)cu, -1);
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences((CodeUnit)cu, -1);
        HashSet<Reference> set = new HashSet<Reference>();
        set.addAll(xrefs);
        set.addAll(offcuts);
        return set;
    }

    public static void showXrefs(Navigatable navigatable, ServiceProvider serviceProvider, TableService service, ProgramLocation location, Collection<Reference> xrefs) {
        Address address = location.getAddress();
        Program program = location.getProgram();
        FunctionManager fm = program.getFunctionManager();
        Function function = fm.getFunctionAt(address);
        ReferencesFromTableModel model = function == null ? new ReferencesFromTableModel(xrefs, serviceProvider, program) : new FunctionXrefsTableModel(function, xrefs, serviceProvider, program);
        String title = XReferenceUtils.generateXRefTitle(location);
        TableComponentProvider<ReferenceEndpoint> provider = service.showTable(title, "Xrefs", model, "Xrefs", navigatable);
        provider.installRemoveItemsAction();
        if (function != null) {
            String actionName = "Show Thunk Xrefs";
            ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(actionName, provider.getActionOwner()).toolBarIcon((Icon)ResourceManager.loadImage((String)"images/ThunkFunction.gif"))).toolBarGroup("A")).helpLocation(new HelpLocation("CodeBrowserPlugin", actionName))).selected(false).onAction(c -> ((FunctionXrefsTableModel)model).toggleShowAllThunkXRefs())).buildAndInstallLocal(provider);
            return;
        }
    }

    private static String generateXRefTitle(ProgramLocation location) {
        Program program = location.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        Address address = location.getAddress();
        if (location instanceof VariableLocation) {
            VariableLocation vl = (VariableLocation)location;
            String name = vl.getVariable().getName();
            Function f = functionManager.getFunctionContaining(vl.getFunctionAddress());
            return X_REFS_TO + name + (String)(f == null ? "" : " in " + f.getName());
        }
        if (location instanceof FunctionLocation) {
            FunctionLocation fl = (FunctionLocation)location;
            Function f = functionManager.getFunctionContaining(fl.getFunctionAddress());
            if (f != null) {
                return X_REFS_TO + f.getName();
            }
        } else {
            Function f = functionManager.getFunctionAt(address);
            if (f != null) {
                return X_REFS_TO + f.getName();
            }
        }
        return X_REFS_TO + location.getAddress();
    }
}

