/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.util.HTMLUtilities;
import java.awt.Color;

public class ColorAndStyle {
    private Color color;
    private int style;

    ColorAndStyle(Color color, int style) {
        this.color = color;
        this.style = style;
    }

    public Color getColor() {
        return this.color;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public String toHtml(String text) {
        String html = text;
        if (this.isBold()) {
            html = HTMLUtilities.bold((String)html);
        }
        if (this.isItalic()) {
            html = HTMLUtilities.italic((String)html);
        }
        if (this.color != null) {
            html = HTMLUtilities.colorString((Color)this.color, (String)html);
        }
        return html;
    }
}

