/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.app.util.SelectionTransferData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import java.awt.datatransfer.DataFlavor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class NamespaceSymbolNode
extends SymbolNode {
    static final DataFlavor LOCAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Local Namespaces");
    static final DataFlavor GLOBAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Global Namespaces");
    public static final Icon NAMESPACE_ICON = ResourceManager.loadImage((String)"images/Namespace.gif");
    public static final Icon DISABLED_NAMESPACE_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)NAMESPACE_ICON));

    NamespaceSymbolNode(Program program, Symbol symbol) {
        super(program, symbol);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.isCut()) {
            return DISABLED_NAMESPACE_ICON;
        }
        return NAMESPACE_ICON;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return this.symbol.isGlobal() ? GLOBAL_DATA_FLAVOR : LOCAL_DATA_FLAVOR;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (flavor instanceof SymbolTreeDataFlavor) {
                return true;
            }
            if (!this.isProgramSelection(flavor)) continue;
            return true;
        }
        return false;
    }

    private boolean isProgramSelection(DataFlavor flavor) {
        Class<?> clazz = flavor.getRepresentationClass();
        return SelectionTransferData.class.equals(clazz);
    }

    @Override
    public Namespace getNamespace() {
        return (Namespace)this.symbol.getObject();
    }

    @Override
    public boolean canCut() {
        return true;
    }
}

