/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class ClassCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_CLASSES_ICON = ResourceManager.loadImage((String)"images/openFolderClasses.png");
    public static final Icon CLOSED_FOLDER_CLASSES_ICON = ResourceManager.loadImage((String)"images/closedFolderClasses.png");

    ClassCategoryNode(Program program) {
        super(SymbolCategory.CLASS_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_CLASSES_ICON : CLOSED_FOLDER_CLASSES_ICON;
    }

    @Override
    public String getToolTip() {
        return "Symbols for Classes";
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public SymbolNode symbolAdded(Symbol symbol) {
        if (!this.isLoaded()) {
            return null;
        }
        if (!this.supportsSymbol(symbol)) {
            return null;
        }
        if (symbol.getSymbolType() == this.symbolCategory.getSymbolType()) {
            return this.doAddSymbol(symbol, (GTreeNode)this);
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        Symbol namespaceSymbol = parentNamespace.getSymbol();
        SymbolNode key = SymbolNode.createNode(namespaceSymbol, this.program);
        GTreeNode parentNode = this.findSymbolTreeNode(key, false, TaskMonitor.DUMMY);
        if (parentNode == null) {
            return null;
        }
        return this.doAddSymbol(symbol, parentNode);
    }

    @Override
    protected List<GTreeNode> getSymbols(SymbolType type, TaskMonitor monitor) throws CancelledException {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        monitor.initialize((long)this.symbolTable.getNumSymbols());
        SymbolType symbolType = this.symbolCategory.getSymbolType();
        SymbolIterator it = this.symbolTable.getDefinedSymbols();
        while (it.hasNext()) {
            Symbol s = it.next();
            if (s != null && s.getSymbolType() == symbolType) {
                monitor.checkCanceled();
                list.add((GTreeNode)SymbolNode.createNode(s, this.program));
            }
            monitor.incrementProgress(1L);
        }
        Collections.sort(list, this.getChildrenComparator());
        return list;
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == this.symbolCategory.getSymbolType()) {
            return true;
        }
        for (Namespace parentNamespace = symbol.getParentNamespace(); parentNamespace != null && parentNamespace != this.globalNamespace; parentNamespace = parentNamespace.getParentNamespace()) {
            if (!(parentNamespace instanceof GhidraClass)) continue;
            return true;
        }
        return false;
    }
}

