/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.util.string.FoundString;

public class FoundStringWithWordStatus
extends FoundString {
    private volatile boolean isHighConfidenceWord;

    public FoundStringWithWordStatus(FoundString source) {
        this(source.getAddress(), source.getLength(), source.getDataType(), source.getDefinedState());
    }

    public FoundStringWithWordStatus(Address address, int length, DataType stringDataType) {
        super(address, length, stringDataType);
        this.isHighConfidenceWord = false;
    }

    public FoundStringWithWordStatus(Address address, int length, DataType stringDataType, FoundString.DefinedState definedState) {
        super(address, length, stringDataType, definedState);
        this.isHighConfidenceWord = false;
    }

    public FoundStringWithWordStatus(Address address, int length, DataType stringDataType, boolean isWord) {
        super(address, length, stringDataType);
        this.isHighConfidenceWord = isWord;
    }

    public FoundStringWithWordStatus(Address address, int length, DataType stringDataType, FoundString.DefinedState definedState, boolean isWord) {
        super(address, length, stringDataType, definedState);
        this.isHighConfidenceWord = isWord;
    }

    public boolean isHighConfidenceWord() {
        return this.isHighConfidenceWord;
    }

    public void setIsHighConfidenceWord(boolean isWord) {
        this.isHighConfidenceWord = isWord;
    }

    @Override
    public String toString() {
        return super.toString() + ", high confidence=" + this.isHighConfidenceWord;
    }
}

