/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.NumericUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.Iterator;

class RelocationTableModel
extends AddressBasedTableModel<RelocationRowObject> {
    private static Comparator<RelocationRowObject> ADDRESS_SORT_COMPARATOR = new Comparator<RelocationRowObject>(){

        @Override
        public int compare(RelocationRowObject o1, RelocationRowObject o2) {
            int c = o1.relocation.getAddress().compareTo((Object)o2.relocation.getAddress());
            if (c == 0) {
                c = o1.relocationIndex - o2.relocationIndex;
            }
            return c;
        }
    };
    static final int ADDRESS_COL = 0;
    static final int TYPE_COL = 1;
    static final int VALUE_COL = 2;
    static final int BYTES_COL = 3;
    static final int NAME_COL = 4;
    static final String RELOCATION_ADDRESS = "Address";
    static final String RELOCATION_TYPE = "Type";
    static final String RELOCATION_VALUE = "Values";
    static final String RELOCATION_BYTES = "Original Bytes";
    static final String RELOCATION_NAME = "Name";

    public RelocationTableModel(ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        super("Relocation Table Model", serviceProvider, program, monitor);
    }

    @Override
    protected TableColumnDescriptor<RelocationRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationTypeColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationValueColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationBytesColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new RelocationNameColumn());
        return descriptor;
    }

    protected Comparator<RelocationRowObject> createSortComparator(int columnIndex) {
        if (columnIndex == 0) {
            return ADDRESS_SORT_COMPARATOR;
        }
        return super.createSortComparator(columnIndex);
    }

    @Override
    public void setProgram(Program p) {
        super.setProgram(p);
        this.reload();
        this.fireTableDataChanged();
    }

    protected void doLoad(Accumulator<RelocationRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.getProgram() == null) {
            return;
        }
        int relocationIndex = 0;
        RelocationTable relocationTable = this.getProgram().getRelocationTable();
        Iterator iterator = relocationTable.getRelocations();
        while (iterator.hasNext()) {
            Relocation r = (Relocation)iterator.next();
            accumulator.add((Object)new RelocationRowObject(r, ++relocationIndex));
        }
    }

    @Override
    public Address getAddress(int row) {
        RelocationRowObject rowObject = (RelocationRowObject)this.filteredData.get(row);
        return rowObject.relocation.getAddress();
    }

    private static class RelocationTypeColumn
    extends AbstractProgramBasedDynamicTableColumn<RelocationRowObject, String> {
        private RelocationTypeColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_TYPE;
        }

        public String getValue(RelocationRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return "0x" + Integer.toHexString(rowObject.relocation.getType());
        }
    }

    private static class RelocationValueColumn
    extends AbstractProgramBasedDynamicTableColumn<RelocationRowObject, String> {
        private RelocationValueColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_VALUE;
        }

        public String getValue(RelocationRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.packValues(rowObject.relocation.getValues());
        }

        private String packValues(long[] values) {
            if (values == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (long v : values) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(NumericUtilities.toHexString((long)v));
            }
            return buf.toString();
        }
    }

    private static class RelocationBytesColumn
    extends AbstractProgramBasedDynamicTableColumn<RelocationRowObject, String> {
        private RelocationBytesColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_BYTES;
        }

        public String getValue(RelocationRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.packBytes(rowObject.relocation.getBytes());
        }

        private String packBytes(byte[] bytes) {
            if (bytes == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            byte[] byArray = bytes;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                String byteStr;
                long b = byArray[i];
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                if ((byteStr = Long.toHexString(b & 0xFFL)).length() == 1) {
                    buf.append('0');
                }
                buf.append(byteStr);
            }
            return buf.toString();
        }
    }

    private static class RelocationNameColumn
    extends AbstractProgramBasedDynamicTableColumn<RelocationRowObject, String> {
        private RelocationNameColumn() {
        }

        public String getColumnName() {
            return RelocationTableModel.RELOCATION_NAME;
        }

        public String getValue(RelocationRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.relocation.getSymbolName();
        }
    }

    static class RelocationRowObject {
        final int relocationIndex;
        final Relocation relocation;

        public RelocationRowObject(Relocation r, int relocationIndex) {
            this.relocationIndex = relocationIndex;
            this.relocation = r;
        }
    }
}

