/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public abstract class AbstractUndoRedoAction
extends DockingAction {
    private PluginTool tool;
    private Program lastProgram;
    private ProgramManagerPlugin plugin;
    private TransactionListener transactionListener;

    public AbstractUndoRedoAction(PluginTool tool, ProgramManagerPlugin plugin, String name, String iconPath, String keyBinding, String subGroup) {
        super(name, plugin.getName());
        this.tool = tool;
        this.plugin = plugin;
        String[] menuPath = new String[]{"&Edit", "&" + name};
        ImageIcon icon = ResourceManager.loadImage((String)iconPath);
        String group = "Undo";
        MenuData menuData = new MenuData(menuPath, (Icon)icon, group);
        menuData.setMenuSubGroup(subGroup);
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setKeyBindingData(new KeyBindingData(keyBinding));
        this.setHelpLocation(new HelpLocation("Tool", name));
        this.setDescription(name);
        this.addToWindowWhen(ProgramActionContext.class);
        this.transactionListener = new ContextProgramTransactionListener();
    }

    protected abstract void actionPerformed(Program var1) throws IOException;

    protected abstract boolean canPerformAction(Program var1);

    protected abstract String getUndoRedoDescription(Program var1);

    public boolean isEnabledForContext(ActionContext context) {
        Program program = this.getProgram(context);
        if (program != this.lastProgram) {
            this.removeTransactionListener(this.lastProgram);
            this.lastProgram = program;
            this.addTransactionListener(this.lastProgram);
            this.updateActionNameAndDescription();
        }
        return this.canPerformAction(this.lastProgram);
    }

    public void actionPerformed(ActionContext context) {
        Program program = this.getProgram(context);
        if (program == null) {
            return;
        }
        this.saveCurrentLocationToHistory();
        try {
            this.actionPerformed(program);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
    }

    private Program getProgram(ActionContext context) {
        if (context instanceof ProgramActionContext) {
            return ((ProgramActionContext)context).getProgram();
        }
        return this.plugin.getCurrentProgram();
    }

    private void removeTransactionListener(Program program) {
        if (program != null) {
            program.removeTransactionListener(this.transactionListener);
        }
    }

    private void addTransactionListener(Program program) {
        if (program != null) {
            program.addTransactionListener(this.transactionListener);
        }
    }

    private void updateAction() {
        this.updateActionNameAndDescription();
        this.setEnabled(this.canPerformAction(this.lastProgram));
    }

    private void updateActionNameAndDescription() {
        Object actionName;
        Object description = actionName = this.getName();
        if (this.lastProgram != null) {
            description = actionName = (String)actionName + " " + this.lastProgram.getDomainFile().getName();
        }
        if (this.canPerformAction(this.lastProgram)) {
            description = HTMLUtilities.toWrappedHTML((String)(this.getName() + " " + HTMLUtilities.escapeHTML((String)this.getUndoRedoDescription(this.lastProgram))));
        }
        this.getMenuBarData().setMenuItemNamePlain((String)actionName);
        this.setDescription((String)description);
    }

    private void saveCurrentLocationToHistory() {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (goToService != null && historyService != null) {
            historyService.addNewLocation(goToService.getDefaultNavigatable());
        }
    }

    private class ContextProgramTransactionListener
    implements TransactionListener {
        private ContextProgramTransactionListener() {
        }

        public void transactionStarted(DomainObjectAdapterDB domainObj, Transaction tx) {
        }

        public void transactionEnded(DomainObjectAdapterDB domainObj) {
        }

        public void undoStackChanged(DomainObjectAdapterDB domainObj) {
            AbstractUndoRedoAction.this.updateAction();
        }

        public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
        }
    }
}

