/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.tags.FunctionTagPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class EditFunctionTagsAction
extends ListingContextAction {
    private FunctionTagPlugin plugin;
    private final String MENU_LABEL = "Edit Tags...";

    public EditFunctionTagsAction(String name, FunctionTagPlugin plugin) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Edit Tags..."}, null, "TagFunction"));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Functions"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Address functionAddress = this.getFunctionAddress(context.getLocation());
        if (functionAddress == null) {
            return;
        }
        this.showProvider(context);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        if (context.getLocation().getAddress().isExternalAddress()) {
            return false;
        }
        Address funcAddress = this.getFunctionAddress(context.getLocation());
        if (funcAddress == null) {
            return false;
        }
        return !funcAddress.isExternalAddress();
    }

    private Address getFunctionAddress(ProgramLocation loc) {
        if (loc instanceof FunctionLocation) {
            FunctionLocation functionLocation = (FunctionLocation)loc;
            Address functionAddress = functionLocation.getFunctionAddress();
            return functionAddress;
        }
        return null;
    }

    private void showProvider(ListingActionContext context) {
        this.plugin.getProvider().setVisible(true);
    }
}

