/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.plugin.core.disassembler.AutoTableDisassemblerPlugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.AddressTableDataTableColumn;
import ghidra.util.table.field.AddressTableLengthTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

class AutoTableDisassemblerModel
extends AddressBasedTableModel<AddressTable> {
    static final String MODEL_NAME = "Auto-table Disassembler";
    private AddressSetView addresses;
    private int minimumTableSize;
    private int alignment;
    private int skipAmount;
    private boolean shiftedAddresses;
    private AddressTableStorage storage = new NullStorage();
    private AutoTableDisassemblerPlugin plugin;

    AutoTableDisassemblerModel(ServiceProvider sp, AutoTableDisassemblerPlugin plugin) {
        super(MODEL_NAME, sp, null, TaskMonitor.DUMMY, true);
        this.plugin = plugin;
    }

    @Override
    protected TableColumnDescriptor<AddressTable> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableDataTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableLengthTableColumn());
        return descriptor;
    }

    public void dispose() {
        super.dispose();
        this.storage = new NullStorage();
    }

    boolean containsKey(Address addr) {
        return this.storage.contains(addr);
    }

    AddressTable get(Address addr) {
        return this.storage.get(addr);
    }

    private AddressTable get(Address addr, TaskMonitor monitor) {
        return AddressTable.getEntry(this.getProgram(), addr, monitor, false, this.minimumTableSize, this.alignment, this.skipAmount, 0L, this.shiftedAddresses, true, false);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int selectedRow : rows) {
            Address selectedAddress = this.getAddress(selectedRow);
            AddressTable addrTab = this.get(selectedAddress);
            if (addrTab == null) continue;
            set.addRange(selectedAddress, selectedAddress.add((long)(addrTab.getByteLength() - 1)));
        }
        return new ProgramSelection((AddressSetView)set);
    }

    protected void doLoad(Accumulator<AddressTable> accumulator, TaskMonitor monitor) throws CancelledException {
        this.loadSettings();
        monitor.initialize(this.addresses.getNumAddresses());
        monitor.setMessage("Finding Tables...");
        int addrCount = 0;
        AddressIterator addrIter = this.addresses.getAddresses(true);
        this.storage = new MapStorage();
        while (addrIter.hasNext()) {
            monitor.checkCanceled();
            monitor.setProgress((long)(++addrCount));
            Address start = addrIter.next();
            AddressTable tableEntry = this.get(start, monitor);
            if (tableEntry == null) continue;
            this.storage.put(start, tableEntry);
            accumulator.add((Object)tableEntry);
            int tableByteLen = tableEntry.getByteLength();
            addrCount += tableByteLen;
            start = start.add((long)tableByteLen);
            addrIter = this.addresses.getAddresses(start, true);
        }
    }

    private void loadSettings() {
        this.setProgram(this.plugin.getProgram());
        this.addresses = this.plugin.getSelection();
        this.minimumTableSize = this.plugin.getMinimumTableSize();
        this.alignment = this.plugin.getAlignment();
        this.skipAmount = this.plugin.getSkipLength();
        this.shiftedAddresses = this.plugin.isShiftAddresses();
    }

    @Override
    public Address getAddress(int row) {
        return ((AddressTable)this.getRowObject(row)).getTopAddress();
    }

    public int getTableLength(int row) {
        AddressTable table = (AddressTable)this.getRowObject(row);
        if (table == null) {
            return 0;
        }
        return table.getNumberAddressEntries();
    }

    private class NullStorage
    implements AddressTableStorage {
        private NullStorage() {
        }

        @Override
        public void put(Address address, AddressTable table) {
        }

        @Override
        public AddressTable get(Address address) {
            return null;
        }

        @Override
        public boolean contains(Address address) {
            return false;
        }
    }

    private static interface AddressTableStorage {
        public void put(Address var1, AddressTable var2);

        public AddressTable get(Address var1);

        public boolean contains(Address var1);
    }

    private class MapStorage
    implements AddressTableStorage {
        private Map<Address, AddressTable> map = new HashMap<Address, AddressTable>();

        private MapStorage() {
        }

        @Override
        public void put(Address address, AddressTable table) {
            this.map.put(address, table);
        }

        @Override
        public AddressTable get(Address address) {
            return this.map.get(address);
        }

        @Override
        public boolean contains(Address address) {
            return this.map.containsKey(address);
        }
    }
}

