/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.context.ProgramLocationContextAction;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;

public class ToggleExpandCollapseDataAction
extends ProgramLocationContextAction {
    private CodeViewerProvider provider;

    public ToggleExpandCollapseDataAction(CodeViewerProvider provider) {
        super("Toggle Expand/Collapse Data", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Toggle Expand/Collapse Data"}, null, "Structure"));
        this.setKeyBindingData(new KeyBindingData(' ', 0));
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "ExpandCollapseActions"));
        this.setDescription("Opens or closes the component data for this location or if on a non-component data in another data component, then closes the parent component.");
        this.setEnabled(true);
    }

    @Override
    protected boolean isEnabledForContext(ProgramLocationActionContext context) {
        Data data = this.getClosestComponentDataUnit(context.getLocation());
        return data != null;
    }

    @Override
    protected void actionPerformed(ProgramLocationActionContext context) {
        ListingPanel listingPanel = this.provider.getListingPanel();
        ListingModel layoutModel = listingPanel.getListingModel();
        ProgramLocation location = context.getLocation();
        Data data = this.getClosestComponentDataUnit(location);
        new TaskLauncher((Task)new OpenCloseDataTask(data, layoutModel), (Component)listingPanel);
    }

    private Data getClosestComponentDataUnit(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Data data = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (data == null) {
            return null;
        }
        if (data.getNumComponents() > 0) {
            return data;
        }
        return data.getParent();
    }

    private static class OpenCloseDataTask
    extends Task {
        private ListingModel model;
        private Data data;

        public OpenCloseDataTask(Data data, ListingModel model) {
            super("Open/Close Data In Selection", true, true, true, true);
            this.data = data;
            this.model = model;
        }

        public void run(TaskMonitor monitor) {
            if (!this.model.isOpen(this.data)) {
                this.model.openData(this.data);
            } else {
                this.model.closeData(this.data);
            }
        }
    }
}

