/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.listing.InternalTraceBaseDefinedUnitsView;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceDefinedDataView;
import ghidra.trace.util.TraceRegisterUtils;

public interface InternalTraceDefinedDataView
extends TraceDefinedDataView,
InternalTraceBaseDefinedUnitsView<TraceData> {
    @Override
    default public TraceData create(TracePlatform platform, Range<Long> lifespan, Register register, DataType dataType) throws CodeUnitInsertionException {
        TraceRegisterUtils.requireByteBound(register);
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        return this.create(lifespan, range.getMinAddress(), dataType, (int)range.getLength());
    }
}

