/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.listing.AbstractBaseDBTraceDefinedUnitsView;
import ghidra.trace.database.listing.AbstractComposedDBTraceCodeUnitsView;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.InternalTraceBaseDefinedUnitsView;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceDefinedUnitsView;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class DBTraceDefinedUnitsView
extends AbstractComposedDBTraceCodeUnitsView<AbstractDBTraceCodeUnit<?>, AbstractBaseDBTraceDefinedUnitsView<? extends AbstractDBTraceCodeUnit<?>>>
implements TraceDefinedUnitsView,
InternalTraceBaseDefinedUnitsView<TraceCodeUnit> {
    public DBTraceDefinedUnitsView(DBTraceCodeSpace space) {
        super(space, List.of(space.instructions, space.definedData));
    }

    @Override
    public boolean coversRange(Range<Long> span, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            HashSet<TraceAddressSnapRange> set1 = new HashSet<TraceAddressSnapRange>();
            HashSet<TraceAddressSnapRange> set2 = new HashSet<TraceAddressSnapRange>();
            Set<TraceAddressSnapRange> cur = set1;
            cur.add(new ImmutableTraceAddressSnapRange(range, span));
            for (AbstractBaseDBTraceDefinedUnitsView p : this.parts) {
                cur = p.subtractFrom(span, range, cur, set1, set2);
            }
            boolean bl = cur.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean intersectsRange(Range<Long> span, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            for (AbstractBaseDBTraceDefinedUnitsView p : this.parts) {
                if (!p.intersectsRange(span, range)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void clear(Range<Long> span, AddressRange range, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        for (AbstractBaseDBTraceDefinedUnitsView view : this.parts) {
            view.clear(span, range, clearContext, monitor);
        }
    }
}

