/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.AbstractErrDialog;
import docking.DockingUtils;
import docking.ErrLogDialog;
import docking.TransferActionListener;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.MultipleCauses;
import ghidra.util.html.HTMLElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;
import resources.ResourceManager;
import util.CollectionUtils;

public class ErrLogExpandableDialog
extends AbstractErrDialog {
    public static ImageIcon IMG_REPORT = ResourceManager.loadImage((String)"images/report.png");
    public static ImageIcon IMG_EXCEPTION = ResourceManager.loadImage((String)"images/exception.png");
    public static ImageIcon IMG_FRAME_ELEMENT = ResourceManager.loadImage((String)"images/StackFrameElement.png");
    public static ImageIcon IMG_STACK = ResourceManager.loadImage((String)"images/StackFrame_Red.png");
    public static ImageIcon IMG_CAUSE = ResourceManager.loadImage((String)"images/cause.png");
    private static final String SEND = "Send Report...";
    private static final String DETAIL = "Details >>>";
    private static final String CLOSE = "<<< Details";
    private static boolean showingDetails = false;
    protected ReportRootNode root;
    protected GTree tree;
    private List<Throwable> errors = new ArrayList<Throwable>();
    private String baseTitle;
    protected Component horizontalSpacer;
    protected JButton detailButton;
    protected JButton sendButton;
    protected JPopupMenu popup;

    protected ErrLogExpandableDialog(String title, String msg, Throwable throwable) {
        super(title);
        this.baseTitle = title;
        this.errors.add(throwable);
        this.popup = new JPopupMenu();
        JMenuItem menuCopy = new JMenuItem("Copy");
        menuCopy.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        menuCopy.addActionListener(new TransferActionListener());
        menuCopy.setAccelerator(KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.popup.add(menuCopy);
        JPanel workPanel = new JPanel(new BorderLayout());
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BorderLayout(16, 16));
        msgPanel.setBorder(new EmptyBorder(16, 16, 16, 16));
        GHtmlLabel msgText = new GHtmlLabel(this.getHTML(msg, CollectionUtils.asSet((Object[])new Throwable[]{throwable}))){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 300;
                return size;
            }
        };
        msgText.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        msgPanel.add((Component)msgText, "Center");
        Box buttonBox = Box.createVerticalBox();
        this.sendButton = new JButton(SEND);
        this.sendButton.addActionListener(e -> this.sendCallback());
        this.sendButton.setMaximumSize(new Dimension(Short.MAX_VALUE, this.sendButton.getPreferredSize().height));
        if (ErrLogDialog.getErrorReporter() != null) {
            buttonBox.add(this.sendButton);
            buttonBox.add(Box.createVerticalStrut(16));
        }
        this.detailButton = new JButton(showingDetails ? CLOSE : DETAIL);
        this.detailButton.addActionListener(e -> this.detailCallback());
        this.detailButton.setMaximumSize(new Dimension(Short.MAX_VALUE, this.detailButton.getPreferredSize().height));
        buttonBox.add(this.detailButton);
        msgPanel.add((Component)buttonBox, "East");
        this.horizontalSpacer = Box.createVerticalStrut(10);
        this.horizontalSpacer.setVisible(showingDetails);
        msgPanel.add(this.horizontalSpacer, "South");
        workPanel.add((Component)msgPanel, "North");
        Box workBox = Box.createVerticalBox();
        this.root = new ReportRootNode(this.getTitle(), CollectionUtils.asSet((Object[])new Throwable[]{throwable}));
        this.tree = new GTree(this.root){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = 400;
                dim.width = 800;
                return dim;
            }
        };
        for (GTreeNode node : CollectionUtils.asIterable(this.root.iterator(true))) {
            if (!(node instanceof ReportExceptionNode)) continue;
            this.tree.expandTree(node);
        }
        this.tree.setSelectedNode(this.root.getChild(0));
        this.tree.setVisible(showingDetails);
        ExcTreeTransferHandler handler = new ExcTreeTransferHandler(this.root);
        this.tree.setDragNDropHandler(handler);
        this.tree.setTransferHandler(handler);
        ActionMap map = this.tree.getActionMap();
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ErrLogExpandableDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        workBox.add(this.tree);
        workPanel.add((Component)workBox, "Center");
        this.repack();
        this.addWorkPanel(workPanel);
        this.addDismissButton();
    }

    private String getHTML(String msg, Collection<Throwable> report) {
        HTMLElement html = new HTMLElement("html");
        HTMLElement body = html.addElement("body");
        if (msg != null) {
            if (msg.startsWith("<HTML>")) {
                body.addHTMLContent(msg);
            } else {
                String withBRs = this.addBR(msg);
                body.addHTMLContent(withBRs);
            }
        }
        for (Throwable t : report) {
            String tMsg = this.getMessage(t);
            if (SystemUtilities.isEqual((Object)msg, (Object)tMsg)) continue;
            String htmlTMsg = this.addBR(tMsg);
            body.addElement("p").addHTMLContent(htmlTMsg);
        }
        return html.toString();
    }

    private String addBR(String text) {
        String withBRs = HTMLUtilities.lineWrapWithHTMLLineBreaks((String)text, (int)0);
        return withBRs;
    }

    private String getMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            return message;
        }
        return t.getClass().getSimpleName();
    }

    private void detailCallback() {
        showingDetails = !showingDetails;
        this.tree.setVisible(showingDetails);
        this.horizontalSpacer.setVisible(showingDetails);
        this.detailButton.setText(showingDetails ? CLOSE : DETAIL);
        this.repack();
    }

    private void sendCallback() {
        String details = this.root.collectReportText(null, 0).trim();
        String title = this.getTitle();
        this.close();
        ErrLogDialog.getErrorReporter().report(this.rootPanel, title, details);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 600;
        return dim;
    }

    @Override
    public void addException(String message, Throwable t) {
        int n = this.errors.size();
        if (n > 100) {
            return;
        }
        this.errors.add(t);
        this.root.addNode(new ReportExceptionNode(t));
        this.updateTitle();
    }

    @Override
    int getExceptionCount() {
        return this.root.getChildCount();
    }

    @Override
    String getBaseTitle() {
        return this.baseTitle;
    }

    @Override
    public String getMessage() {
        return this.root.getReportText();
    }

    static class ReportRootNode
    extends GTreeNode
    implements NodeWithText {
        protected Collection<? extends Throwable> report;
        protected String title;
        protected boolean loaded = false;

        public ReportRootNode(String title, Collection<? extends Throwable> report) {
            this.title = title;
            this.report = report;
            for (Throwable throwable : report) {
                this.addNode(new ReportExceptionNode(throwable));
            }
        }

        @Override
        public String getName() {
            return this.title;
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return IMG_REPORT;
        }

        @Override
        public String getToolTip() {
            return "List of exceptions that occurred during relocation";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getReportText() {
            return "Error Report: " + this.title + "\n";
        }

        @Override
        public String collectReportText(Collection<? extends GTreeNode> included, int indent) {
            return NodeWithText.Util.collectReportText(this, included, indent);
        }

        @Override
        public boolean doesIndent() {
            return false;
        }
    }

    static class ReportExceptionNode
    extends GTreeLazyNode
    implements NodeWithText {
        protected Throwable exc;
        protected boolean loaded = false;

        public ReportExceptionNode(Throwable cause) {
            this.exc = cause;
        }

        @Override
        public String getName() {
            return this.getPrefix() + ": " + this.exc.toString();
        }

        @Override
        protected List<GTreeNode> generateChildren() {
            ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
            list.add(new ReportStackTraceNode(this.exc));
            Throwable c = this.exc.getCause();
            if (c != null) {
                if (c instanceof MultipleCauses) {
                    for (Throwable t : ((MultipleCauses)c).getCauses()) {
                        list.add(new ReportExceptionNode(t));
                    }
                } else {
                    list.add(new ReportCauseNode(c));
                }
            }
            return list;
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return IMG_EXCEPTION;
        }

        @Override
        public String getToolTip() {
            return "An exception occurred";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        protected String getPrefix() {
            return "Exception";
        }

        @Override
        public String getReportText() {
            return this.getName();
        }

        @Override
        public String collectReportText(Collection<? extends GTreeNode> included, int indent) {
            return NodeWithText.Util.collectReportText(this, included, indent);
        }

        @Override
        public boolean doesIndent() {
            return true;
        }
    }

    private static class ExcTreeTransferHandler
    extends TransferHandler
    implements GTreeDragNDropHandler {
        protected ReportRootNode root;

        public ExcTreeTransferHandler(ReportRootNode root) {
            this.root = root;
        }

        @Override
        public DataFlavor[] getSupportedDataFlavors(List<GTreeNode> transferNodes) {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            ArrayList<GTreeNode> nodes = new ArrayList<GTreeNode>();
            for (TreePath path : ((JTree)c).getSelectionPaths()) {
                nodes.add((GTreeNode)path.getLastPathComponent());
            }
            try {
                return new StringSelection((String)this.getTransferData(nodes, DataFlavor.stringFlavor));
            }
            catch (UnsupportedFlavorException e) {
                Msg.debug((Object)this, (Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Override
        public Object getTransferData(List<GTreeNode> transferNodes, DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor != DataFlavor.stringFlavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            if (transferNodes.isEmpty()) {
                return null;
            }
            if (transferNodes.size() == 1) {
                GTreeNode node = transferNodes.get(0);
                if (node instanceof NodeWithText) {
                    return ((NodeWithText)((Object)node)).collectReportText(transferNodes, 0).trim();
                }
                return null;
            }
            return this.root.collectReportText(transferNodes, 0).trim();
        }

        @Override
        public boolean isStartDragOk(List<GTreeNode> dragUserData, int dragAction) {
            for (GTreeNode node : dragUserData) {
                if (!(node instanceof NodeWithText)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getSupportedDragActions() {
            return 1;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean isDropSiteOk(GTreeNode destUserData, DataFlavor[] flavors, int dropAction) {
            return false;
        }

        @Override
        public void drop(GTreeNode destUserData, Transferable transferable, int dropAction) {
            throw new UnsupportedOperationException();
        }
    }

    static class ReportStackFrameNode
    extends GTreeNode
    implements NodeWithText {
        private StackTraceElement te;

        public ReportStackFrameNode(StackTraceElement te) {
            this.te = te;
        }

        @Override
        public String getName() {
            return "at " + this.te.toString();
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return IMG_FRAME_ELEMENT;
        }

        @Override
        public String getToolTip() {
            return "Stack trace element";
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public String getReportText() {
            return this.getName();
        }

        @Override
        public String collectReportText(Collection<? extends GTreeNode> included, int indent) {
            return NodeWithText.Util.collectReportText(this, included, indent);
        }

        @Override
        public boolean doesIndent() {
            return false;
        }
    }

    static class ReportCauseNode
    extends ReportExceptionNode {
        public ReportCauseNode(Throwable cause) {
            super(cause);
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return IMG_CAUSE;
        }

        @Override
        public String getToolTip() {
            return "The cause of the above exception";
        }

        @Override
        public String getPrefix() {
            return "Caused by";
        }
    }

    static class ReportStackTraceNode
    extends GTreeLazyNode
    implements NodeWithText {
        protected Throwable exc;
        protected boolean loaded = false;

        public ReportStackTraceNode(Throwable cause) {
            this.exc = cause;
        }

        @Override
        public Icon getIcon(boolean expanded) {
            return IMG_STACK;
        }

        @Override
        protected List<GTreeNode> generateChildren() {
            ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
            for (StackTraceElement te : this.exc.getStackTrace()) {
                list.add(new ReportStackFrameNode(te));
            }
            return list;
        }

        @Override
        public String getName() {
            return "Stack Trace";
        }

        @Override
        public String getToolTip() {
            return "Stack Trace for " + this.exc.toString();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getReportText() {
            return null;
        }

        @Override
        public String collectReportText(Collection<? extends GTreeNode> included, int indent) {
            return NodeWithText.Util.collectReportText(this, included, indent);
        }

        @Override
        public boolean doesIndent() {
            return false;
        }
    }

    static interface NodeWithText {
        public String getReportText();

        public String collectReportText(Collection<? extends GTreeNode> var1, int var2);

        public boolean doesIndent();

        public static class Util {
            public static final String INDENTATION = "    ";

            public static String collectReportText(GTreeNode cur, Collection<? extends GTreeNode> included, int indent) {
                StringBuilder b = new StringBuilder();
                if (cur instanceof NodeWithText) {
                    NodeWithText nwt = (NodeWithText)((Object)cur);
                    String text = nwt.getReportText();
                    if (text != null) {
                        b.append('\n');
                        for (int i = 0; i < indent; ++i) {
                            b.append(INDENTATION);
                        }
                        b.append(nwt.getReportText());
                    }
                    if (nwt.doesIndent()) {
                        ++indent;
                    }
                }
                boolean doAll = included == null || !Util.containsAny(included, cur.getChildren());
                for (GTreeNode node : cur.getChildren()) {
                    if (!(node instanceof NodeWithText) || !doAll && !included.contains(node)) continue;
                    NodeWithText nwt = (NodeWithText)((Object)node);
                    b.append(nwt.collectReportText(included, indent));
                }
                return b.toString();
            }

            public static boolean containsAny(Collection<? extends GTreeNode> included, Collection<GTreeNode> allChildren) {
                HashSet<? extends GTreeNode> res = new HashSet<GTreeNode>();
                res.addAll(included);
                res.retainAll(allChildren);
                return !res.isEmpty();
            }
        }
    }
}

