/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.UndoRedoKeeper;
import ghidra.docking.util.DockingWindowsLookAndFeelUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicSeparatorUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import resources.ResourceManager;

public class DockingUtils {
    private static final int ICON_SIZE = 16;
    public static final int CONTROL_KEY_MODIFIER_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    @Deprecated
    public static final int CONTROL_KEY_MODIFIER_MASK_DEPRECATED = (CONTROL_KEY_MODIFIER_MASK & 0x100) == 256 ? 4 : 2;
    public static final String CONTROL_KEY_NAME = (CONTROL_KEY_MODIFIER_MASK & 0x100) == 256 ? "Command" : "Control";
    private static final KeyStroke UNDO_KEYSTROKE = KeyStroke.getKeyStroke(90, CONTROL_KEY_MODIFIER_MASK);
    private static final KeyStroke REDO_KEYSTROKE = KeyStroke.getKeyStroke(89, CONTROL_KEY_MODIFIER_MASK);

    public static JSeparator createToolbarSeparator() {
        Dimension sepDim = new Dimension(2, 18);
        JSeparator separator = new JSeparator(1);
        if (DockingWindowsLookAndFeelUtils.isUsingAquaUI(separator.getUI())) {
            separator.setUI(new BasicSeparatorUI());
        }
        separator.setPreferredSize(sepDim);
        return separator;
    }

    public static Icon scaleIconAsNeeded(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon.getIconHeight() != 16 || icon.getIconWidth() != 16) {
            return ResourceManager.getScaledIcon((Icon)icon, (int)16, (int)16);
        }
        return icon;
    }

    public static boolean isControlModifier(MouseEvent mouseEvent) {
        int osSpecificMask;
        int modifiers = mouseEvent.getModifiersEx();
        return (modifiers & (osSpecificMask = CONTROL_KEY_MODIFIER_MASK)) == osSpecificMask;
    }

    public static boolean isControlModifier(KeyEvent keyEvent) {
        int osSpecificMask;
        int modifiers = keyEvent.getModifiersEx();
        return (modifiers & (osSpecificMask = CONTROL_KEY_MODIFIER_MASK)) == osSpecificMask;
    }

    public static UndoRedoKeeper installUndoRedo(JTextComponent textComponent) {
        Document document = textComponent.getDocument();
        final UndoRedoKeeper undoRedoKeeper = new UndoRedoKeeper();
        document.addUndoableEditListener(e -> {
            UndoableEdit edit = e.getEdit();
            undoRedoKeeper.addUndo(edit);
        });
        textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke keyStrokeForEvent = KeyStroke.getKeyStrokeForEvent(e);
                if (REDO_KEYSTROKE.equals(keyStrokeForEvent)) {
                    undoRedoKeeper.redo();
                    e.consume();
                } else if (UNDO_KEYSTROKE.equals(keyStrokeForEvent)) {
                    undoRedoKeeper.undo();
                    e.consume();
                }
            }
        });
        return undoRedoKeeper;
    }

    public static <T extends Component> TreeTraversalResult forAllDescendants(Container start, Class<T> type, TreeTraversalOrder order, ComponentCallback<T> cb) {
        for (Component c : start.getComponents()) {
            TreeTraversalResult res;
            if (TreeTraversalOrder.PARENT_FIRST == order && type.isAssignableFrom(c.getClass()) && (TreeTraversalResult.FINISH == (res = cb.call(c)) || TreeTraversalResult.TERMINATE == res)) {
                return res;
            }
            if (c instanceof Container && (TreeTraversalResult.FINISH == (res = DockingUtils.forAllDescendants((Container)c, type, order, cb)) || TreeTraversalResult.TERMINATE == res)) {
                return res;
            }
            if (TreeTraversalOrder.CHILDREN_FIRST != order || !type.isAssignableFrom(c.getClass()) || TreeTraversalResult.FINISH != (res = cb.call(c)) && TreeTraversalResult.TERMINATE != res) continue;
            return res;
        }
        return TreeTraversalResult.CONTINUE;
    }

    public static TreeTraversalResult forAllDescendants(Container start, ComponentCallback<Component> cb) {
        return DockingUtils.forAllDescendants(start, Component.class, TreeTraversalOrder.CHILDREN_FIRST, cb);
    }

    public static void setTransparent(JComponent c) {
        DockingUtils.doSetTransparent(c);
        if (c instanceof JScrollPane) {
            DockingUtils.doSetTransparent(((JScrollPane)c).getViewport());
        }
    }

    private static void doSetTransparent(JComponent c) {
        c.setOpaque(false);
        if (!(c instanceof JViewport)) {
            c.setBorder(BorderFactory.createEmptyBorder());
        }
        c.setBackground(new Color(0, 0, 0, 0));
    }

    public static void hideTipWindow() {
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public static enum TreeTraversalOrder {
        CHILDREN_FIRST,
        PARENT_FIRST;

    }

    public static interface ComponentCallback<T extends Component> {
        public TreeTraversalResult call(T var1);
    }

    public static enum TreeTraversalResult {
        CONTINUE,
        FINISH,
        TERMINATE;

    }
}

