/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.editors;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.list.ListRendererMouseEventForwarder;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.editors.TagEditorRenderer;
import ghidra.framework.model.Transaction;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TagEditorDialog
extends DialogComponentProvider {
    private final VTSession session;
    private JList<TagState> list;
    private TagStateListModel listModel;

    public TagEditorDialog(VTSession session) {
        super("Tag Editor", true, true, true, false);
        this.session = session;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setPreferredSize(200, 400);
    }

    private JComponent buildWorkPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.listModel = new TagStateListModel(this.getTags());
        this.list = new JList<TagState>(this.listModel);
        this.list.setBackground(scrollPane.getBackground());
        this.list.setCellRenderer((ListCellRenderer<TagState>)((Object)new TagEditorRenderer(this.list, this.listModel)));
        this.list.getSelectionModel().setSelectionMode(2);
        ListRendererMouseEventForwarder mouseAdapter = new ListRendererMouseEventForwarder();
        this.list.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.list.addMouseListener((MouseListener)mouseAdapter);
        scrollPane.setViewportView(this.list);
        mainPanel.add((Component)scrollPane, "Center");
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagState newState = this.createNewTag();
                if (newState == null) {
                    return;
                }
                TagEditorDialog.this.listModel.addElement(newState);
                TagEditorDialog.this.list.repaint();
            }

            private TagState createNewTag() {
                String tagName = OptionDialog.showInputSingleLineDialog((Component)TagEditorDialog.this.getComponent(), (String)"Create Tag", (String)"Enter tag name: ", (String)"");
                if (tagName == null || "".equals(tagName.trim())) {
                    return null;
                }
                return new TagState(tagName, new VTMatchTagImpl(tagName), TagState.Action.ADD);
            }
        });
        final JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<TagState> selectedValues = TagEditorDialog.this.list.getSelectedValuesList();
                for (TagState state : selectedValues) {
                    TagState.Action action = state.getAction();
                    if (action == TagState.Action.UNMODIFIED) {
                        state.setAction(TagState.Action.DELETE);
                        continue;
                    }
                    if (action != TagState.Action.ADD) continue;
                    TagEditorDialog.this.listModel.removeElement(state);
                }
                TagEditorDialog.this.list.repaint();
            }
        });
        deleteButton.setEnabled(false);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] selectedIndices = TagEditorDialog.this.list.getSelectedIndices();
                if (selectedIndices == null || selectedIndices.length == 0) {
                    deleteButton.setEnabled(false);
                } else {
                    deleteButton.setEnabled(true);
                }
            }
        });
        JPanel editPanel = new JPanel();
        editPanel.add(addButton);
        editPanel.add(Box.createHorizontalStrut(5));
        editPanel.add(deleteButton);
        mainPanel.add((Component)editPanel, "South");
        return mainPanel;
    }

    private Set<VTMatchTag> getTags() {
        return this.session.getMatchTags();
    }

    protected void okCallback() {
        int size = this.listModel.getSize();
        HashSet<TagState> tags = new HashSet<TagState>(size);
        for (int i = 0; i < size; ++i) {
            tags.add(this.listModel.getElementAt(i));
        }
        CommitTagEditsTask task = new CommitTagEditsTask(this.session, tags);
        new TaskLauncher((Task)task, (Component)this.getComponent());
        this.close();
    }

    class TagStateListModel
    extends AbstractListModel<TagState> {
        private List<TagState> data = new ArrayList<TagState>();

        TagStateListModel(Set<VTMatchTag> tags) {
            for (VTMatchTag tag : tags) {
                this.addElement(new TagState(tag.getName(), tag, TagState.Action.UNMODIFIED));
            }
        }

        void addElement(TagState state) {
            this.data.add(state);
            Collections.sort(this.data);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        void removeElement(TagState state) {
            int index = this.data.indexOf(state);
            this.data.remove(state);
            this.fireIntervalRemoved(state, index, index);
        }

        @Override
        public TagState getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }
    }

    static class TagState
    implements Comparable<TagState> {
        private VTMatchTag tag;
        private final String tagName;
        private Action action;
        private boolean mousePressed;

        TagState(String tagName, VTMatchTag tag, Action action) {
            this.tagName = tagName;
            this.tag = tag;
            this.action = action;
        }

        Action getAction() {
            return this.action;
        }

        boolean isUnmodified() {
            return this.action == Action.UNMODIFIED;
        }

        void setAction(Action action) {
            this.action = action;
        }

        String getTagName() {
            return this.tagName;
        }

        VTMatchTag getTag() {
            return this.tag;
        }

        void setMousePressed(boolean pressed) {
            this.mousePressed = pressed;
        }

        boolean isMousePressed() {
            return this.mousePressed;
        }

        @Override
        public int compareTo(TagState o) {
            if (this.tagName == null) {
                return o.tagName == null ? 0 : 1;
            }
            if (o.tagName == null) {
                return -1;
            }
            return this.tagName.compareToIgnoreCase(o.tagName);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.tagName + ", " + this.action + "]";
        }

        public void restoreState() {
            this.action = this.tag instanceof VTMatchTagImpl ? Action.ADD : Action.UNMODIFIED;
        }

        static enum Action {
            UNMODIFIED,
            ADD,
            DELETE;

        }
    }

    private class CommitTagEditsTask
    extends Task {
        private final Set<TagState> tags;

        public CommitTagEditsTask(VTSession session, Set<TagState> tags) {
            super("Commiting Tag Edits", true, true, true);
            this.tags = tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            boolean commit = true;
            VTSessionDB sessionDB = (VTSessionDB)TagEditorDialog.this.session;
            Program program = sessionDB.getDestinationProgram();
            if (this.hasTransactionsOpen(sessionDB)) {
                return;
            }
            int programTransactionID = program.startTransaction(this.getTaskTitle());
            int matchSetTransactionID = sessionDB.startTransaction(this.getTaskTitle());
            try {
                this.doWork(monitor);
            }
            catch (CancelledException e) {
                commit = false;
            }
            catch (Exception e) {
                commit = false;
                Msg.showError((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)"An unexpected error occurred attempting to set match tag.", (Throwable)e);
            }
            finally {
                try {
                    program.endTransaction(programTransactionID, commit);
                }
                catch (Exception e) {
                }
                finally {
                    sessionDB.endTransaction(matchSetTransactionID, commit);
                }
            }
        }

        private void doWork(TaskMonitor monitor) throws CancelledException {
            monitor.initialize((long)this.tags.size());
            for (TagState tagState : this.tags) {
                monitor.checkCanceled();
                switch (tagState.action) {
                    case ADD: {
                        this.addTag(tagState.getTagName());
                        break;
                    }
                    case DELETE: {
                        this.deleteTag(tagState.getTag());
                        break;
                    }
                }
                monitor.incrementProgress(1L);
            }
        }

        private void deleteTag(VTMatchTag tag) {
            TagEditorDialog.this.session.deleteMatchTag(tag);
        }

        private void addTag(String tagName) {
            TagEditorDialog.this.session.createMatchTag(tagName);
        }

        private boolean hasTransactionsOpen(VTSessionDB sessionDB) {
            Program program = sessionDB.getDestinationProgram();
            Transaction transaction = program.getCurrentTransaction();
            if (transaction != null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)("The program \"" + program.getName() + "\"already has a transaction open: " + transaction.getDescription()));
                return true;
            }
            Transaction matchSetTransaction = sessionDB.getCurrentTransaction();
            if (matchSetTransaction != null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)"Transaction already open for the Match Set Manager ");
                return true;
            }
            return false;
        }
    }

    private class VTMatchTagImpl
    implements VTMatchTag {
        private final String name;

        VTMatchTagImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(VTMatchTag o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

