/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.MarkupItemStorageDB;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.impl.MarkupItemFactory;
import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MarkupItemManagerImpl {
    private static final List<VTMarkupItem> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private List<VTMarkupItem> markupItems = EMPTY_LIST;
    private boolean isCreatingMarkupItems;
    private final VTAssociationDB association;

    public MarkupItemManagerImpl(VTAssociationDB association) {
        this.association = association;
    }

    public boolean hasAppliedMarkupItems() {
        if (this.markupItems == EMPTY_LIST) {
            return this.hasAppliedStoredMarkupItems();
        }
        for (VTMarkupItem markupItem : this.markupItems) {
            if (!markupItem.canUnapply()) continue;
            return true;
        }
        return false;
    }

    public synchronized List<VTMarkupItem> getMarkupItems(TaskMonitor monitor) throws CancelledException {
        if (this.isCreatingMarkupItems) {
            return EMPTY_LIST;
        }
        if (this.markupItems == EMPTY_LIST) {
            this.isCreatingMarkupItems = true;
            this.markupItems = this.createMarkupItems(monitor);
            this.isCreatingMarkupItems = false;
        }
        return Collections.unmodifiableList(this.markupItems);
    }

    protected List<VTMarkupItem> createMarkupItems(TaskMonitor monitor) throws CancelledException {
        Collection<VTMarkupItem> generatedMarkupItems = this.getGeneratedMarkupItems(monitor);
        Collection<VTMarkupItem> databaseMarkupItems = this.getStoredMarkupItems(monitor);
        return this.replaceGeneratedMarkupItemsWithDBMarkupItems(generatedMarkupItems, databaseMarkupItems);
    }

    protected Collection<VTMarkupItem> getGeneratedMarkupItems(TaskMonitor monitor) throws CancelledException {
        return MarkupItemFactory.generateMarkupItems(monitor, this.association);
    }

    private boolean hasAppliedStoredMarkupItems() {
        AssociationDatabaseManager associationDBM = this.association.getAssociationManagerDB();
        try {
            Collection<MarkupItemStorageDB> databaseMarkupItems = associationDBM.getAppliedMarkupItems(TaskMonitor.DUMMY, this.association);
            for (MarkupItemStorageDB appliedItem : databaseMarkupItems) {
                VTMarkupItemStatus status = appliedItem.getStatus();
                if (!status.isUnappliable()) continue;
                return true;
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return false;
    }

    private Collection<VTMarkupItem> getStoredMarkupItems(TaskMonitor monitor) throws CancelledException {
        AssociationDatabaseManager associationDBM = this.association.getAssociationManagerDB();
        Collection<MarkupItemStorageDB> appliedMarkupItems = associationDBM.getAppliedMarkupItems(monitor, this.association);
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        for (MarkupItemStorageDB markupItemStorageDB : appliedMarkupItems) {
            list.add(new MarkupItemImpl(markupItemStorageDB));
        }
        return list;
    }

    private List<VTMarkupItem> replaceGeneratedMarkupItemsWithDBMarkupItems(Collection<VTMarkupItem> generatedMarkupItems, Collection<VTMarkupItem> databaseMarkupItems) {
        HashMap<String, VTMarkupItem> map = new HashMap<String, VTMarkupItem>();
        for (VTMarkupItem markupItem : generatedMarkupItems) {
            map.put(this.getMarkupItemMapKey(markupItem), markupItem);
        }
        for (VTMarkupItem markupItem : databaseMarkupItems) {
            map.put(this.getMarkupItemMapKey(markupItem), markupItem);
        }
        return new ArrayList<VTMarkupItem>(map.values());
    }

    private String getMarkupItemMapKey(VTMarkupItem markupItem) {
        return markupItem.getMarkupType().getDisplayName() + markupItem.getSourceAddress().toString(true);
    }

    public void clearCache() {
        this.markupItems = EMPTY_LIST;
    }
}

