/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.DebugAdvanced;
import agent.dbgeng.dbgeng.DebugClientReentrant;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.dbgeng.DebugEventCallbacks;
import agent.dbgeng.dbgeng.DebugInputCallbacks;
import agent.dbgeng.dbgeng.DebugOutputCallbacks;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugRunningProcess;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import java.util.List;

public interface DebugClient
extends DebugClientReentrant {
    public DebugAdvanced getAdvanced();

    @Override
    public DebugControl getControl();

    public DebugDataSpaces getDataSpaces();

    public DebugRegisters getRegisters();

    public DebugSymbols getSymbols();

    public DebugSystemObjects getSystemObjects();

    public DebugServerId getLocalServer();

    public void attachKernel(long var1, String var3);

    public void startProcessServer(String var1);

    public DebugServerId connectProcessServer(String var1);

    public boolean dispatchCallbacks(int var1);

    public void flushCallbacks();

    default public void dispatchCallbacks() {
        this.dispatchCallbacks(-1);
    }

    public void exitDispatch(DebugClient var1);

    default public void exitDispatch() {
        this.exitDispatch(this);
    }

    public void setInputCallbacks(DebugInputCallbacks var1);

    public void setOutputCallbacks(DebugOutputCallbacks var1);

    public void setEventCallbacks(DebugEventCallbacks var1);

    public List<DebugRunningProcess> getRunningProcesses(DebugServerId var1);

    public DebugRunningProcess.Description getProcessDescription(DebugServerId var1, int var2, BitmaskSet<DebugRunningProcess.Description.ProcessDescriptionFlags> var3);

    public void attachProcess(DebugServerId var1, long var2, BitmaskSet<DebugAttachFlags> var4);

    public void createProcess(DebugServerId var1, String var2, BitmaskSet<DebugCreateFlags> var3);

    public void createProcessAndAttach(DebugServerId var1, String var2, BitmaskSet<DebugCreateFlags> var3, int var4, BitmaskSet<DebugAttachFlags> var5);

    public void startServer(String var1);

    public void waitForProcessServerEnd(int var1);

    default public void waitForProcessServerEnd() {
        this.waitForProcessServerEnd(-1);
    }

    public void terminateCurrentProcess();

    public void detachCurrentProcess();

    public void abandonCurrentProcess();

    public void connectSession(int var1);

    public void endSession(DebugEndSessionFlags var1);

    public void openDumpFileWide(String var1);

    public static enum DebugOutputFlags {
        DEBUG_OUTPUT_NORMAL(1),
        DEBUG_OUTPUT_ERROR(2),
        DEBUG_OUTPUT_WARNING(4),
        DEBUG_OUTPUT_VERBOSE(8),
        DEBUG_OUTPUT_PROMPT(16),
        DEBUG_OUTPUT_PROMPT_REGISTERS(32),
        DEBUG_OUTPUT_EXTENSION_WARNING(64),
        DEBUG_OUTPUT_DEBUGGEE(128),
        DEBUG_OUTPUT_DEBUGGEE_PROMPT(256),
        DEBUG_OUTPUT_SYMBOLS(512);

        private final int value;

        private DebugOutputFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugEndSessionFlags {
        DEBUG_END_PASSIVE(0),
        DEBUG_END_ACTIVE_TERMINATE(1),
        DEBUG_END_ACTIVE_DETACH(2),
        DEBUG_END_REENTRANT(3),
        DEBUG_END_DISCONNECT(4);

        private final int value;

        private DebugEndSessionFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugCreateFlags implements BitmaskUniverse
    {
        DEBUG_PROCESS(1),
        DEBUG_ONLY_THIS_PROCESS(2),
        CREATE_SUSPENDED(4),
        DETACHED_PROCESS(8),
        CREATE_NEW_CONSOLE(16),
        CREATE_NEW_PROCESS_GROUP(512),
        CREATE_UNICODE_ENVIRONMENT(1024),
        CREATE_SEPARATE_WOW_VDM(2048),
        CREATE_SHARED_WOW_VDM(4096),
        CREATE_FORCEDOS(8192),
        INHERIT_PARENT_AFFINITY(65536),
        CREATE_PROTECTED_PROCESS(262144),
        EXTENDED_STARTUPINFO_PRESENT(524288),
        CREATE_BREAKAWAY_FROM_JOB(0x1000000),
        CREATE_PRESERVE_CODE_AUTHZ_LEVEL(0x2000000),
        CREATE_DEFAULT_ERROR_MODE(0x4000000),
        CREATE_NO_WINDOW(0x8000000),
        DEBUG_CREATE_NO_DEBUG_HEAP(1024),
        DEBUG_CREATE_THROUGH_RTL(65536);

        private final int mask;

        private DebugCreateFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugAttachFlags implements BitmaskUniverse
    {
        DEFAULT(0),
        NONINVASIVE(1),
        EXISTING(2),
        NONINVASIVE_NO_SUSPEND(4),
        INVASIVE_NO_INITIAL_BREAK(8),
        INVASIVE_RESUME_PROCESS(16),
        NONINVASIVE_ALLOW_PARTIAL(32);

        private final int mask;

        private DebugAttachFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeSymbolState implements BitmaskUniverse
    {
        ALL(-1),
        LOADS(1),
        UNLOADS(2),
        SCOPE(4),
        PATHS(8),
        SYMBOL_OPTIONS(16),
        TYPE_OPTIONS(32);

        private final int mask;

        private ChangeSymbolState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeEngineState implements BitmaskUniverse
    {
        ALL(-1),
        CURRENT_THREAD(1),
        EFFECTIVE_PROCESSOR(2),
        BREAKPOINTS(4),
        CODE_LEVEL(8),
        EXECUTION_STATUS(16),
        ENGINE_OPTIONS(32),
        LOG_FILE(64),
        RADIX(128),
        EVENT_FILTERS(256),
        PROCESS_OPTIONS(512),
        EXTENSIONS(1024),
        SYSTEMS(2048),
        ASSEMBLY_OPTIONS(4096),
        EXPRESSION_SYNTAX(8192),
        TEXT_REPLACEMENTS(16384);

        private final int mask;

        private ChangeEngineState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeDebuggeeState implements BitmaskUniverse
    {
        ALL(-1),
        REGISTERS(1),
        DATA(2),
        REFRESH(4);

        private final int mask;

        private ChangeDebuggeeState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum SessionStatus {
        ACTIVE,
        END_SESSION_ACTIVE_TERMINATE,
        END_SESSION_ACTIVE_DETACH,
        END_SESSION_PASSIVE,
        END,
        REBOOT,
        HIBERNATE,
        FAILURE;

    }

    public static enum DebugStatus {
        NO_CHANGE(false, null, 13),
        GO(true, ExecutionState.RUNNING, 10),
        GO_HANDLED(true, ExecutionState.RUNNING, 9),
        GO_NOT_HANDLED(true, ExecutionState.RUNNING, 8),
        STEP_OVER(true, ExecutionState.RUNNING, 7),
        STEP_INTO(true, ExecutionState.RUNNING, 5),
        BREAK(false, ExecutionState.STOPPED, 0),
        NO_DEBUGGEE(true, null, 1),
        STEP_BRANCH(true, ExecutionState.RUNNING, 6),
        IGNORE_EVENT(false, null, 11),
        RESTART_REQUESTED(true, null, 12),
        REVERSE_GO(true, null, 255),
        REVERSE_STEP_BRANCH(true, null, 255),
        REVERSE_STEP_OVER(true, null, 255),
        REVERSE_STEP_INTO(true, null, 255),
        OUT_OF_SYNC(false, null, 2),
        WAIT_INPUT(false, null, 3),
        TIMEOUT(false, null, 4);

        public static final long MASK = 175L;
        public static final long INSIDE_WAIT = 0x100000000L;
        public static final long WAIT_TIMEOUT = 0x200000000L;
        public final boolean shouldWait;
        public final ExecutionState threadState;
        public final int precedence;

        private DebugStatus(boolean shouldWait, ExecutionState threadState, int precedence) {
            this.shouldWait = shouldWait;
            this.threadState = threadState;
            this.precedence = precedence;
        }

        public static DebugStatus fromArgument(long argument) {
            return DebugStatus.values()[(int)(argument & 0xAFL)];
        }

        public static boolean isInsideWait(long argument) {
            return (argument & 0x100000000L) != 0L;
        }

        public static boolean isWaitTimeout(long argument) {
            return (argument & 0x200000000L) != 0L;
        }
    }

    public static enum ExecutionState {
        RUNNING,
        STOPPED;

    }
}

