/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DefaultBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.RecorderThreadMap;
import ghidra.app.plugin.core.debug.service.model.TraceEventListener;
import ghidra.app.plugin.core.debug.service.model.TraceObjectListener;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedStackRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncLazyMap;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointLocationContainer;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.TargetSectionContainer;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.DuplicateNameException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TraceObjectManager {
    private final TargetObject target;
    private final TraceEventListener eventListener;
    final TraceObjectListener objectListener;
    protected final NavigableMap<List<String>, TargetObject> objects = new TreeMap<List<String>, TargetObject>((Comparator<List<String>>)PathUtils.PathComparator.KEYED);
    private DefaultTraceRecorder recorder;
    private DefaultDebuggerTargetTraceMapper mapper;
    protected DebuggerMemoryMapper memMapper;
    protected AsyncLazyMap<TargetRegisterContainer, DebuggerRegisterMapper> regMappers;
    private final ListenerSet<TraceRecorderListener> listeners = new ListenerSet(TraceRecorderListener.class);
    protected final Set<TargetBreakpointLocation> breakpoints = new HashSet<TargetBreakpointLocation>();
    private LinkedHashMap<Class<?>, Function<TargetObject, Void>> handlerMapCreate = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Function<TargetObject, Void>> handlerMapInit = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Function<TargetObject, Void>> handlerMapRemove = new LinkedHashMap();
    private LinkedHashMap<Class<?>, BiFunction<TargetObject, Map<String, ?>, Void>> handlerMapElements = new LinkedHashMap();
    private LinkedHashMap<Class<?>, BiFunction<TargetObject, Map<String, ?>, Void>> handlerMapAttributes = new LinkedHashMap();

    public TraceObjectManager(TargetObject target, DefaultDebuggerTargetTraceMapper mapper, DefaultTraceRecorder recorder) {
        this.target = target;
        this.mapper = mapper;
        this.recorder = recorder;
        this.regMappers = new AsyncLazyMap(new HashMap(), ref -> mapper.offerRegisters((TargetRegisterContainer)ref));
        this.defaultHandlers();
        this.eventListener = new TraceEventListener(this);
        this.objectListener = new TraceObjectListener(this);
    }

    public CompletableFuture<Void> init() {
        return this.objectListener.init().thenCombine(this.eventListener.init(), (v1, v2) -> null);
    }

    private void defaultHandlers() {
        this.putCreateHandler(TargetThread.class, this::createThread);
        this.putCreateHandler(TargetMemory.class, this::createMemory);
        this.putCreateHandler(TargetRegister.class, this::createRegister);
        this.putInitHandler(TargetStack.class, this::addStack);
        this.putInitHandler(TargetStackFrame.class, this::addStackFrame);
        this.putInitHandler(TargetRegisterBank.class, this::addRegisterBank);
        this.putInitHandler(TargetRegisterContainer.class, this::addRegisterContainer);
        this.putInitHandler(TargetModule.class, this::addModule);
        this.putInitHandler(TargetBreakpointSpecContainer.class, this::addBreakpointContainer);
        this.putInitHandler(TargetBreakpointSpec.class, this::addBreakpointSpec);
        this.putInitHandler(TargetBreakpointLocation.class, this::addBreakpointLocation);
        this.putElementsHandler(TargetBreakpointLocationContainer.class, this::elementsChangedBreakpointLocationContainer);
        this.putElementsHandler(TargetMemory.class, this::elementsChangedMemory);
        this.putElementsHandler(TargetSectionContainer.class, this::elementsChangedSectionContainer);
        this.putElementsHandler(TargetStack.class, this::elementsChangedStack);
        this.putAttributesHandler(TargetBreakpointSpec.class, this::attributesChangedBreakpointSpec);
        this.putAttributesHandler(TargetBreakpointLocation.class, this::attributesChangedBreakpointLocation);
        this.putAttributesHandler(TargetMemoryRegion.class, this::attributesChangedMemoryRegion);
        this.putAttributesHandler(TargetRegister.class, this::attributesChangedRegister);
        this.putAttributesHandler(TargetStackFrame.class, this::attributesChangedStackFrame);
        this.putAttributesHandler(TargetThread.class, this::attributesChangedThread);
        this.putRemHandler(TargetProcess.class, this::removeProcess);
        this.putRemHandler(TargetThread.class, this::removeThread);
        this.putRemHandler(TargetStack.class, this::removeStack);
        this.putRemHandler(TargetStackFrame.class, this::removeStackFrame);
        this.putRemHandler(TargetStack.class, this::removeRegisterBank);
        this.putRemHandler(TargetRegisterContainer.class, this::removeRegisterContainer);
        this.putRemHandler(TargetRegister.class, this::removeRegister);
        this.putRemHandler(TargetMemory.class, this::removeMemory);
        this.putRemHandler(TargetMemoryRegion.class, this::removeMemoryRegion);
        this.putRemHandler(TargetModule.class, this::removeModule);
        this.putRemHandler(TargetSection.class, this::removeSection);
        this.putRemHandler(TargetBreakpointSpecContainer.class, this::removeBreakpointContainer);
        this.putRemHandler(TargetBreakpointSpec.class, this::removeBreakpointSpec);
        this.putRemHandler(TargetBreakpointLocation.class, this::removeBreakpointLocation);
    }

    private <U extends TargetObject> Function<TargetObject, Void> putHandler(Class<?> key, Consumer<TargetObject> handler, LinkedHashMap<Class<?>, Function<TargetObject, Void>> handlerMap) {
        return handlerMap.put(key, u -> {
            handler.accept((TargetObject)u);
            return null;
        });
    }

    private <U extends TargetObject> BiFunction<TargetObject, Map<String, ?>, Void> putHandler(Class<?> key, BiConsumer<TargetObject, Map<String, ?>> handler, LinkedHashMap<Class<?>, BiFunction<TargetObject, Map<String, ?>, Void>> handlerMap) {
        return handlerMap.put(key, (u, v) -> {
            handler.accept((TargetObject)u, (Map<String, ?>)v);
            return null;
        });
    }

    public <U extends TargetObject> Function<TargetObject, Void> putCreateHandler(Class<?> key, Consumer<TargetObject> handler) {
        return this.putHandler(key, handler, this.handlerMapCreate);
    }

    public <U extends TargetObject> Function<TargetObject, Void> putInitHandler(Class<?> key, Consumer<TargetObject> handler) {
        return this.putHandler(key, handler, this.handlerMapInit);
    }

    public <U extends TargetObject> Function<TargetObject, Void> putRemHandler(Class<?> key, Consumer<TargetObject> handler) {
        return this.putHandler(key, handler, this.handlerMapRemove);
    }

    public <U extends TargetObject> BiFunction<TargetObject, Map<String, ?>, Void> putAttributesHandler(Class<?> key, BiConsumer<TargetObject, Map<String, ?>> handler) {
        return this.putHandler(key, handler, this.handlerMapAttributes);
    }

    public <U extends TargetObject> BiFunction<TargetObject, Map<String, ?>, Void> putElementsHandler(Class<?> key, BiConsumer<TargetObject, Map<String, ?>> handler) {
        return this.putHandler(key, handler, this.handlerMapElements);
    }

    private void processObject(TargetObject targetObject, LinkedHashMap<Class<?>, Function<TargetObject, Void>> handlerMap) {
        Set interfaces = targetObject.getSchema().getInterfaces();
        for (Class ifc : interfaces) {
            Function<TargetObject, Void> function = handlerMap.get(ifc);
            if (function == null) continue;
            function.apply(targetObject);
        }
    }

    private void processObject(TargetObject targetObject, Map<String, ?> map, LinkedHashMap<Class<?>, BiFunction<TargetObject, Map<String, ?>, Void>> handlerMap) {
        Set interfaces = targetObject.getSchema().getInterfaces();
        for (Class ifc : interfaces) {
            BiFunction<TargetObject, Map<String, ?>, Void> function = handlerMap.get(ifc);
            if (function == null) continue;
            function.apply(targetObject, map);
        }
    }

    public void createObject(TargetObject toInit) {
        this.processObject(toInit, this.handlerMapCreate);
    }

    public void initObject(TargetObject added) {
        this.processObject(added, this.handlerMapInit);
    }

    public void removeObject(TargetObject removed) {
        this.processObject(removed, this.handlerMapRemove);
    }

    public void attributesChanged(TargetObject changed, Map<String, ?> added) {
        this.processObject(changed, added, this.handlerMapAttributes);
    }

    public void elementsChanged(TargetObject changed, Map<String, ?> added) {
        this.processObject(changed, added, this.handlerMapElements);
    }

    public boolean isRequired(TargetObject obj) {
        if (obj.getName().equals("Debug")) {
            return true;
        }
        if (obj.getName().equals("Stack")) {
            return true;
        }
        Set interfaces = obj.getSchema().getInterfaces();
        for (Class ifc : interfaces) {
            if (!this.handlerMapInit.keySet().contains(ifc)) continue;
            return true;
        }
        return false;
    }

    public void addProcess(TargetObject added) {
        this.recorder.init();
    }

    public void removeProcess(TargetObject removed) {
        this.recorder.stopRecording();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThread(TargetObject added) {
        RecorderThreadMap recorderThreadMap = this.recorder.threadMap;
        synchronized (recorderThreadMap) {
            ManagedThreadRecorder threadRecorder = this.recorder.getThreadRecorder((TargetThread)added);
            TraceThread traceThread = threadRecorder.getTraceThread();
            this.recorder.createSnapshot(traceThread + " started", traceThread, null);
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.recorder.getTrace(), (String)"Adjust thread creation");){
                long existing = traceThread.getCreationSnap();
                if (existing == Long.MIN_VALUE) {
                    traceThread.setCreationSnap(this.recorder.getSnap());
                } else {
                    traceThread.setDestructionSnap(Long.MAX_VALUE);
                }
            }
            catch (DuplicateNameException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)("Unable to set creation snap for " + traceThread));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(TargetObject removed) {
        RecorderThreadMap recorderThreadMap = this.recorder.threadMap;
        synchronized (recorderThreadMap) {
            ManagedThreadRecorder threadRecorder = this.recorder.getThreadRecorder((TargetThread)removed);
            threadRecorder.objectRemoved(removed);
        }
    }

    public void addStack(TargetObject added) {
    }

    public void removeStack(TargetObject removed) {
    }

    public void addStackFrame(TargetObject added) {
        ManagedThreadRecorder rec = this.recorder.getThreadRecorderForSuccessor(added);
        if (rec == null) {
            Msg.error((Object)this, (Object)("Frame without thread?: " + added));
        } else {
            rec.getStackRecorder().offerStackFrame((TargetStackFrame)added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStackFrame(TargetObject removed) {
        RecorderThreadMap recorderThreadMap = this.recorder.threadMap;
        synchronized (recorderThreadMap) {
            ManagedThreadRecorder threadRecorder = this.recorder.getThreadRecorderForSuccessor(removed);
            threadRecorder.objectRemoved(removed);
        }
    }

    public void addRegisterBank(TargetObject added) {
        ManagedThreadRecorder rec = this.recorder.getThreadRecorderForSuccessor(added);
        if (added instanceof TargetStackFrame) {
            rec.getStackRecorder().offerStackFrame((TargetStackFrame)added);
        }
        rec.offerRegisters((TargetRegisterBank)added);
    }

    public void removeRegisterBank(TargetObject removed) {
    }

    public void addRegisterContainer(TargetObject added) {
    }

    public void removeRegisterContainer(TargetObject removed) {
        this.regMappers.remove((Object)((TargetRegisterContainer)removed));
    }

    public void createRegister(TargetObject added) {
        if (added.getCachedAttribute("_container") != null) {
            TargetRegister register = (TargetRegister)added;
            this.regMappers.get((Object)register.getContainer()).thenAccept(rm -> {
                if (rm != null) {
                    rm.targetRegisterAdded(register);
                    for (ManagedThreadRecorder rec : this.recorder.threadMap.byTargetThread.values()) {
                        rec.regMapperAmended((DebuggerRegisterMapper)rm, register, false);
                    }
                }
            });
        }
    }

    public void removeRegister(TargetObject removed) {
        TargetRegister register = (TargetRegister)removed;
        TargetRegisterContainer cont = register.getContainer();
        DebuggerRegisterMapper rm = (DebuggerRegisterMapper)this.regMappers.getCompletedMap().get(cont);
        if (rm == null) {
            return;
        }
        rm.targetRegisterRemoved(register);
        for (ManagedThreadRecorder rec : this.recorder.threadMap.byTargetThread.values()) {
            rec.regMapperAmended(rm, register, true);
        }
    }

    public void createMemory(TargetObject added) {
        if (this.memMapper != null) {
            return;
        }
        this.recorder.memoryRecorder.offerProcessMemory((TargetMemory)added);
        ((CompletableFuture)this.mapper.offerMemory((TargetMemory)added).thenAccept(mm -> {
            TraceObjectManager traceObjectManager = this;
            synchronized (traceObjectManager) {
                this.memMapper = mm;
            }
        })).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Could not intialize memory mapper", (Throwable)ex);
            return null;
        });
    }

    public void removeMemory(TargetObject removed) {
        this.recorder.memoryRecorder.removeProcessMemory((TargetMemory)removed);
    }

    public void addMemoryRegion(TargetObject added) {
    }

    public void removeMemoryRegion(TargetObject removed) {
        this.recorder.memoryRecorder.removeProcessRegion((TargetMemoryRegion)removed);
    }

    public void addModule(TargetObject added) {
        this.recorder.moduleRecorder.offerProcessModule((TargetModule)added);
    }

    public void removeModule(TargetObject removed) {
        this.recorder.moduleRecorder.removeProcessModule((TargetModule)removed);
    }

    public void addSection(TargetObject added) {
    }

    public void removeSection(TargetObject removed) {
    }

    public void addBreakpointContainer(TargetObject added) {
        TargetObject obj = this.findThreadOrProcess(added);
        DefaultBreakpointRecorder breakpointRecorder = this.recorder.breakpointRecorder;
        if (obj instanceof TargetThread) {
            ManagedBreakpointRecorder rec = this.recorder.getThreadRecorderForSuccessor(added).getBreakpointRecorder();
            rec.offerBreakpointContainer((TargetBreakpointSpecContainer)added);
            return;
        }
        breakpointRecorder.offerBreakpointContainer((TargetBreakpointSpecContainer)added);
    }

    public void removeBreakpointContainer(TargetObject removed) {
    }

    public void addBreakpointSpec(TargetObject added) {
    }

    public void removeBreakpointSpec(TargetObject removed) {
    }

    public void addBreakpointLocation(TargetObject added) {
    }

    public void removeBreakpointLocation(TargetObject removed) {
        this.breakpoints.remove(removed);
        this.recorder.breakpointRecorder.removeBreakpointLocation((TargetBreakpointLocation)removed);
    }

    protected TargetObject findThreadOrProcess(TargetObject successor) {
        TargetObject object;
        for (object = successor; object != null; object = object.getParent()) {
            if (object instanceof TargetProcess) {
                return object;
            }
            if (!(object instanceof TargetThread)) continue;
            return object;
        }
        return object;
    }

    public DefaultDebuggerTargetTraceMapper getMapper() {
        return this.mapper;
    }

    public DebuggerMemoryMapper getMemoryMapper() {
        return this.memMapper;
    }

    public AsyncLazyMap<TargetRegisterContainer, DebuggerRegisterMapper> getRegMappers() {
        return this.regMappers;
    }

    public Set<TargetBreakpointLocation> getBreakpoints() {
        return this.breakpoints;
    }

    public void attributesChangedBreakpointSpec(TargetObject bpt, Map<String, ?> added) {
        if (added.containsKey("_enabled") || added.containsKey("_kinds")) {
            TargetBreakpointSpec spec = (TargetBreakpointSpec)bpt;
            boolean enabled = spec.isEnabled();
            Set<TraceBreakpointKind> traceKinds = TraceRecorder.targetToTraceBreakpointKinds((Collection<TargetBreakpointSpec.TargetBreakpointKind>)spec.getKinds());
            this.recorder.breakpointRecorder.breakpointSpecChanged(spec, enabled, traceKinds);
        }
    }

    public void attributesChangedBreakpointLocation(TargetObject obj, Map<String, ?> added) {
        TargetBreakpointLocation loc = (TargetBreakpointLocation)obj;
        if (added.containsKey("_range")) {
            AddressRange traceRng = this.recorder.getMemoryMapper().targetToTrace(loc.getRange());
            String path = loc.getJoinedPath(".");
            this.recorder.breakpointRecorder.breakpointLocationChanged(traceRng, path);
        }
    }

    public void attributesChangedMemoryRegion(TargetObject region, Map<String, ?> added) {
        if (added.containsKey("_display")) {
            this.recorder.memoryRecorder.regionChanged((TargetMemoryRegion)region, region.getDisplay());
        }
    }

    public void attributesChangedRegister(TargetObject parent, Map<String, ?> added) {
        TargetRegister register;
        if (added.containsKey("_container")) {
            register = (TargetRegister)parent;
            this.regMappers.get((Object)register.getContainer()).thenAccept(rm -> {
                rm.targetRegisterAdded(register);
                for (ManagedThreadRecorder rec : this.recorder.threadMap.byTargetThread.values()) {
                    rec.regMapperAmended((DebuggerRegisterMapper)rm, register, false);
                }
            });
        }
        if (added.containsKey("_value")) {
            register = (TargetRegister)parent;
            Object val = added.get("_value");
            ManagedThreadRecorder rec = this.recorder.getThreadRecorderForSuccessor((TargetObject)register);
            if (val instanceof String) {
                String valstr = (String)val;
                rec.recordRegisterValue(register, new BigInteger(valstr, 16).toByteArray());
            } else if (val instanceof byte[]) {
                byte[] valarr = (byte[])val;
                rec.recordRegisterValue(register, valarr);
            }
        }
    }

    public void attributesChangedStackFrame(TargetObject frame, Map<String, ?> added) {
        ManagedThreadRecorder rec;
        if (added.containsKey("_pc") && (rec = this.recorder.getThreadRecorderForSuccessor(frame)) != null) {
            rec.getStackRecorder().offerStackFrame((TargetStackFrame)frame);
        }
    }

    public void attributesChangedThread(TargetObject thread, Map<String, ?> added) {
        ManagedThreadRecorder rec;
        if (added.containsKey("_display") && (rec = this.recorder.getThreadRecorderForSuccessor(thread)) != null) {
            String name = (String)added.get("_display");
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)rec.getTrace(), (String)"Rename thread");){
                rec.getTraceThread().setName(name);
            }
        }
    }

    public void elementsChangedBreakpointLocationContainer(TargetObject locationContainer, Map<String, ?> added) {
        TargetObject x = this.findThreadOrProcess(locationContainer);
        if (x != null) {
            for (Map.Entry<String, ?> entry : added.entrySet()) {
                TargetBreakpointLocation loc = (TargetBreakpointLocation)entry.getValue();
                if (!loc.isValid()) continue;
                this.breakpoints.add(loc);
                this.recorder.breakpointRecorder.offerBreakpointLocation(x, loc);
            }
        }
    }

    public void elementsChangedMemory(TargetObject memory, Map<String, ?> added) {
        TargetObject threadOrProcess = this.findThreadOrProcess(memory);
        if (threadOrProcess != null) {
            for (Object object : added.values()) {
                TargetMemoryRegion region = (TargetMemoryRegion)object;
                if (!region.isValid()) continue;
                if (threadOrProcess == this.target) {
                    this.recorder.memoryRecorder.offerProcessRegion(region);
                    continue;
                }
                if (!(threadOrProcess instanceof TargetThread)) continue;
                ManagedThreadRecorder rec = this.recorder.getThreadRecorderForSuccessor(threadOrProcess);
                rec.offerThreadRegion(region);
            }
        } else {
            Msg.error((Object)this, (Object)("Could not find process/thread for " + memory));
        }
    }

    public void elementsChangedSectionContainer(TargetObject sectionContainer, Map<String, ?> added) {
        for (Object object : added.values()) {
            TargetSection section = (TargetSection)object;
            if (!section.isValid()) continue;
            this.recorder.moduleRecorder.offerProcessModuleSection(section);
        }
    }

    public void elementsChangedStack(TargetObject stack, Map<String, ?> added) {
        ManagedStackRecorder rec = this.recorder.getThreadRecorderForSuccessor(stack).getStackRecorder();
        rec.recordStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetMemoryRegion getTargetMemoryRegion(TraceMemoryRegion region) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
        synchronized (navigableMap) {
            return (TargetMemoryRegion)this.objects.get(PathUtils.parse((String)region.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModule getTargetModule(TraceModule module) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
        synchronized (navigableMap) {
            return (TargetModule)this.objects.get(PathUtils.parse((String)module.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetSection getTargetSection(TraceSection section) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
        synchronized (navigableMap) {
            return (TargetSection)this.objects.get(PathUtils.parse((String)section.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetBreakpointLocation getTargetBreakpoint(TraceBreakpoint bpt) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objects;
        synchronized (navigableMap) {
            return (TargetBreakpointLocation)this.objects.get(PathUtils.parse((String)bpt.getPath()));
        }
    }

    public List<TargetBreakpointLocation> collectBreakpoints(TargetThread thread) {
        return this.getBreakpoints().stream().collect(Collectors.toList());
    }

    public void onBreakpointContainers(TargetThread thread, Consumer<? super TargetBreakpointSpecContainer> action) {
        if (thread == null) {
            this.objectListener.onProcessBreakpointContainers(action);
        } else {
            this.objectListener.onThreadBreakpointContainers(thread, action);
        }
    }

    public void onProcessBreakpointContainers(Consumer<? super TargetBreakpointSpecContainer> action) {
        TargetBreakpointSpecContainer breakpointContainer = this.recorder.breakpointRecorder.getBreakpointContainer();
        if (breakpointContainer == null) {
            for (TargetThread thread : this.recorder.getThreadsView()) {
                this.objectListener.onThreadBreakpointContainers(thread, action);
            }
        } else {
            action.accept((TargetBreakpointSpecContainer)breakpointContainer);
        }
    }

    public void onThreadBreakpointContainers(TargetThread thread, Consumer<? super TargetBreakpointSpecContainer> action) {
        TargetBreakpointSpecContainer breakpointContainer = this.recorder.getThreadRecorder(thread).getBreakpointRecorder().getBreakpointContainer();
        if (breakpointContainer == null) {
            return;
        }
        action.accept((TargetBreakpointSpecContainer)breakpointContainer);
    }

    public TraceEventListener getEventListener() {
        return this.eventListener;
    }

    public ListenerSet<TraceRecorderListener> getListeners() {
        return this.listeners;
    }

    public TargetObject getTarget() {
        return this.target;
    }

    public DefaultTraceRecorder getRecorder() {
        return this.recorder;
    }

    public boolean hasObject(TargetObject object) {
        return this.objects.containsKey(object.getPath());
    }

    public void addObject(TargetObject added) {
        this.objects.put(added.getPath(), added);
    }

    public void removeObject(List<String> path) {
        this.objects.remove(path);
    }

    public void disposeModelListeners() {
        this.eventListener.dispose();
        this.objectListener.dispose();
    }

    public CompletableFuture<Void> flushEvents() {
        return this.eventListener.flushEvents().thenCompose(__ -> this.objectListener.flushEvents());
    }
}

