/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class PlaceBreakpointActionItem
implements BreakpointActionItem {
    private final TargetBreakpointSpecContainer container;
    private final Address address;
    private final long length;
    private final Set<TargetBreakpointSpec.TargetBreakpointKind> kinds;

    public PlaceBreakpointActionItem(TargetBreakpointSpecContainer container, Address address, long length, Collection<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        this.container = Objects.requireNonNull(container);
        this.address = Objects.requireNonNull(address);
        this.length = length;
        this.kinds = Set.copyOf(kinds);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlaceBreakpointActionItem)) {
            return false;
        }
        PlaceBreakpointActionItem that = (PlaceBreakpointActionItem)obj;
        if (this.container != that.container) {
            return false;
        }
        if (!this.address.equals((Object)that.address)) {
            return false;
        }
        return Objects.equals(this.kinds, that.kinds);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.container, this.address, this.kinds);
    }

    @Override
    public CompletableFuture<Void> execute() {
        AddressRangeImpl range;
        try {
            range = new AddressRangeImpl(this.address, this.length);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return this.container.placeBreakpoint((AddressRange)range, this.kinds);
    }
}

