/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.frida;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FridaDebuggerProgramLaunchOpinion
implements DebuggerProgramLaunchOpinion {
    @Override
    public Collection<DebuggerProgramLaunchOffer> getOffers(Program program, PluginTool tool, DebuggerModelService service) {
        String exe = program.getExecutablePath();
        if (exe == null || "".equals(exe.trim())) {
            return List.of();
        }
        ArrayList<DebuggerProgramLaunchOffer> offers = new ArrayList<DebuggerProgramLaunchOffer>();
        for (DebuggerModelFactory factory : service.getModelFactories()) {
            if (!factory.isCompatible()) continue;
            String clsName = factory.getClass().getName();
            if (clsName.equals("agent.frida.FridaInJvmDebuggerModelFactory")) {
                offers.add(new InVmFridaDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (!clsName.equals("agent.frida.gadp.FridaLocalDebuggerModelFactory")) continue;
            offers.add(new GadpFridaDebuggerProgramLaunchOffer(program, tool, factory));
        }
        return offers;
    }

    protected class InVmFridaDebuggerProgramLaunchOffer
    extends AbstractFridaDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.frida.FridaInJvmDebuggerModelFactory";

        public InVmFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM Frida";
        }

        @Override
        public String getMenuTitle() {
            return "in Frida locally IN-VM";
        }
    }

    protected class GadpFridaDebuggerProgramLaunchOffer
    extends AbstractFridaDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.frida.gadp.FridaLocalDebuggerModelFactory";

        public GadpFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP Frida";
        }

        @Override
        public String getMenuTitle() {
            return "in Frida locally via GADP";
        }
    }

    protected static abstract class AbstractFridaDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractFridaDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getMenuParentTitle() {
            return "Debug " + this.program.getName();
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"");
        }
    }
}

