/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import com.google.common.collect.Range;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.RangeTableCellRenderer;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.table.column.GColumnRenderer;

public class TracePathLastLifespanPlotColumn
extends AbstractDynamicTableColumn<PathTableModel.PathRow, Range<Long>, Trace> {
    private final RangeTableCellRenderer<Long> cellRenderer = new RangeTableCellRenderer();
    private final RangeCursorTableHeaderRenderer<Long> headerRenderer = new RangeCursorTableHeaderRenderer();

    public String getColumnName() {
        return "Plot";
    }

    public Range<Long> getValue(PathTableModel.PathRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        TraceObjectValue lastEntry = rowObject.getPath().getLastEntry();
        if (lastEntry == null) {
            return Range.all();
        }
        return lastEntry.getLifespan();
    }

    public GColumnRenderer<Range<Long>> getColumnRenderer() {
        return this.cellRenderer;
    }

    public GTableHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setFullRange(Range<Long> fullRange) {
        this.cellRenderer.setFullRange(fullRange);
        this.headerRenderer.setFullRange(fullRange);
    }

    public void setSnap(long snap) {
        this.headerRenderer.setCursorPosition((Number)snap);
    }

    public void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener listener) {
        this.headerRenderer.addSeekListener(listener);
    }
}

