/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SchemaBuilder {
    private final DefaultSchemaContext context;
    private final TargetObjectSchema.SchemaName name;
    private Class<?> type = TargetObject.class;
    private Set<Class<? extends TargetObject>> interfaces = new LinkedHashSet<Class<? extends TargetObject>>();
    private boolean isCanonicalContainer = false;
    private Map<String, TargetObjectSchema.SchemaName> elementSchemas = new LinkedHashMap<String, TargetObjectSchema.SchemaName>();
    private TargetObjectSchema.SchemaName defaultElementSchema = EnumerableTargetObjectSchema.OBJECT.getName();
    private TargetObjectSchema.ResyncMode elementResync = TargetObjectSchema.DEFAULT_ELEMENT_RESYNC;
    private Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas = new LinkedHashMap<String, TargetObjectSchema.AttributeSchema>();
    private TargetObjectSchema.AttributeSchema defaultAttributeSchema = TargetObjectSchema.AttributeSchema.DEFAULT_ANY;
    private TargetObjectSchema.ResyncMode attributeResync = TargetObjectSchema.DEFAULT_ATTRIBUTE_RESYNC;
    private Map<String, Object> elementOrigins = new LinkedHashMap<String, Object>();
    private Map<String, Object> attributeOrigins = new LinkedHashMap<String, Object>();

    public SchemaBuilder(DefaultSchemaContext context, TargetObjectSchema.SchemaName name) {
        this.context = context;
        this.name = name;
    }

    public SchemaBuilder setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public SchemaBuilder setInterfaces(Set<Class<? extends TargetObject>> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
        return this;
    }

    public Set<Class<? extends TargetObject>> getInterfaces() {
        return Set.copyOf(this.interfaces);
    }

    public SchemaBuilder addInterface(Class<? extends TargetObject> iface) {
        this.interfaces.add(iface);
        return this;
    }

    public SchemaBuilder removeInterface(Class<? extends TargetObject> iface) {
        this.interfaces.remove(iface);
        return this;
    }

    public SchemaBuilder setCanonicalContainer(boolean isCanonicalContainer) {
        this.isCanonicalContainer = isCanonicalContainer;
        return this;
    }

    public boolean isCanonicalContaineration() {
        return this.isCanonicalContainer;
    }

    public SchemaBuilder addElementSchema(String index, TargetObjectSchema.SchemaName schema, Object origin) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(schema);
        }
        if (this.elementSchemas.containsKey(index)) {
            throw new IllegalArgumentException("Duplicate element index '" + index + "' origin1=" + this.elementOrigins.get(index) + " origin2=" + origin);
        }
        this.elementSchemas.put(index, schema);
        this.elementOrigins.put(index, origin);
        return this;
    }

    public SchemaBuilder removeElementSchema(String index) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(EnumerableTargetObjectSchema.OBJECT.getName());
        }
        this.elementSchemas.remove(index);
        this.elementOrigins.remove(index);
        return this;
    }

    public Map<String, TargetObjectSchema.SchemaName> getElementSchemas() {
        return Map.copyOf(this.elementSchemas);
    }

    public SchemaBuilder setDefaultElementSchema(TargetObjectSchema.SchemaName defaultElementSchema) {
        this.defaultElementSchema = defaultElementSchema;
        return this;
    }

    public TargetObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    public SchemaBuilder setElementResyncMode(TargetObjectSchema.ResyncMode elementResync) {
        this.elementResync = elementResync;
        return this;
    }

    public TargetObjectSchema.ResyncMode getElementResyncMode() {
        return this.elementResync;
    }

    public SchemaBuilder addAttributeSchema(TargetObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        if (this.attributeSchemas.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Duplicate attribute name '" + schema.getName() + "' origin1=" + this.attributeOrigins.get(schema.getName()) + " origin2=" + origin);
        }
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    public SchemaBuilder removeAttributeSchema(String name) {
        if (name.equals("")) {
            return this.setDefaultAttributeSchema(TargetObjectSchema.AttributeSchema.DEFAULT_ANY);
        }
        this.attributeSchemas.remove(name);
        this.attributeOrigins.remove(name);
        return this;
    }

    public Map<String, TargetObjectSchema.AttributeSchema> getAttributeSchemas() {
        return Map.copyOf(this.attributeSchemas);
    }

    public TargetObjectSchema.AttributeSchema getAttributeSchema(String name) {
        return this.attributeSchemas.get(name);
    }

    public SchemaBuilder replaceAttributeSchema(TargetObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    public SchemaBuilder setDefaultAttributeSchema(TargetObjectSchema.AttributeSchema defaultAttributeSchema) {
        this.defaultAttributeSchema = defaultAttributeSchema;
        return this;
    }

    public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    public SchemaBuilder setAttributeResyncMode(TargetObjectSchema.ResyncMode attributeResync) {
        this.attributeResync = attributeResync;
        return this;
    }

    public TargetObjectSchema.ResyncMode getAttributeResyncMode() {
        return this.attributeResync;
    }

    public TargetObjectSchema buildAndAdd() {
        TargetObjectSchema schema = this.build();
        this.context.putSchema(schema);
        return schema;
    }

    public TargetObjectSchema build() {
        return new DefaultTargetObjectSchema(this.context, this.name, this.type, this.interfaces, this.isCanonicalContainer, this.elementSchemas, this.defaultElementSchema, this.elementResync, this.attributeSchemas, this.defaultAttributeSchema, this.attributeResync);
    }
}

