/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction23x
extends Instruction
implements ThreeRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private byte regC;

    public Instruction23x(Opcode opcode, short regA, short regB, short regC) {
        super(opcode);
        if (regA >= 256 || regB >= 256 || regC >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
        this.regB = (byte)regB;
        this.regC = (byte)regC;
    }

    private Instruction23x(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.regB = buffer[bufferIndex + 2];
        this.regC = buffer[bufferIndex + 3];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeByte(this.regB);
        out.writeByte(this.regC);
    }

    @Override
    public Format getFormat() {
        return Format.Format23x;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFF;
    }

    @Override
    public int getRegisterC() {
        return this.regC & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction23x(opcode, buffer, bufferIndex);
        }
    }
}

