/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.Analysis.InlineMethodResolver;
import org.jf.dexlib.Code.OdexedInvokeInline;

public class CustomInlineMethodResolver
extends InlineMethodResolver {
    private DeodexUtil.InlineMethod[] inlineMethods;
    private static final Pattern longMethodPattern = Pattern.compile("(L[^;]+;)->([^(]+)\\(([^)]*)\\)(.+)");

    public CustomInlineMethodResolver(String inlineTable) {
        FileReader fr = null;
        try {
            fr = new FileReader(inlineTable);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Could not find inline table file: " + inlineTable);
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(fr);
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while reading file: " + inlineTable, ex);
        }
        this.inlineMethods = new DeodexUtil.InlineMethod[lines.size()];
        for (int i = 0; i < this.inlineMethods.length; ++i) {
            this.inlineMethods[i] = this.parseAndResolveInlineMethod((String)lines.get(i));
        }
    }

    @Override
    public DeodexUtil.InlineMethod resolveExecuteInline(AnalyzedInstruction analyzedInstruction) {
        assert (analyzedInstruction.instruction instanceof OdexedInvokeInline);
        OdexedInvokeInline instruction = (OdexedInvokeInline)((Object)analyzedInstruction.instruction);
        int methodIndex = instruction.getInlineIndex();
        if (methodIndex < 0 || methodIndex >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid method index: " + methodIndex);
        }
        return this.inlineMethods[methodIndex];
    }

    private DeodexUtil.InlineMethod parseAndResolveInlineMethod(String inlineMethod) {
        Matcher m = longMethodPattern.matcher(inlineMethod);
        if (!m.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + inlineMethod);
        }
        String className = m.group(1);
        String methodName = m.group(2);
        String methodParams = m.group(3);
        String methodRet = m.group(4);
        ClassPath.ClassDef classDef = ClassPath.getClassDef(className, false);
        int methodType = classDef.getMethodType(String.format("%s(%s)%s", methodName, methodParams, methodRet));
        if (methodType == -1) {
            throw new RuntimeException("Cannot resolve inline method: " + inlineMethod);
        }
        return new DeodexUtil.InlineMethod(methodType, className, methodName, methodParams, methodRet);
    }
}

