/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CollectionUtils {
    private CollectionUtils() {
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        HashSet<T> set = new HashSet<T>();
        if (items == null) {
            return set;
        }
        if (items.length == 1 && items[0] == null) {
            return set;
        }
        for (T e : items) {
            set.add(e);
        }
        return set;
    }

    public static <T> Set<T> asSet(Collection<T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        if (c == null) {
            return new HashSet();
        }
        return new HashSet<T>(c);
    }

    public static <T> Set<T> asSet(Iterator<T> it) {
        HashSet<T> set = new HashSet<T>();
        if (it == null) {
            return set;
        }
        while (it.hasNext()) {
            T t = it.next();
            set.add(t);
        }
        return set;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        HashSet<T> set = new HashSet<T>();
        if (iterable == null) {
            return set;
        }
        for (T t : iterable) {
            set.add(t);
        }
        return set;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... items) {
        ArrayList<T> list = new ArrayList<T>();
        if (items == null) {
            return list;
        }
        if (items.length == 1 && items[0] == null) {
            return list;
        }
        for (T arrayElement : items) {
            list.add(arrayElement);
        }
        return list;
    }

    public static <T> List<T> asList(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static <T> List<T> asList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        if (c == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(c);
    }

    public static <T> Collection<T> nonNull(Collection<T> c) {
        return CollectionUtils.asCollection(c);
    }

    public static <T> Collection<T> asCollection(Collection<T> c) {
        if (c == null) {
            return new HashSet();
        }
        return c;
    }

    public static <T> List<T> asList(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        if (enumeration == null) {
            return list;
        }
        while (enumeration.hasMoreElements()) {
            T t = enumeration.nextElement();
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> asList(Iterable<T> it) {
        return CollectionUtils.asList(it.iterator());
    }

    public static <T> List<T> asList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        if (it == null) {
            return list;
        }
        while (it.hasNext()) {
            T t = it.next();
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> asList(List<?> list, Class<T> clazz) {
        if (list == null) {
            return new ArrayList();
        }
        for (Object object : list) {
            if (clazz.isAssignableFrom(object.getClass())) continue;
            throw new IllegalArgumentException("Given list contains data that is not the type: " + clazz + ".  Value: " + object.getClass());
        }
        return list;
    }

    public static <T> Collection<T> asCollection(Collection<?> collection, Class<T> clazz) {
        for (Object object : collection) {
            if (clazz.isAssignableFrom(object.getClass())) continue;
            throw new IllegalArgumentException("Given collection contains data that is not the type: " + clazz + ".  Value: " + object.getClass());
        }
        return collection;
    }

    public static <T> boolean isAllSameType(Collection<?> list, Class<T> clazz) {
        for (Object object : list) {
            if (clazz.isAssignableFrom(object.getClass())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T t, T ... possibles) {
        for (T possible : possibles) {
            if (!Objects.equals(possible, t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Object ... objects) {
        return CollectionUtils.isAllNull(Arrays.asList(objects));
    }

    public static <T> boolean isAllNull(Collection<T> c) {
        if (c == null) {
            return true;
        }
        for (T t : c) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isBlank(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static <T> boolean isBlank(T ... t) {
        return t == null || t.length == 0;
    }

    public static <T> Iterable<T> asIterable(T t) {
        return Arrays.asList(t);
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(Iterable<T> ... iterables) {
        Stream<T> s = CollectionUtils.asStream(iterables);
        return CollectionUtils.asIterable(s.iterator());
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator) {
        return CollectionUtils.asStream(CollectionUtils.asIterable(iterator));
    }

    @SafeVarargs
    public static <T> Stream<T> asStream(Iterable<T> ... iterables) {
        Stream s = Stream.of(iterables).flatMap(e -> StreamSupport.stream(e.spliterator(), false));
        return s;
    }

    public static <T> T any(Collection<T> c) {
        return CollectionUtils.any(c);
    }

    public static <T> T any(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

