/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.exception.AssertException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Predicate;

public class DateUtils {
    private static final String DATE_TIME_FORMAT_STRING = "MMM dd, yyyy hh:mm a";
    private static final String DATE_FORMAT_STRING = "MM/dd/yyyy";
    private static final String TIME_FORMAT_STRING = "h:mm";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MMM dd, yyyy hh:mm a");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("h:mm");
    public static final long MS_PER_SEC = 1000L;
    public static final long MS_PER_MIN = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;

    public static List<Date> getHolidays(int year) {
        ArrayList<Date> holidays = new ArrayList<Date>();
        holidays.add(DateUtils.getNewYearsHoliday(year));
        holidays.add(DateUtils.getMLKDay(year));
        holidays.add(DateUtils.getPresidentsDay(year));
        holidays.add(DateUtils.getMemorialDay(year));
        holidays.add(DateUtils.getIndependanceHoliday(year));
        holidays.add(DateUtils.getLaborDay(year));
        holidays.add(DateUtils.getColumbusDay(year));
        holidays.add(DateUtils.getVeterensDay(year));
        holidays.add(DateUtils.getThanksgivingDay(year));
        holidays.add(DateUtils.getChristmasHoliday(year));
        return holidays;
    }

    public static boolean isHoliday(Date date) {
        date = DateUtils.normalizeDate(date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int month = cal.get(2);
        int year = cal.get(1);
        switch (month) {
            case 0: {
                return date.equals(DateUtils.getNewYearsHoliday(year)) || date.equals(DateUtils.getMLKDay(year));
            }
            case 1: {
                return date.equals(DateUtils.getPresidentsDay(year));
            }
            case 4: {
                return date.equals(DateUtils.getMemorialDay(year));
            }
            case 6: {
                return date.equals(DateUtils.getIndependanceHoliday(year));
            }
            case 8: {
                return date.equals(DateUtils.getLaborDay(year));
            }
            case 9: {
                return date.equals(DateUtils.getColumbusDay(year));
            }
            case 10: {
                return date.equals(DateUtils.getVeterensDay(year)) || date.equals(DateUtils.getThanksgivingDay(year));
            }
            case 11: {
                return date.equals(DateUtils.getChristmasHoliday(year)) || date.equals(DateUtils.getNewYearsHoliday(year + 1));
            }
        }
        return false;
    }

    public static Date getNormalizedToday() {
        return DateUtils.normalizeDate(new Date());
    }

    private static Date getChristmasHoliday(int year) {
        GregorianCalendar cal = new GregorianCalendar(year, 11, 25);
        DateUtils.adjustForWeekend(cal);
        return cal.getTime();
    }

    private static Date getThanksgivingDay(int year) {
        Calendar cal = DateUtils.getFirstDayOfWeekInMonth(year, 10, 5);
        cal.add(5, 21);
        return cal.getTime();
    }

    private static Date getVeterensDay(int year) {
        GregorianCalendar cal = new GregorianCalendar(year, 10, 11);
        DateUtils.adjustForWeekend(cal);
        return cal.getTime();
    }

    private static Date getColumbusDay(int year) {
        Calendar cal = DateUtils.getFirstDayOfWeekInMonth(year, 9, 2);
        cal.add(5, 7);
        return cal.getTime();
    }

    private static Date getLaborDay(int year) {
        Calendar cal = DateUtils.getFirstDayOfWeekInMonth(year, 8, 2);
        return cal.getTime();
    }

    private static Date getIndependanceHoliday(int year) {
        GregorianCalendar cal = new GregorianCalendar(year, 6, 4);
        DateUtils.adjustForWeekend(cal);
        return cal.getTime();
    }

    private static Date getMemorialDay(int year) {
        Calendar cal = DateUtils.getLastDayOfWeekInMonth(year, 4, 2);
        return cal.getTime();
    }

    private static Date getPresidentsDay(int year) {
        Calendar cal = DateUtils.getFirstDayOfWeekInMonth(year, 1, 2);
        cal.add(5, 14);
        return cal.getTime();
    }

    private static Date getMLKDay(int year) {
        Calendar cal = DateUtils.getFirstDayOfWeekInMonth(year, 0, 2);
        cal.add(5, 14);
        return cal.getTime();
    }

    private static Date getNewYearsHoliday(int year) {
        GregorianCalendar cal = new GregorianCalendar(year, 0, 1);
        DateUtils.adjustForWeekend(cal);
        return cal.getTime();
    }

    private static Calendar getFirstDayOfWeekInMonth(int year, int month, int dayOfWeek) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        int day = cal.get(7);
        while (day != dayOfWeek) {
            ((Calendar)cal).add(7, 1);
            day = cal.get(7);
        }
        return cal;
    }

    private static void adjustForWeekend(Calendar cal) {
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 7) {
            cal.add(5, -1);
        }
        if (dayOfWeek == 1) {
            cal.add(5, 1);
        }
    }

    private static Calendar getLastDayOfWeekInMonth(int year, int month, int dayOfWeek) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        ((Calendar)cal).add(2, 1);
        ((Calendar)cal).add(5, -1);
        int day = cal.get(7);
        while (day != dayOfWeek) {
            ((Calendar)cal).add(7, -1);
            day = cal.get(7);
        }
        return cal;
    }

    public static boolean isHoliday(Calendar cal) {
        return DateUtils.isHoliday(cal.getTime());
    }

    public static boolean isWeekend(Calendar cal) {
        int dayOfWeek = cal.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    public static Date normalizeDate(Date date) {
        try {
            DateTimeFormatter dtf = DATE_FORMATTER;
            TemporalAccessor ta = dtf.parse(dtf.format(DateUtils.toLocalDate(date)));
            LocalDate localDateTime = LocalDate.from(ta);
            return DateUtils.toDate(localDateTime);
        }
        catch (DateTimeParseException e) {
            throw new AssertException("Unexpected exception parsing date from a known format", (Throwable)e);
        }
    }

    public static String formatDate(Date date) {
        return DATE_FORMATTER.format(DateUtils.toLocalDate(date));
    }

    public static String formatDateTimestamp(Date date) {
        return DATE_TIME_FORMATTER.format(DateUtils.toLocalDate(date));
    }

    public static String formatCurrentTime() {
        return TIME_FORMATTER.format(DateUtils.toLocalDate(new Date()));
    }

    public static LocalDateTime toLocalDate(Date d) {
        return Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDate ld) {
        return Date.from(ld.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        return cal.getTime();
    }

    public static int getDaysBetween(Date date1, Date date2) {
        return DateUtils.doGetDaysBetween(date1, date2, DateUtils::anyDay);
    }

    public static int getBusinessDaysBetween(Date date1, Date date2) {
        return DateUtils.doGetDaysBetween(date1, date2, DateUtils::isBusinessDay);
    }

    private static boolean anyDay(Calendar c) {
        return true;
    }

    private static boolean isBusinessDay(Calendar c) {
        return !DateUtils.isWeekend(c) && !DateUtils.isHoliday(c);
    }

    private static int doGetDaysBetween(Date date1, Date date2, Predicate<Calendar> dayFilter) {
        Date d1 = date1;
        Date d2 = date2;
        if (date1.compareTo(date2) > 0) {
            d1 = date2;
            d2 = date1;
        }
        d1 = DateUtils.normalizeDate(d1);
        d2 = DateUtils.normalizeDate(d2);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d1);
        int days = 0;
        while (cal.getTime().compareTo(d2) < 0) {
            ((Calendar)cal).add(5, 1);
            if (!dayFilter.test(cal)) continue;
            ++days;
        }
        return days;
    }

    public static String formatDuration(long millis) {
        long days = 0L;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (millis >= 86400000L) {
            days = millis / 86400000L;
            millis %= 86400000L;
        }
        if (millis >= 3600000L) {
            hours = (int)(millis / 3600000L);
            millis %= 3600000L;
        }
        if (millis >= 60000L) {
            minutes = (int)(millis / 60000L);
            millis %= 60000L;
        }
        if (millis >= 1000L) {
            seconds = (int)(millis / 1000L);
            millis %= 1000L;
        }
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(Long.toString(days)).append(" days, ");
        }
        if (sb.length() > 0 || hours > 0) {
            sb.append(Integer.toString(hours)).append(" hours, ");
        }
        if (sb.length() > 0 || minutes > 0) {
            sb.append(Integer.toString(minutes)).append(" mins, ");
        }
        sb.append(Integer.toString(seconds)).append(" secs");
        return sb.toString();
    }
}

