/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;
import generic.stl.ReverseSetIterator;
import generic.stl.SetIterator;
import java.util.Comparator;

public class SetSTL<K> {
    RedBlackTree<K, K> rbTree;

    public SetSTL(Comparator<K> comparator) {
        this.rbTree = new RedBlackTree(comparator, false);
    }

    public SetSTL(SetSTL<K> set) {
        this.rbTree = new RedBlackTree<K, K>(set.rbTree);
    }

    public Pair<IteratorSTL<K>, Boolean> insert(K key) {
        Pair<RedBlackNode<K, K>, Boolean> result = this.rbTree.put(key, key);
        return new Pair<IteratorSTL<K>, Boolean>(new SetIterator<K>(this.rbTree, (RedBlackNode)result.first), (Boolean)result.second);
    }

    public boolean contains(K key) {
        return this.rbTree.containsKey(key);
    }

    public boolean remove(K key) {
        return this.rbTree.remove(key) != null;
    }

    public IteratorSTL<K> find(K key) {
        RedBlackNode<K, K> node = this.rbTree.findFirstNode(key);
        if (node == null) {
            return this.end();
        }
        return new SetIterator<K>(this.rbTree, node);
    }

    public void erase(IteratorSTL<K> iterator) {
        SetIterator it = (SetIterator)iterator;
        RedBlackNode node = it.node;
        if (node == null) {
            throw new IndexOutOfBoundsException();
        }
        it.node = node.getSuccessor();
        it.erased = true;
        this.rbTree.deleteEntry(node);
    }

    public IteratorSTL<K> begin() {
        return new SetIterator<K>(this.rbTree, this.rbTree.getFirst());
    }

    public IteratorSTL<K> end() {
        return new SetIterator<K>(this.rbTree, null);
    }

    public IteratorSTL<K> rBegin() {
        return new ReverseSetIterator<K>(this.rbTree, this.rbTree.getLast());
    }

    public IteratorSTL<K> rEnd() {
        return new ReverseSetIterator<K>(this.rbTree, null);
    }

    public IteratorSTL<K> lower_bound(K key) {
        RedBlackNode<K, K> node = this.rbTree.lowerBound(key);
        return new SetIterator<K>(this.rbTree, node);
    }

    public IteratorSTL<K> upper_bound(K key) {
        RedBlackNode<K, K> node = this.rbTree.upperBound(key);
        SetIterator<K> it = new SetIterator<K>(this.rbTree, node);
        return it;
    }

    public void erase(K key) {
        this.rbTree.remove(key);
    }

    public void clear() {
        this.rbTree.removeAll();
    }

    public boolean isEmpty() {
        return this.rbTree.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        IteratorSTL<K> ii = this.begin();
        while (!ii.isEnd()) {
            K thing = ii.get();
            sb.append(thing.toString());
            sb.append(" ");
            ii.increment();
        }
        sb.append("}");
        return sb.toString();
    }
}

